import os
from setuptools import setup, find_packages

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))


# Get all of the Linux_x86_64/ data/ test/ files for use as package data
def recursive_walk(startdir):
    file_list = []
    for dirname, subdirList, fileList in os.walk(startdir, followlinks=True):
        if '.svn' in subdirList:
            subdirList.remove('.svn')
        if '.git' in subdirList:
            subdirList.remove('.git')
        for fname in fileList:
            file_list.append(os.path.join(dirname, fname))
            for sdname in subdirList:
                sdfiles = recursive_walk(sdname)
                file_list.extend(sdfiles)
    return file_list

pkg_data_files = ['blosum62.qij']
os.chdir('icerfire_1_0_executable')

for subdir in ['data', 'bin', 'test', 'bashscripts', 'src']:
    file_list = recursive_walk(subdir)
    pkg_data_files.extend(file_list)
os.chdir(os.pardir)

with open(os.path.join(os.path.dirname(__file__), 'README.rst')) as readme:
    README = readme.read()

with open('requirements.txt') as f:
    required = f.readlines()

setup(
    name='icerfire-1.0-executable',
    version='1.0.5',
    author='Zhen Yan',
    author_email='jyan@lji.org',
    packages=['icerfire_1_0_executable'],
    package_data={ 'icerfire_1_0_executable': pkg_data_files },
    description='Python package to provide ICERFIRE executable',
    long_description=README,
    install_requires=required,
    keywords='ICERFIRE prediction',
    classifiers=[
        'Intended Audience :: Developers',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python :: 3',
    ]
)

