#!/usr/bin/env python
from __future__ import print_function
import sys
import os
import logging
import random
import string
from os.path import isfile
#from urllib.request import urlopen
from shutil import copyfileobj
from optparse import OptionParser
logging.basicConfig(level=logging.INFO, format='%(asctime)s,%(msecs)d %(levelname)-8s [%(filename)s:%(lineno)d] %(message)s', datefmt='%Y-%m-%d:%H:%M:%S',)

# adding all packages in method folder to the python path
script_dir = os.path.dirname(os.path.realpath(__file__))
sys.path.append(script_dir )
methods_dir = os.path.abspath(os.path.join(script_dir, '../method'))

for method_dir_name in os.listdir(methods_dir):
    method_base_dir = os.path.join(methods_dir, method_dir_name)
    if os.path.isdir(method_base_dir):
        sys.path.append(method_base_dir)

def generate_random_str(length):
    return ''.join(random.sample(string.digits+string.ascii_letters, length))

def eprint(*args, **kwargs):
    print(*args, file=sys.stderr, **kwargs)


def read_peptides(fname):
    with open(fname, 'r') as r_file:
        peptides = r_file.readlines()
        peptides = [row.strip() for row in peptides if row.strip()]
        return peptides

def group_peptides_by_length(peptide_list):
    peptide_groups_by_length = []
    lengths = set(map(len, peptide_list))
    for length in lengths:
        peptide_groups_by_length.append([pep for pep in peptide_list if len(pep) == length])
    return peptide_groups_by_length

import importlib

def load_env_from_py(module_name):
    # Dynamically import the module
    module = importlib.import_module(module_name)

    # Loop over the module's dictionary of variables
    for key, value in module.__dict__.items():
        # Ignore built-in attributes (those that start with '__')
        if not key.startswith('__'):
            # Convert value to string and set it in the environment
            os.environ[key] = str(value)
            #print(f"Set {key}={value} to environment variables")

# Example usage
load_env_from_py('path_config')

from aggregation import merge_peptidea_peptideb_result, merge_icerfire_result
from split import split_sequences
from predictions import run_all
script_dir = os.path.dirname(os.path.realpath(__file__))


class Prediction:
    
    def __init__(self):
        self.version = '0.1 Beta'
        self.row_data = []


    @staticmethod
    def print_method_versions():
        version_info = (
            "tool_group\tmethod\tversion\n"
            "-------\t-------\t-------\n"
            "binding\tconsensus\t2.18\n"
            "binding\tann\t4.0\n"
            "binding\tnetmhcpan_ba\t4.1\n"
            "binding\tnetmhcpan_el\t4.1\n"
            "binding\tcomblib_sidney2008\t1.0\n"
            "binding\tsmm\t1.0\n"
            "binding\tsmmpmbec\t1.0\n"
            "immunogenicity\timmunogenicity\t1.0\n"
        )
        print(version_info)

    @staticmethod
    def commandline_help(parser):
        print()
        # read in the example_commands.txt file and print it out
        f = open(os.path.join(script_dir, 'example_commands.txt'), 'r')
        lines = f.readlines()
        print("".join(lines))
        parser.print_help()
        f.close()

    def main(self):

        try:
            usage = "See README for usage information."

            parser = OptionParser(usage=usage, version="%prog {}".format(self.version), add_help_option=False)

            parser.add_option("-h", "--help",
                              action="store_true",
                              dest="help",
                              default=False,
                              help="print available commands.")

            parser.add_option("--split",
                              action="store_true",
                              dest="split_parameters_flag",
                              default=False,
                              help="flag to indicate the action we want to take with the standalone: split parameters into JSON files")

            parser.add_option("--split-dir",
                              dest="split_parameters_dir",
                              default='',
                              help="the diretory for the JSON files that input parameters splitted into")

            parser.add_option("--split-inputs-dir",
                              dest="split_inputs_dir",
                              default=None,
                              help="the diretory for the sequence and peptide files that input sequences splitted into")

            parser.add_option("--aggregate",
                              action="store_true",
                              dest="aggregate_parameters_flag",
                              default=False,
                              help="flag to indicate the action to aggregate the results")

            parser.add_option("--job-desc-file",
                              dest="job_desc_file",
                              default='',
                              help="the file path for the job description")

            parser.add_option("--aggregate-input-dir",
                              dest="aggregate_input_dir",
                              default='',
                              help="the diretory for the JSON files which have input parameters")

            parser.add_option("--peptidea-result-path", "--peptideA-result-path",
                              dest="peptidea_result_path",
                              default='',
                              help="the path for peptidea peptide prediciton result")

            parser.add_option("--peptideb-result-path", "--peptideB-result-path",
                              dest="peptideb_result_path",
                              default='',
                              help="the path for peptidea peptide prediciton result")

            parser.add_option("--icerfire-result-path",
                              dest="icerfire_result_path",
                              default='',
                              help="the path for icerfire prediciton result")
            
            parser.add_option("--aggregate-output-path",
                              dest="aggregate_output_path",
                              default='',
                              help="the path for the JSON file contains results need to be aggregated as well as the place we place the final result file")

            parser.add_option("--keep-empty-row",
                              action="store_true",
                              dest="keep_empty_row",
                              default=False,
                              help="flag to indicate keeping empty rows for results aggregation")

            parser.add_option("--input-dir", "-i", dest="input_dir",
                              help="input dir for JSON files.", metavar="INPUT_DIR")

            parser.add_option("--run-predictor",
                              action="store_true",
                              dest="predictor_flag",
                              default=True,
                              help="flag to indicate the action we want to take with the standalone: run predictor with atom unit")

            parser.add_option("--assume-valid",
                              action="store_true",
                              dest="assume_valid_flag",
                              default=False,
                              help="flag to indicate skiping validation")

            parser.add_option("-j", dest="json_filename",
                              help="FILE containing all parameters.", metavar="JSON_FILE")

            parser.add_option("--output-prefix", "-o", dest="output_prefix",
                              help="prediction result output path and prefix.", metavar="OUTPUT_PREFIX")

            parser.add_option("--output-format", "-f", dest="output_format", default="tsv",
                              help="prediction result output format.", metavar="OUTPUT_FORMAT")

            (options, args) = parser.parse_args()
            if options.help:
                self.commandline_help(parser)
                exit(0)

            if options.aggregate_parameters_flag and options.icerfire_result_path:
                print(merge_icerfire_result(options.icerfire_result_path, options.aggregate_output_path, options.keep_empty_row))
                exit(0)

            if options.aggregate_parameters_flag:
                print(merge_peptidea_peptideb_result(options.peptidea_result_path, options.peptideb_result_path, options.aggregate_output_path, options.keep_empty_row))
                exit(0)

            if options.split_parameters_flag:
                split_sequences(options.json_filename, options.split_parameters_dir, options.split_inputs_dir, options.assume_valid_flag)
                exit(0)

            if options.json_filename:
                run_all(options.json_filename, options.output_prefix, options.output_format, options.assume_valid_flag)
                exit(0)

            if not (options.split_parameters_flag or options.aggregate_parameters_flag):
                self.commandline_help(parser)
                exit(0)

            if not sys.stdin.isatty():
                stdin = sys.stdin.readline().strip()
                args.append(stdin)
 
        except Exception as e:
            eprint("Error: ", str(e))
            eprint("Please refer to the README for usage instructions, and if the issue persists, contact help@iedb.org for assistance.")
            exit(1)

if __name__ == '__main__':
    Prediction().main()


