#! /usr/bin/python
import os
import unittest
import json


class UtilTest(unittest.TestCase):
    maxDiff = None

    def test_example(self):
        self.assertEqual(1, 1)

    def test_os_popen_example(self):
        cmd = 'echo example'
        with os.popen(cmd) as process:
            result = process.read()
        self.assertEqual(result, 'example\n')

    def test_help(self):
        cmd = 'python3 src/run_pvc.py -h'
        with os.popen(cmd) as process:
            result = process.read()

        with open(os.path.join(os.path.dirname(__file__), 'src', 'example_commands.txt'), 'r') as f:
            expected_output = f.read() + "\n"
        # expected_output is the first part of the help message
        self.assertIn(expected_output, result)

        # If no options are given, help info will be returned as well
        cmd = 'python3 src/run_pvc.py'
        with os.popen(cmd) as process:
            result = process.read()
        self.assertIn(expected_output, result)


class TestCommonPrediction(unittest.TestCase):
    maxDiff = None

    def test_mhci(self):
        cmd = "python3 src/run_pvc.py -j test_data/mhci/input.json -o test_data/mhci/output -f json"
        with os.popen(cmd) as process:
            printed_result = process.read()
        with open('test_data/mhci/output.json', 'r') as f:
            result = json.load(f)
        with open('test_data/mhci/expected_output.json', 'r') as f:
            expected_output = json.load(f)
        self.assertEqual(result, expected_output)

    def test_mhcii(self):
        cmd = "python3 src/run_pvc.py -j test_data/mhcii/input.json -o test_data/mhcii/output -f json"
        with os.popen(cmd) as process:
            printed_result = process.read()
        with open('test_data/mhcii/output.json', 'r') as f:
            result = json.load(f)
        with open('test_data/mhcii/expected_output.json', 'r') as f:
            expected_output = json.load(f)
        self.assertEqual(result, expected_output)

class TestMHCI(unittest.TestCase):
    maxDiff = None

    def test_netmhcpan_el(self):
        self._run_test("mhci/netmhcpan_el")

    def test_netmhcpan_ba(self):
        self._run_test("mhci/netmhcpan_ba")

    def test_consensus(self):
        self._run_test("mhci/consensus")

    def test_ann(self):
        self._run_test("mhci/ann")

    def test_smmpmbec(self):
        self._run_test("mhci/smmpmbec")

    def test_smm(self):
        self._run_test("mhci/smm")

    def test_comblib_sidney2008(self):
        self._run_test("mhci/comblib_sidney2008")

    def test_mhcflurry(self):
        self._run_test("mhci/mhcflurry")

    def test_mhcnp(self):
        self._run_test("mhci/mhcnp")

    def test_immunogenicity(self):
        self._run_test("mhci/immunogenicity")

    def _run_test(self, folder):
        cmd = f"python3 src/run_pvc.py -j test_data/{folder}/input.json -o test_data/{folder}/output -f json"
        with os.popen(cmd) as process:
            process.read()
        with open(f"test_data/{folder}/output.json", "r") as f:
            result = json.load(f)
        with open(f"test_data/{folder}/expected_output.json", "r") as f:
            expected_output = json.load(f)
        self.assertEqual(result, expected_output)


class TestMHCII(unittest.TestCase):
    maxDiff = None

    def test_netmhciipan_el(self):
        self._run_test("mhcii/netmhciipan_el")

    def test_netmhciipan_ba(self):
        self._run_test("mhcii/netmhciipan_ba")

    def test_netmhciipan_el_4_3(self):
        self._run_test("mhcii/netmhciipan_el-4.3")

    def test_netmhciipan_ba_4_3(self):
        self._run_test("mhcii/netmhciipan_ba-4.3")

    def test_netmhciipan_el_4_2(self):
        self._run_test("mhcii/netmhciipan_el-4.2")

    def test_netmhciipan_ba_4_2(self):
        self._run_test("mhcii/netmhciipan_ba-4.2")

    def test_consensus(self):
        self._run_test("mhcii/consensus")

    def test_nn_align(self):
        self._run_test("mhcii/nn_align")

    def test_smm_align(self):
        self._run_test("mhcii/smm_align")

    def test_comblib(self):
        self._run_test("mhcii/comblib")

    def test_tepitope(self):
        self._run_test("mhcii/tepitope")

    def test_cd4episcore(self):
        self._run_test("mhcii/cd4episcore")

    def _run_test(self, folder):
        cmd = f"python3 src/run_pvc.py -j test_data/{folder}/input.json -o test_data/{folder}/output -f json"
        with os.popen(cmd) as process:
            process.read()
        with open(f"test_data/{folder}/output.json", "r") as f:
            result = json.load(f)
        with open(f"test_data/{folder}/expected_output.json", "r") as f:
            expected_output = json.load(f)
        self.assertEqual(result, expected_output)


if __name__ == "__main__":
    unittest.main()
