#!/bin/bash

PVC_PATH=$(pwd)

# donwload and unzip the required standalone files (mhci and mhcii)
# Usage: ./download_required_standalone.sh
# Check if the required directories exist, if not create them
mkdir -p ./standalone
cd ./standalone
# Download mhci files
wget https://downloads.iedb.org/nextgen-tools/tcell_mhci/0.1.2-beta/IEDB_NG_TC1-0.1.2-beta.tar.gz
tar -xzf IEDB_NG_TC1-0.1.2-beta.tar.gz
mv ng_tc1-0.1.2-beta ng_tc1
# Download mhcii files
wget https://downloads.iedb.org/nextgen-tools/tcell_mhcii/0.2.1-beta/IEDB_NG_TC2-0.2.1-beta.tar.gz
tar -xzf IEDB_NG_TC2-0.2.1-beta.tar.gz
mv ng_tc2-0.2.1-beta ng_tc2
cd $PVC_PATH

# install required python packages
pip install -r requirements.txt
# install the standalone requirements.txt
pip install -r standalone/ng_tc1/requirements.txt
pip install -r standalone/ng_tc2/requirements.txt

# update paths.py file for tcell_class_i_path, and tcell_class_i_path
sed -i "s|tcell_class_i_path='/path_to_tc1/ng_tc1'|tcell_class_i_path = '$(pwd)/standalone/ng_tc1'|g" paths.py
sed -i "s|tcell_class_ii_path='/path_to_tc2/ng_tc2'|tcell_class_ii_path = '$(pwd)/standalone/ng_tc2'|g" paths.py