import re
import pandas as pd
from pathlib import Path
from netmhciipan_4_2_executable import single_prediction


def check_allelelist():
    DATA_DIR = str(Path(__file__).parent.parent)
    TM_FILE = DATA_DIR + '/tools-mapping.tsv'
    tm_df = pd.read_csv(TM_FILE, sep='\t', index_col=False)

    # Filter to only get the netmhciipan-4.2 alleles
    netmhciipan_tm_df = tm_df[(tm_df['Tool']=='netmhciipan') & (tm_df['Tool Version']==4.2)]
    netmhciipan_tm_list = netmhciipan_tm_df['Tool Label'].to_list()
    print(len(netmhciipan_tm_list))


    ALLELE_DOT_LIST_FILE = DATA_DIR + '/netmhciipan-4.2/allelelist.txt'
    with open(ALLELE_DOT_LIST_FILE, 'r') as f:
        alleles = [_.strip().split(' ')[0] for _ in f.readlines()]
        print(alleles[:10])
        print(len(alleles))

    # unrecognized_alleles = []
    # counter = 1
    # for allele in alleles:
    #     # Columns: Tool Group, Tool, Tool Version, Tool Label, MRO ID, Lengths
    #     tool_label = allele.replace("/","-")  
    #     if tool_label.startswith('HLA-'):
    #         tool_label = tool_label.replace('HLA-', '')
    #     result = single_prediction(['ASSASSSSAAAAAAAT'], [(tool_label, 16)])

    #     if not result:
    #         # raise ValueError(f"Tool Label ({tool_label}) is not compatible with netmhciipan-4.2 method.")
    #         unrecognized_alleles.append(allele)

    #     print(f'{counter}/{len(alleles)}')
    #     counter += 1
    # # All the alleles worked. It is safe to take netmhciipan alleles from the Tools_MRO_mapping.xlsx.
    # # 5622
    # print(unrecognized_alleles)
    # print(len(unrecognized_alleles))

    # 124 alleles
    still_unknown_alleles = []
    allele_info_rows = []
    unrecognized_alleles = ['DRB3_0202', 'DRB3_0204', 'DRB3_0205', 'DRB3_0209', 'DRB3_0220', 'DRB3_0222', 'DRB3_0223', 'DRB3_0224', 'DRB3_0225', 'DRB3_0226', 'DRB3_0227', 'DRB3_0228', 'DRB3_0230', 'DRB3_0232', 'DRB3_0233', 'DRB3_0234', 'DRB3_0235', 'DRB3_0236', 'DRB3_0237', 'DRB3_0238', 'DRB3_0239', 'DRB3_0240', 'DRB3_0242', 'DRB3_0243', 'DRB3_0244', 'DRB3_0245', 'DRB3_0246', 'DRB3_0247', 'DRB3_0248', 'DRB3_0249', 'DRB3_0250', 'DRB3_0252', 'DRB3_0253', 'DRB3_0254', 'DRB3_0256', 'DRB3_0257', 'DRB3_0258', 'DRB3_0259', 'DRB3_0260', 'DRB3_0262', 'DRB3_0263', 'DRB3_0264', 'DRB3_0265', 'DRB3_0266', 'DRB3_0268', 'DRB3_0269', 'DRB3_0270', 'DRB3_0272', 'DRB3_0273', 'DRB3_0274', 'DRB3_0275', 'DRB3_0276', 'DRB3_0277', 'DRB3_0278', 'DRB3_0279', 'DRB3_0282', 'DRB3_0283', 'DRB3_0284', 'DRB3_0285', 'DRB3_0286', 'DRB3_0287', 'DRB3_0288', 'DRB3_0289', 'DRB3_0290', 'DRB3_0292', 'DRB3_0293', 'DRB3_0294', 'DRB3_0296', 'DRB3_0297', 'DRB3_0298', 'DRB3_0299', 'DRB3_0303', 'DRB3_0304', 'DRB3_0305', 'DRB3_0306', 'DRB3_0307', 'DRB3_0308', 'DRB3_0309', 'DRB3_0320', 'DRB3_0323', 'DRB3_0324', 'DRB3_0325', 'DRB3_0326', 'DRB3_0327', 'DRB3_0328', 'DRB3_0329', 'DRB3_0332', 'DRB3_0333', 'DRB3_0334', 'DRB3_0335', 'DRB3_0336', 'DRB3_0337', 'DRB3_0338', 'DRB3_0339', 'DRB3_0340', 'DRB3_0342', 'DRB3_0343', 'DRB3_0344', 'DRB3_0345', 'DRB3_0346', 'DRB3_0347', 'DRB3_0348', 'DRB3_0349', 'DRB3_0350', 'DRB3_0352', 'DRB3_0353', 'DRB3_0354', 'DRB3_0355', 'DRB5_0202', 'DRB5_0203', 'DRB5_0204', 'DRB5_0205', 'DRB5_0206', 'DRB5_0207', 'DRB5_0208', 'DRB5_0209', 'DRB5_0220', 'DRB5_0222', 'DRB5_0223', 'DRB5_0224', 'DRB5_0227', 'DRB5_0228', 'DRB5_0229', 'DRB5_0230']
    for allele in unrecognized_alleles:
        cleaned_allele = re.sub(r'[^a-zA-Z0-9\s]', '', allele)

        mroid = ''
        tm_tlabel = ''
        for i, row in netmhciipan_tm_df.iterrows():
            tlabel = row['Tool Label']
            cleaned_tlabel = re.sub(r'[^a-zA-Z0-9\s]', '', tlabel)

            if cleaned_allele == cleaned_tlabel:
                mroid = row['MRO ID']
                tm_tlabel = tlabel
                break
        
        if not mroid:
            still_unknown_alleles.append(allele)
        else:
            allele_info_rows.append({
                'Tools Label': tm_tlabel,
                'Synonym': allele,
                'MRO ID': mroid
            })

        # print(allele_info_row)

    # print('--------------------')
    # print(still_unknown_alleles)
    # print(len(still_unknown_alleles))

    valid_alleles_df = pd.DataFrame(allele_info_rows)
    print(valid_alleles_df)

    for i, row in valid_alleles_df.iterrows():
        unrecognized_alleles.remove(row['Synonym'])
    
    print(unrecognized_alleles)
    print(len(unrecognized_alleles))

    '''
    All the alleles from the allelelist.txt file EXCEPT the unrecognized_alleles are valid alleles.
    Let's see if all of them exist in the tools-mapping.
    '''
    stripped_tool_names = []

    for allele in alleles:
        if allele in unrecognized_alleles: continue

        cleaned_allele = re.sub(r'[^a-zA-Z0-9\s]', '', allele)

        if cleaned_allele.startswith('HLA'):
            # removing HLA
            cleaned_allele = cleaned_allele[3:]

        stripped_tool_names.append(cleaned_allele)
    
    print(f"--finished getting the cleaned tool names ({len(stripped_tool_names)})--")

    '''
    Iterate over all the netmhciipan alleles from the tools-mapping file.
    As I iterate, remove all special characters from the Tool Label.
    From the stripped Tool Label, check if it exists in the stripped_tool_names.
    If so, remove it from stripped_tool_names.

    Expected output is an empty list of stripped_tool_names.
    If alleles still exist in the stripped_tool_names, that means those alleles needs to be
    added to the tools-mapping file.
    '''
    import sys

    counter = 1
    for row in netmhciipan_tm_df.itertuples():
        tool_label = row._4
        
        
        stripped_tool_label = re.sub(r'[^a-zA-Z0-9\s]', '', tool_label)
        print(stripped_tool_label)
        
        if stripped_tool_label in stripped_tool_names:
            stripped_tool_names.remove(stripped_tool_label)

        print(f'{counter}/{len(netmhciipan_tm_df)}')
        counter += 1
    
    print('finished...')
    print('----------------------')
    print(stripped_tool_names)
    print(len(stripped_tool_names))


    # fishy_alleles = []
    # counter = 1
    # for allele in alleles:
    #     if allele in unrecognized_alleles:
    #         continue

    #     # Columns: Tool Group, Tool, Tool Version, Tool Label, MRO ID, Lengths
    #     tool_label = allele.replace("/","-")  
    #     if tool_label.startswith('HLA-'):
    #         tool_label = tool_label.replace('HLA-', '')
    #     result = single_prediction(['ASSASSSSAAAAAAAT'], [(tool_label, 16)])

    #     if not result:
    #         if allele in valid_alleles_df['Synonym'].to_list():
    #             continue
    #         # raise ValueError(f"Tool Label ({tool_label}) is not compatible with netmhciipan-4.2 method.")
    #         fishy_alleles.append(allele)

    #     print(f'{counter}/{len(alleles)}')
    #     counter += 1
   
    # # There are no alleles here in the fishy_alleles
    # print(fishy_alleles)
    # print(len(fishy_alleles))

def add_alleles():
    DATA_DIR = str(Path(__file__).parent.parent)
    ALLELE_DOT_LIST_FILE = DATA_DIR + '/netmhciipan-4.2/allelelist.txt'
    with open(ALLELE_DOT_LIST_FILE, 'r') as f:
        alleles = [_.strip().split(' ')[0] for _ in f.readlines()]

    alleles_dict = {}
    for allele in alleles:
        stripped_tool_label = re.sub(r'[^a-zA-Z0-9\s]', '', allele)
        if stripped_tool_label.startswith('HLA'):
            stripped_tool_label = stripped_tool_label[3:]
        alleles_dict[stripped_tool_label] = allele

    alleles_to_add = ['DRB101100', 'DRB101101', 'DRB101102', 'DRB101103', 'DRB101104', 'DRB101105', 'DRB101106', 'DRB101107', 'DRB101108', 'DRB101109', 'DRB101110', 'DRB101111', 'DRB101112', 'DRB101113', 'DRB101114', 'DRB101115', 'DRB101116', 'DRB101117', 'DRB101118', 'DRB101119', 'DRB101120', 'DRB101121', 'DRB101122', 'DRB101123', 'DRB101124', 'DRB101125', 'DRB101126', 'DRB101127', 'DRB101128', 'DRB101129', 'DRB101130', 'DRB101132', 'DRB101133', 'DRB101134', 'DRB101135', 'DRB10134', 'DRB10135', 'DRB10136', 'DRB10137', 'DRB10138', 'DRB10141', 'DRB10142', 'DRB10143', 'DRB10144', 'DRB10145', 'DRB10146', 'DRB10147', 'DRB10148', 'DRB10149', 'DRB10150', 'DRB10151', 'DRB10153', 'DRB10154', 'DRB10155', 'DRB10156', 'DRB10157', 'DRB10158', 'DRB10159', 'DRB10160', 'DRB10161', 'DRB10163', 'DRB10164', 'DRB10165', 'DRB10166', 'DRB10167', 'DRB10169', 'DRB10170', 'DRB10171', 'DRB10172', 'DRB10173', 'DRB10174', 'DRB10175', 'DRB10176', 'DRB10177', 'DRB10178', 'DRB10179', 'DRB10180', 'DRB10181', 'DRB10182', 'DRB10183', 'DRB10184', 'DRB10185', 'DRB10186', 'DRB10187', 'DRB10188', 'DRB10189', 'DRB10190', 'DRB10191Q', 'DRB10192', 'DRB10193', 'DRB10194', 'DRB10195', 'DRB10196', 'DRB10197', 'DRB10198', 'DRB10199', 'DRB103100', 'DRB103101', 'DRB103102', 'DRB103103', 'DRB103104', 'DRB103105', 'DRB103106', 'DRB103107', 'DRB103108', 'DRB103109', 'DRB103110', 'DRB103111', 'DRB103112', 'DRB103113', 'DRB103114', 'DRB103115', 'DRB103116', 'DRB103117', 'DRB103118', 'DRB103119', 'DRB103120', 'DRB103121', 'DRB103122', 'DRB103123', 'DRB103124', 'DRB103125', 'DRB103126', 'DRB103127', 'DRB103128', 'DRB103129', 'DRB103130', 'DRB103131', 'DRB103132', 'DRB103133', 'DRB103134', 'DRB103135', 'DRB103136', 'DRB103137', 'DRB103138', 'DRB103139', 'DRB103140', 'DRB103141', 'DRB103142', 'DRB103143', 'DRB103144', 'DRB103145', 'DRB103146', 'DRB103147', 'DRB103148', 'DRB103149', 'DRB103150', 'DRB103151', 'DRB103152', 'DRB103153', 'DRB103154', 'DRB103155', 'DRB103157', 'DRB103158', 'DRB103159', 'DRB103160', 'DRB103161', 'DRB103162', 'DRB103163', 'DRB103164', 'DRB103165', 'DRB103166', 'DRB103167', 'DRB103168', 'DRB103169', 'DRB10316', 'DRB103170', 'DRB103171', 'DRB103172', 'DRB103173', 'DRB103175', 'DRB103176', 'DRB103177', 'DRB103178', 'DRB103179', 'DRB103180', 'DRB103181', 'DRB103182', 'DRB103183', 'DRB103184', 'DRB103185', 'DRB103186', 'DRB103187', 'DRB103188', 'DRB103190', 'DRB103191', 'DRB103192', 'DRB103193', 'DRB103194', 'DRB103195', 'DRB10356', 'DRB10357', 'DRB10358', 'DRB10359', 'DRB10360', 'DRB10361', 'DRB10362', 'DRB10363', 'DRB10364', 'DRB10365', 'DRB10366', 'DRB10369', 'DRB10370', 'DRB10371', 'DRB10372', 'DRB10373', 'DRB10374', 'DRB10375', 'DRB10376', 'DRB10377', 'DRB10378', 'DRB10379', 'DRB10380', 'DRB10381', 'DRB10382', 'DRB10383', 'DRB10384', 'DRB10385', 'DRB10386', 'DRB10387', 'DRB10388', 'DRB10389', 'DRB10390', 'DRB10391', 'DRB10392', 'DRB10393', 'DRB10394', 'DRB10395', 'DRB10396', 'DRB10397', 'DRB10398', 'DRB10399', 'DRB104100', 'DRB104101', 'DRB104102', 'DRB104103', 'DRB104104', 'DRB104105', 'DRB104106', 'DRB104107', 'DRB104108', 'DRB104109', 'DRB104110', 'DRB104111', 'DRB104112', 'DRB104113', 'DRB104114', 'DRB104115', 'DRB104116', 'DRB104117', 'DRB104118', 'DRB104121', 'DRB104122', 'DRB104123', 'DRB104124', 'DRB104125', 'DRB104126', 'DRB104127', 'DRB104128', 'DRB104129', 'DRB104130', 'DRB104131', 'DRB104132', 'DRB104133', 'DRB104134', 'DRB104135', 'DRB104136', 'DRB104137', 'DRB104138', 'DRB104139', 'DRB104140', 'DRB104141', 'DRB104143', 'DRB104144', 'DRB104145', 'DRB104146', 'DRB104147', 'DRB104148', 'DRB104149', 'DRB104150', 'DRB104151', 'DRB104152', 'DRB104153', 'DRB104154', 'DRB104155', 'DRB104156', 'DRB104159', 'DRB104160', 'DRB104161', 'DRB104162', 'DRB104163', 'DRB104164', 'DRB104165', 'DRB104166', 'DRB104167', 'DRB104168', 'DRB104169', 'DRB104170', 'DRB104171', 'DRB104172', 'DRB104173', 'DRB104174', 'DRB104175', 'DRB104176', 'DRB104177', 'DRB104179', 'DRB104180', 'DRB104181', 'DRB104182', 'DRB104183', 'DRB104184', 'DRB104185', 'DRB104187', 'DRB104188', 'DRB104189', 'DRB104190', 'DRB104191', 'DRB104192', 'DRB104193', 'DRB104194', 'DRB104195', 'DRB104196', 'DRB104197', 'DRB104198', 'DRB104199', 'DRB104200', 'DRB104201', 'DRB104202', 'DRB104203', 'DRB104204', 'DRB104205', 'DRB104206', 'DRB104207', 'DRB104208', 'DRB104209', 'DRB104210', 'DRB104211', 'DRB104213', 'DRB104215', 'DRB104216', 'DRB104217', 'DRB104218', 'DRB104219', 'DRB104220', 'DRB104221', 'DRB104222', 'DRB104223', 'DRB104224', 'DRB104225', 'DRB104226', 'DRB104227', 'DRB104228', 'DRB104229', 'DRB104230', 'DRB104231', 'DRB104232', 'DRB104233', 'DRB104234', 'DRB104235', 'DRB104236', 'DRB104237', 'DRB104238', 'DRB104239', 'DRB104240', 'DRB104241', 'DRB104242', 'DRB104243', 'DRB104244', 'DRB104245', 'DRB104246', 'DRB104248', 'DRB104249', 'DRB104250', 'DRB104251', 'DRB104252', 'DRB104253', 'DRB104254', 'DRB104255', 'DRB104256', 'DRB104257', 'DRB104258', 'DRB104259', 'DRB10425', 'DRB104260', 'DRB104261', 'DRB104262', 'DRB104263', 'DRB104265', 'DRB104268', 'DRB104269', 'DRB104270', 'DRB104271', 'DRB104272', 'DRB104273', 'DRB104274', 'DRB104275', 'DRB104276', 'DRB104277', 'DRB104278', 'DRB104279', 'DRB104281', 'DRB104282', 'DRB104283', 'DRB104284', 'DRB104285', 'DRB104287', 'DRB104288', 'DRB104289', 'DRB104290', 'DRB104291', 'DRB104292', 'DRB104293', 'DRB104294', 'DRB104295', 'DRB104296', 'DRB104297', 'DRB104298', 'DRB104301', 'DRB104302', 'DRB104303', 'DRB104304', 'DRB104305', 'DRB104306', 'DRB104307', 'DRB104308', 'DRB104309', 'DRB104310', 'DRB104311', 'DRB104313', 'DRB104314', 'DRB104315', 'DRB104316', 'DRB104317', 'DRB104318', 'DRB104319', 'DRB104320', 'DRB104321', 'DRB104322', 'DRB104323', 'DRB104324', 'DRB104325', 'DRB104326', 'DRB104327', 'DRB104328', 'DRB10432', 'DRB104330', 'DRB104331', 'DRB104332', 'DRB104333', 'DRB104334', 'DRB104335', 'DRB104336', 'DRB104337', 'DRB104338', 'DRB104339', 'DRB104340', 'DRB104341', 'DRB104342', 'DRB10490', 'DRB10492', 'DRB10493', 'DRB10495', 'DRB10496', 'DRB10497', 'DRB10498', 'DRB10499', 'DRB107100', 'DRB107102', 'DRB107103', 'DRB107104', 'DRB107105', 'DRB107106', 'DRB107107', 'DRB107108', 'DRB107109', 'DRB107110', 'DRB107111', 'DRB107112', 'DRB107113', 'DRB107114', 'DRB107115', 'DRB107116', 'DRB107117', 'DRB107119', 'DRB107120', 'DRB107121', 'DRB107122', 'DRB107123', 'DRB107124', 'DRB107125', 'DRB107126', 'DRB107127', 'DRB107128', 'DRB107130', 'DRB107131', 'DRB107132', 'DRB107133', 'DRB107134', 'DRB107135', 'DRB107136', 'DRB10718', 'DRB10720', 'DRB10721', 'DRB10722', 'DRB10723', 'DRB10724', 'DRB10725', 'DRB10727', 'DRB10728', 'DRB10729', 'DRB10730', 'DRB10731', 'DRB10732', 'DRB10733', 'DRB10734', 'DRB10735', 'DRB10736', 'DRB10737', 'DRB10738', 'DRB10739', 'DRB10740', 'DRB10741', 'DRB10742', 'DRB10743', 'DRB10744', 'DRB10745', 'DRB10746', 'DRB10747', 'DRB10748', 'DRB10749', 'DRB10750', 'DRB10751', 'DRB10752', 'DRB10753', 'DRB10754', 'DRB10755', 'DRB10756', 'DRB10757', 'DRB10759', 'DRB10760', 'DRB10761', 'DRB10762', 'DRB10763', 'DRB10764', 'DRB10765', 'DRB10766', 'DRB10767', 'DRB10769', 'DRB10770', 'DRB10771', 'DRB10772', 'DRB10773', 'DRB10774', 'DRB10775', 'DRB10776', 'DRB10777', 'DRB10778', 'DRB10779', 'DRB10780', 'DRB10781', 'DRB10782', 'DRB10783', 'DRB10784', 'DRB10785', 'DRB10786', 'DRB10788', 'DRB10789', 'DRB10790', 'DRB10791', 'DRB10792', 'DRB10793', 'DRB10794', 'DRB10795', 'DRB10796', 'DRB10797', 'DRB10798', 'DRB10799', 'DRB108100', 'DRB108101', 'DRB108102', 'DRB108103', 'DRB108104', 'DRB108105', 'DRB108106', 'DRB108107', 'DRB108108', 'DRB108109', 'DRB108110', 'DRB108111', 'DRB108112', 'DRB108113', 'DRB10817', 'DRB10841', 'DRB10842', 'DRB10843', 'DRB10844', 'DRB10845', 'DRB10846', 'DRB10847', 'DRB10848', 'DRB10849', 'DRB10850', 'DRB10851', 'DRB10852', 'DRB10853', 'DRB10854', 'DRB10855', 'DRB10856', 'DRB10857', 'DRB10858', 'DRB10859', 'DRB10861', 'DRB10862', 'DRB10863', 'DRB10864', 'DRB10865', 'DRB10866', 'DRB10867', 'DRB10868', 'DRB10869', 'DRB10870', 'DRB10871', 'DRB10872', 'DRB10873', 'DRB10874', 'DRB10875', 'DRB10876', 'DRB10877', 'DRB10879', 'DRB10880', 'DRB10881', 'DRB10882', 'DRB10883', 'DRB10884', 'DRB10885', 'DRB10886', 'DRB10887', 'DRB10888', 'DRB10890', 'DRB10891', 'DRB10892', 'DRB10893', 'DRB10894', 'DRB10895', 'DRB10896', 'DRB10897', 'DRB10898', 'DRB10899', 'DRB10910', 'DRB10911', 'DRB10912', 'DRB10913', 'DRB10914', 'DRB10915', 'DRB10916', 'DRB10917', 'DRB10918', 'DRB10919', 'DRB10920', 'DRB10921', 'DRB10922', 'DRB10923', 'DRB10924', 'DRB10925', 'DRB10926', 'DRB10927', 'DRB10928', 'DRB10929', 'DRB10930', 'DRB10931', 'DRB10932', 'DRB10933', 'DRB10934', 'DRB10935', 'DRB10936', 'DRB10938', 'DRB10939', 'DRB10940', 'DRB10941', 'DRB10942', 'DRB10943', 'DRB10944', 'DRB10945', 'DRB10946', 'DRB10947', 'DRB10948', 'DRB10949', 'DRB10950', 'DRB10951', 'DRB11004', 'DRB11005', 'DRB11006', 'DRB11007', 'DRB11008', 'DRB11009', 'DRB11010', 'DRB11011', 'DRB11012', 'DRB11013', 'DRB11014', 'DRB11015', 'DRB11016', 'DRB11017', 'DRB11018', 'DRB11019', 'DRB11020', 'DRB11021', 'DRB11022', 'DRB11023', 'DRB11024', 'DRB11025', 'DRB11026', 'DRB11027', 'DRB11028', 'DRB11029', 'DRB11030', 'DRB11031', 'DRB11032', 'DRB11033', 'DRB11034', 'DRB11035', 'DRB11036', 'DRB11037', 'DRB11038Q', 'DRB11039', 'DRB11040', 'DRB11041', 'DRB11042', 'DRB11043', 'DRB11044', 'DRB111100', 'DRB111101', 'DRB111102', 'DRB111103', 'DRB111104', 'DRB111105', 'DRB111106', 'DRB111107', 'DRB111108', 'DRB111109', 'DRB111110', 'DRB111111', 'DRB111112', 'DRB111113', 'DRB111114', 'DRB111115', 'DRB111116', 'DRB111117', 'DRB111118', 'DRB111119', 'DRB111120', 'DRB111121', 'DRB111122', 'DRB111123', 'DRB111124', 'DRB111125', 'DRB111126', 'DRB111127', 'DRB111128', 'DRB111129', 'DRB111130', 'DRB111131', 'DRB111132', 'DRB111133', 'DRB111134', 'DRB111135', 'DRB111136', 'DRB111137', 'DRB111138', 'DRB111139', 'DRB111140', 'DRB111141', 'DRB111142', 'DRB111143', 'DRB111144', 'DRB111145', 'DRB111146', 'DRB111147', 'DRB111148', 'DRB111149', 'DRB111150', 'DRB111151', 'DRB111152', 'DRB111153', 'DRB111154', 'DRB111155', 'DRB111156', 'DRB111157', 'DRB111158', 'DRB111159', 'DRB111160', 'DRB111161', 'DRB111162', 'DRB111163', 'DRB111164', 'DRB111165', 'DRB111166', 'DRB111167', 'DRB111168', 'DRB111170', 'DRB111171', 'DRB111172', 'DRB111173', 'DRB111174', 'DRB111175', 'DRB111176', 'DRB111177', 'DRB111178', 'DRB111179', 'DRB111180', 'DRB111181', 'DRB111182', 'DRB111183', 'DRB111184', 'DRB111185', 'DRB111186', 'DRB111187', 'DRB111188', 'DRB111189', 'DRB111190', 'DRB111191', 'DRB111192', 'DRB111193', 'DRB111194', 'DRB111195', 'DRB111196', 'DRB111197', 'DRB111198', 'DRB111199', 'DRB111200', 'DRB111201', 'DRB111202', 'DRB111203', 'DRB111204', 'DRB111205', 'DRB111206', 'DRB111207', 'DRB111208', 'DRB111209', 'DRB111210', 'DRB111211', 'DRB111212', 'DRB111213', 'DRB111214', 'DRB111215', 'DRB111216', 'DRB111218', 'DRB111219', 'DRB111220', 'DRB111221', 'DRB111222', 'DRB111223', 'DRB111224', 'DRB111225', 'DRB111226', 'DRB111227', 'DRB111228', 'DRB111229', 'DRB111230', 'DRB111231', 'DRB111232', 'DRB111233', 'DRB111234', 'DRB111235', 'DRB111236', 'DRB111237', 'DRB111238', 'DRB111239', 'DRB11123', 'DRB111240', 'DRB111241', 'DRB111242', 'DRB111243', 'DRB111244', 'DRB111245', 'DRB111247', 'DRB111249', 'DRB111251', 'DRB111252', 'DRB111253', 'DRB111254', 'DRB111255', 'DRB111256', 'DRB111257', 'DRB111258', 'DRB111259', 'DRB111260', 'DRB111261', 'DRB111262', 'DRB111263', 'DRB111264', 'DRB111265', 'DRB111266', 'DRB111267', 'DRB111268', 'DRB111269', 'DRB111270', 'DRB111271', 'DRB111272Q', 'DRB111273', 'DRB111274', 'DRB111275', 'DRB111276', 'DRB111277', 'DRB111278', 'DRB111279', 'DRB111280', 'DRB111281', 'DRB111282', 'DRB111283', 'DRB111284', 'DRB111285', 'DRB111286', 'DRB111288', 'DRB111289', 'DRB111290', 'DRB111291', 'DRB111292', 'DRB111293', 'DRB111295', 'DRB111296', 'DRB111297Q', 'DRB111298', 'DRB111299', 'DRB111300', 'DRB111302', 'DRB11197', 'DRB11198', 'DRB11199', 'DRB11225', 'DRB11226', 'DRB11227', 'DRB11228', 'DRB11229', 'DRB11230', 'DRB11232', 'DRB11233', 'DRB11234', 'DRB11235', 'DRB11236', 'DRB11237', 'DRB11238', 'DRB11239', 'DRB11240', 'DRB11241', 'DRB11242', 'DRB11243', 'DRB11244', 'DRB11245', 'DRB11246', 'DRB11247', 'DRB11248', 'DRB11249', 'DRB11250', 'DRB11251', 'DRB11252', 'DRB11253', 'DRB11254', 'DRB11255', 'DRB11256', 'DRB11257', 'DRB11258', 'DRB11259', 'DRB11261', 'DRB11262', 'DRB11263', 'DRB11264', 'DRB11265', 'DRB11266', 'DRB11267', 'DRB11268', 'DRB11269', 'DRB11270', 'DRB11271', 'DRB11273', 'DRB11275', 'DRB11276', 'DRB11277', 'DRB11278', 'DRB11279', 'DRB11280', 'DRB11281', 'DRB11282', 'DRB11283', 'DRB11284', 'DRB11285', 'DRB11287', 'DRB11288', 'DRB11289', 'DRB11290', 'DRB11291', 'DRB11292', 'DRB11293', 'DRB11294', 'DRB11295', 'DRB11296', 'DRB11297', 'DRB113102', 'DRB113103', 'DRB113104', 'DRB113105', 'DRB113106', 'DRB113107', 'DRB113108', 'DRB113109', 'DRB113110', 'DRB113111', 'DRB113112', 'DRB113114', 'DRB113115', 'DRB113116', 'DRB113117', 'DRB113118', 'DRB113119', 'DRB113120', 'DRB113121', 'DRB113122', 'DRB113123', 'DRB113124', 'DRB113125', 'DRB113126', 'DRB113127', 'DRB113128', 'DRB113129', 'DRB113130', 'DRB113131', 'DRB113132', 'DRB113133', 'DRB113134', 'DRB113135', 'DRB113136', 'DRB113138', 'DRB113139', 'DRB113140', 'DRB113141', 'DRB113143', 'DRB113144', 'DRB113145', 'DRB113146', 'DRB113147', 'DRB113148', 'DRB113149', 'DRB113150', 'DRB113151', 'DRB113152', 'DRB113153', 'DRB113154', 'DRB113155', 'DRB113156', 'DRB113157', 'DRB113158', 'DRB113159', 'DRB113160', 'DRB113161', 'DRB113162', 'DRB113163', 'DRB113164', 'DRB113165', 'DRB113166', 'DRB113167', 'DRB113168', 'DRB113169', 'DRB113170', 'DRB113171', 'DRB113172', 'DRB113173', 'DRB113174', 'DRB113175', 'DRB113176', 'DRB113177', 'DRB113178', 'DRB113179', 'DRB113180', 'DRB113181', 'DRB113182', 'DRB113183', 'DRB113184', 'DRB113186', 'DRB113187', 'DRB113188', 'DRB113189', 'DRB113190', 'DRB113191', 'DRB113192', 'DRB113193', 'DRB113194', 'DRB113195', 'DRB113196', 'DRB113197', 'DRB113198', 'DRB113199', 'DRB113201', 'DRB113202', 'DRB113203', 'DRB113204', 'DRB113205', 'DRB113206', 'DRB113207', 'DRB113208', 'DRB113209', 'DRB113210', 'DRB113211', 'DRB113212', 'DRB113213', 'DRB113214', 'DRB113215', 'DRB113216', 'DRB113217', 'DRB113218', 'DRB113219', 'DRB113220', 'DRB113221', 'DRB113222', 'DRB113223', 'DRB113224', 'DRB113225', 'DRB113226', 'DRB113227', 'DRB113228', 'DRB113229', 'DRB113230', 'DRB113231', 'DRB113232', 'DRB113233', 'DRB113234', 'DRB113235', 'DRB113236', 'DRB113237', 'DRB113238', 'DRB113239', 'DRB113240', 'DRB113241', 'DRB113242', 'DRB113243', 'DRB113244', 'DRB113245', 'DRB113246', 'DRB113247', 'DRB113248', 'DRB113250', 'DRB113251', 'DRB113253', 'DRB113254', 'DRB113256', 'DRB113257', 'DRB113258', 'DRB113259', 'DRB11325', 'DRB113260', 'DRB113261', 'DRB113262', 'DRB113263', 'DRB113264', 'DRB113265', 'DRB113266', 'DRB113267', 'DRB113269', 'DRB113270', 'DRB113271', 'DRB113272', 'DRB113273', 'DRB113274', 'DRB113275', 'DRB113276', 'DRB113277', 'DRB113278Q', 'DRB113279', 'DRB113280', 'DRB113281', 'DRB113282', 'DRB113283', 'DRB113284', 'DRB113285', 'DRB113286', 'DRB113287', 'DRB113288', 'DRB11328', 'DRB113290', 'DRB113291', 'DRB113292', 'DRB113293', 'DRB113294', 'DRB113296', 'DRB113297', 'DRB113299', 'DRB113300', 'DRB113301', 'DRB113302', 'DRB113303', 'DRB113304', 'DRB113305', 'DRB113306', 'DRB113307', 'DRB113308', 'DRB113309', 'DRB113311', 'DRB113312', 'DRB113313', 'DRB113314', 'DRB113315', 'DRB113316', 'DRB113317', 'DRB113318', 'DRB113320', 'DRB113321', 'DRB113323', 'DRB113325', 'DRB113326', 'DRB113327', 'DRB11340', 'DRB11345', 'DRB114100', 'DRB114101', 'DRB114102', 'DRB114103', 'DRB114104', 'DRB114105', 'DRB114106', 'DRB114107', 'DRB114108', 'DRB114109', 'DRB114110', 'DRB114111', 'DRB114112', 'DRB114113', 'DRB114114', 'DRB114115', 'DRB114116', 'DRB114117', 'DRB114118', 'DRB114119', 'DRB114120', 'DRB114121', 'DRB114122', 'DRB114123', 'DRB114124', 'DRB114125', 'DRB114126', 'DRB114127', 'DRB114128', 'DRB114129', 'DRB114130', 'DRB114131', 'DRB114132', 'DRB114133', 'DRB114134', 'DRB114135', 'DRB114136', 'DRB114138', 'DRB114139', 'DRB114140', 'DRB114141', 'DRB114142', 'DRB114143', 'DRB114144', 'DRB114145', 'DRB114146', 'DRB114147', 'DRB114148', 'DRB114149', 'DRB114150', 'DRB114151', 'DRB114153', 'DRB114154', 'DRB114155', 'DRB114156', 'DRB114157', 'DRB114158', 'DRB114159', 'DRB114160', 'DRB114161', 'DRB114162', 'DRB114163', 'DRB114164', 'DRB114165', 'DRB114167', 'DRB114168', 'DRB114169', 'DRB114170', 'DRB114171', 'DRB114172', 'DRB114173', 'DRB114174', 'DRB114175', 'DRB114176', 'DRB114177', 'DRB114178', 'DRB114179', 'DRB114180', 'DRB114181', 'DRB114182', 'DRB114183', 'DRB114184', 'DRB114185', 'DRB114186', 'DRB114187', 'DRB114189', 'DRB114190', 'DRB114191', 'DRB114192', 'DRB114193', 'DRB114194', 'DRB114196', 'DRB114198', 'DRB114199', 'DRB114200', 'DRB114201', 'DRB114202', 'DRB114203', 'DRB114204', 'DRB114205', 'DRB114206', 'DRB114207', 'DRB114208', 'DRB114209', 'DRB114210Q', 'DRB114211', 'DRB114212', 'DRB114213', 'DRB114214', 'DRB114215', 'DRB114216', 'DRB114217', 'DRB114218', 'DRB114219', 'DRB114220', 'DRB114221', 'DRB114223', 'DRB114224', 'DRB114225', 'DRB114226', 'DRB114227', 'DRB114228', 'DRB114229', 'DRB114230', 'DRB114232', 'DRB114233', 'DRB114234', 'DRB114235', 'DRB114236', 'DRB114237', 'DRB114238', 'DRB114239', 'DRB114240', 'DRB114241', 'DRB114242', 'DRB114243', 'DRB115100', 'DRB115101', 'DRB115102', 'DRB115103', 'DRB115104', 'DRB115105', 'DRB115106', 'DRB115107', 'DRB115108', 'DRB115109', 'DRB115110', 'DRB115111', 'DRB115112', 'DRB115114', 'DRB115116', 'DRB115117', 'DRB115118', 'DRB115119', 'DRB115120', 'DRB115121', 'DRB115122', 'DRB115123', 'DRB115124', 'DRB115125', 'DRB115126', 'DRB115127', 'DRB115128', 'DRB115130', 'DRB115131', 'DRB115132', 'DRB115133', 'DRB115135', 'DRB115136', 'DRB115139', 'DRB115140', 'DRB115141', 'DRB115142', 'DRB115143', 'DRB115144', 'DRB115145', 'DRB115146', 'DRB115147', 'DRB115149', 'DRB115150', 'DRB115151', 'DRB115152', 'DRB115153', 'DRB115155', 'DRB115156', 'DRB115157', 'DRB115158', 'DRB115160', 'DRB115161', 'DRB115162', 'DRB115164Q', 'DRB115165', 'DRB115166', 'DRB115167', 'DRB115168', 'DRB115169', 'DRB115170', 'DRB115171', 'DRB115172', 'DRB115173', 'DRB115174', 'DRB115175', 'DRB115177', 'DRB115178', 'DRB115179', 'DRB115181', 'DRB115182', 'DRB115184', 'DRB115185', 'DRB115186', 'DRB115187', 'DRB115188', 'DRB115189', 'DRB115190', 'DRB115191', 'DRB115192', 'DRB115193', 'DRB115194', 'DRB115195', 'DRB115196', 'DRB115197', 'DRB115198', 'DRB115199', 'DRB115201', 'DRB115202', 'DRB115203Q', 'DRB115204', 'DRB115205', 'DRB115206', 'DRB11551', 'DRB11552', 'DRB11553', 'DRB11554', 'DRB11555', 'DRB11556', 'DRB11557', 'DRB11558', 'DRB11559', 'DRB11560', 'DRB11561', 'DRB11562', 'DRB11563', 'DRB11564', 'DRB11565', 'DRB11566', 'DRB11567', 'DRB11568', 'DRB11569', 'DRB11570', 'DRB11571', 'DRB11572', 'DRB11573', 'DRB11574', 'DRB11575', 'DRB11576', 'DRB11577', 'DRB11578', 'DRB11579', 'DRB11581', 'DRB11582', 'DRB11583', 'DRB11584', 'DRB11585', 'DRB11586', 'DRB11587', 'DRB11588', 'DRB11589', 'DRB11590', 'DRB11591', 'DRB11592', 'DRB11593', 'DRB11594', 'DRB11595', 'DRB11596', 'DRB11597', 'DRB11598', 'DRB11599', 'DRB11617', 'DRB11618', 'DRB11619', 'DRB11620', 'DRB11622', 'DRB11623', 'DRB11624', 'DRB11625', 'DRB11626', 'DRB11627', 'DRB11628', 'DRB11629', 'DRB11630', 'DRB11631', 'DRB11632', 'DRB11633', 'DRB11634', 'DRB11635', 'DRB11636', 'DRB11637', 'DRB11638', 'DRB11639', 'DRB11640', 'DRB11642', 'DRB11643', 'DRB11644', 'DRB11645', 'DRB11646', 'DRB11647', 'DRB11648', 'DRB11649', 'DRB11650', 'DRB11651', 'DRB11652', 'DRB11653', 'DRB11654', 'DRB11656', 'DRB11657', 'DRB11658', 'DRB11660', 'DRB11661', 'DRB11664', 'DRB11665', 'DRB11666', 'DRB11667', 'DRB11668', 'DRB11669', 'DRB11671', 'DRB11672', 'DRB301100', 'DRB30115', 'DRB30116', 'DRB30117', 'DRB30118', 'DRB30119', 'DRB30120', 'DRB30121', 'DRB30122', 'DRB30123', 'DRB30124', 'DRB30125', 'DRB30127', 'DRB30128', 'DRB30129', 'DRB30130', 'DRB30131', 'DRB30132', 'DRB30133', 'DRB30134', 'DRB30135', 'DRB30136', 'DRB30137', 'DRB30138', 'DRB30139', 'DRB30141', 'DRB30142', 'DRB30143', 'DRB30144', 'DRB30145', 'DRB30146', 'DRB30147', 'DRB30148', 'DRB30149', 'DRB30150', 'DRB30151', 'DRB30152', 'DRB30153', 'DRB30154', 'DRB30155', 'DRB30156', 'DRB30157', 'DRB30158', 'DRB30159', 'DRB30160', 'DRB30161', 'DRB30162', 'DRB30163', 'DRB30164', 'DRB30165', 'DRB30166', 'DRB30167', 'DRB30168', 'DRB30169', 'DRB30170', 'DRB30171', 'DRB30172', 'DRB30174', 'DRB30175', 'DRB30176', 'DRB30178', 'DRB30179', 'DRB30180', 'DRB30182', 'DRB30183', 'DRB30184', 'DRB30185', 'DRB30186', 'DRB30187', 'DRB30188', 'DRB30189', 'DRB30190', 'DRB30191', 'DRB30192', 'DRB30193', 'DRB30194', 'DRB30195', 'DRB30196', 'DRB30198', 'DRB30199', 'DRB302100', 'DRB302101', 'DRB302102', 'DRB302103', 'DRB302104', 'DRB302105', 'DRB302106', 'DRB302107', 'DRB302108', 'DRB302110', 'DRB302111', 'DRB302112', 'DRB302113', 'DRB302114', 'DRB302115', 'DRB302116', 'DRB302117', 'DRB302118', 'DRB302119', 'DRB302120', 'DRB302122', 'DRB302123', 'DRB302124', 'DRB302126', 'DRB302127', 'DRB302128', 'DRB302129', 'DRB302130', 'DRB302131', 'DRB302132', 'DRB302133', 'DRB302134', 'DRB302135', 'DRB302136', 'DRB302138', 'DRB302139', 'DRB302140', 'DRB302141', 'DRB302142', 'DRB302143', 'DRB302144', 'DRB302146', 'DRB302147', 'DRB302148', 'DRB302149', 'DRB302150', 'DRB302151', 'DRB302152', 'DRB302153', 'DRB302154', 'DRB302155', 'DRB302156', 'DRB302157', 'DRB302158', 'DRB302159', 'DRB302160', 'DRB302161', 'DRB302162', 'DRB302163', 'DRB302164', 'DRB302166', 'DRB302167', 'DRB302168', 'DRB302169', 'DRB302170', 'DRB302171', 'DRB302172', 'DRB302173', 'DRB302174', 'DRB302175', 'DRB302176', 'DRB302177', 'DRB302178', 'DRB30231', 'DRB30241', 'DRB30251', 'DRB30261Q', 'DRB30271', 'DRB30281', 'DRB30291', 'DRB30310', 'DRB30311', 'DRB30312', 'DRB30313', 'DRB30314', 'DRB30315', 'DRB30316', 'DRB30317', 'DRB30318', 'DRB30319', 'DRB30321', 'DRB30331', 'DRB30341', 'DRB30351', 'DRB40102', 'DRB40109', 'DRB401100', 'DRB401101', 'DRB401102', 'DRB401103', 'DRB401104', 'DRB401105', 'DRB401106', 'DRB401107', 'DRB401109', 'DRB40110', 'DRB401110', 'DRB401111', 'DRB401112', 'DRB401114', 'DRB401116', 'DRB401117', 'DRB401118', 'DRB401119', 'DRB40111', 'DRB401120', 'DRB401122', 'DRB401123', 'DRB401124', 'DRB401125', 'DRB401126', 'DRB401127', 'DRB401129', 'DRB40112', 'DRB401130', 'DRB401131', 'DRB401132', 'DRB401133', 'DRB401134', 'DRB401135', 'DRB401136', 'DRB401137', 'DRB401138', 'DRB401139', 'DRB40113', 'DRB401140', 'DRB401141', 'DRB401142', 'DRB401143', 'DRB401144', 'DRB401146', 'DRB401147', 'DRB401148', 'DRB401150', 'DRB401151', 'DRB401152', 'DRB401153', 'DRB401154', 'DRB401155', 'DRB401156', 'DRB401157', 'DRB40115', 'DRB40117', 'DRB40118', 'DRB40119', 'DRB40120', 'DRB40121', 'DRB40122', 'DRB40123', 'DRB40124', 'DRB40125', 'DRB40126', 'DRB40127', 'DRB40128', 'DRB40129', 'DRB40130', 'DRB40131', 'DRB40132', 'DRB40133', 'DRB40134', 'DRB40135', 'DRB40136', 'DRB40137', 'DRB40139', 'DRB40140', 'DRB40141', 'DRB40142', 'DRB40143', 'DRB40144', 'DRB40145', 'DRB40146', 'DRB40147', 'DRB40148', 'DRB40149', 'DRB40150', 'DRB40151', 'DRB40152', 'DRB40153', 'DRB40154', 'DRB40155', 'DRB40158', 'DRB40159', 'DRB40160', 'DRB40162', 'DRB40163', 'DRB40164', 'DRB40166', 'DRB40167', 'DRB40168', 'DRB40169', 'DRB40170', 'DRB40172', 'DRB40173', 'DRB40174', 'DRB40175', 'DRB40176', 'DRB40177', 'DRB40178', 'DRB40179', 'DRB40181', 'DRB40182', 'DRB40183', 'DRB40185', 'DRB40186', 'DRB40187', 'DRB40188', 'DRB40189', 'DRB40190', 'DRB40191', 'DRB40192', 'DRB40193', 'DRB40194', 'DRB40195', 'DRB40196', 'DRB40197', 'DRB40198', 'DRB40199', 'DRB50108', 'DRB501100', 'DRB501102', 'DRB501103', 'DRB501104', 'DRB501105', 'DRB501106', 'DRB501107', 'DRB501108', 'DRB501109', 'DRB501110', 'DRB501111', 'DRB501112', 'DRB501113', 'DRB501114', 'DRB501115', 'DRB501116', 'DRB501117', 'DRB501118', 'DRB501119', 'DRB50115', 'DRB50116', 'DRB50117', 'DRB50118', 'DRB50119', 'DRB50120', 'DRB50121', 'DRB50122', 'DRB50123', 'DRB50124', 'DRB50125', 'DRB50126', 'DRB50128', 'DRB50129', 'DRB50130', 'DRB50131', 'DRB50132', 'DRB50133', 'DRB50134', 'DRB50135', 'DRB50136', 'DRB50137', 'DRB50138', 'DRB50139', 'DRB50140', 'DRB50141', 'DRB50142', 'DRB50143', 'DRB50144', 'DRB50145', 'DRB50146', 'DRB50147', 'DRB50150', 'DRB50151', 'DRB50154', 'DRB50155', 'DRB50156', 'DRB50157', 'DRB50159', 'DRB50160', 'DRB50161', 'DRB50162', 'DRB50163', 'DRB50164', 'DRB50165', 'DRB50166', 'DRB50169', 'DRB50170', 'DRB50172', 'DRB50173', 'DRB50174', 'DRB50175', 'DRB50176', 'DRB50177', 'DRB50178', 'DRB50180', 'DRB50182', 'DRB50184', 'DRB50185', 'DRB50186', 'DRB50187', 'DRB50188', 'DRB50189', 'DRB50190', 'DRB50191', 'DRB50193', 'DRB50194', 'DRB50195', 'DRB50196', 'DRB50197', 'DRB50198', 'DRB50199', 'DRB50210', 'DRB50211', 'DRB50212', 'DRB50213', 'DRB50214', 'DRB50215', 'DRB50216', 'DRB50217', 'DRB50218', 'DRB50221', 'DRB50231', 'DQA10101DQB10207', 'DQA10101DQB10212', 'DQA10101DQB10225', 'DQA10101DQB10230', 'DQA10101DQB10248', 'DQA10101DQB10271', 'DQA10101DQB10285', 'DQA10101DQB103104', 'DQA10101DQB103105', 'DQA10101DQB103108', 'DQA10101DQB103109', 'DQA10101DQB103113', 'DQA10101DQB103114', 'DQA10101DQB103119', 'DQA10101DQB103120', 'DQA10101DQB103121', 'DQA10101DQB103129', 'DQA10101DQB103131', 'DQA10101DQB103132', 'DQA10101DQB103133', 'DQA10101DQB103134', 'DQA10101DQB103135', 'DQA10101DQB103138', 'DQA10101DQB103139', 'DQA10101DQB103142', 'DQA10101DQB103147', 'DQA10101DQB103154', 'DQA10101DQB103157', 'DQA10101DQB103158', 'DQA10101DQB103163', 'DQA10101DQB103166', 'DQA10101DQB103167', 'DQA10101DQB103172', 'DQA10101DQB103180', 'DQA10101DQB103184', 'DQA10101DQB103185', 'DQA10101DQB103186', 'DQA10101DQB103188', 'DQA10101DQB103191', 'DQA10101DQB103194', 'DQA10101DQB103195', 'DQA10101DQB103196', 'DQA10101DQB103201', 'DQA10101DQB103207', 'DQA10101DQB103208', 'DQA10101DQB103231', 'DQA10101DQB103232', 'DQA10101DQB103235', 'DQA10101DQB103241', 'DQA10101DQB103242', 'DQA10101DQB103251', 'DQA10101DQB103254', 'DQA10101DQB103264', 'DQA10101DQB103265', 'DQA10101DQB10347', 'DQA10101DQB10352', 'DQA10101DQB10357', 'DQA10101DQB10362', 'DQA10101DQB10368', 'DQA10101DQB10369', 'DQA10101DQB10372', 'DQA10101DQB10375', 'DQA10101DQB10382', 'DQA10101DQB10387', 'DQA10101DQB10396', 'DQA10101DQB10422', 'DQA10101DQB10423', 'DQA10101DQB10434', 'DQA10101DQB10504', 'DQA10101DQB105103', 'DQA10101DQB105117', 'DQA10101DQB10518', 'DQA10101DQB10523', 'DQA10101DQB10524', 'DQA10101DQB10528', 'DQA10101DQB10535', 'DQA10101DQB10537', 'DQA10101DQB10542', 'DQA10101DQB10546', 'DQA10101DQB10552', 'DQA10101DQB10583', 'DQA10101DQB10605', 'DQA10101DQB106108', 'DQA10101DQB106110', 'DQA10101DQB106123', 'DQA10101DQB106126', 'DQA10101DQB10613', 'DQA10101DQB106140', 'DQA10101DQB106153', 'DQA10101DQB10620', 'DQA10101DQB106214', 'DQA10101DQB10648', 'DQA10101DQB10652', 'DQA10102DQB10207', 'DQA10102DQB10212', 'DQA10102DQB10225', 'DQA10102DQB10230', 'DQA10102DQB10248', 'DQA10102DQB10271', 'DQA10102DQB10285', 'DQA10102DQB103104', 'DQA10102DQB103105', 'DQA10102DQB103108', 'DQA10102DQB103109', 'DQA10102DQB103113', 'DQA10102DQB103114', 'DQA10102DQB103119', 'DQA10102DQB103120', 'DQA10102DQB103121', 'DQA10102DQB103129', 'DQA10102DQB103131', 'DQA10102DQB103132', 'DQA10102DQB103133', 'DQA10102DQB103134', 'DQA10102DQB103135', 'DQA10102DQB103138', 'DQA10102DQB103139', 'DQA10102DQB103142', 'DQA10102DQB103147', 'DQA10102DQB103154', 'DQA10102DQB103157', 'DQA10102DQB103158', 'DQA10102DQB103163', 'DQA10102DQB103166', 'DQA10102DQB103167', 'DQA10102DQB103172', 'DQA10102DQB103180', 'DQA10102DQB103184', 'DQA10102DQB103185', 'DQA10102DQB103186', 'DQA10102DQB103188', 'DQA10102DQB103191', 'DQA10102DQB103194', 'DQA10102DQB103195', 'DQA10102DQB103196', 'DQA10102DQB103201', 'DQA10102DQB103207', 'DQA10102DQB103208', 'DQA10102DQB103231', 'DQA10102DQB103232', 'DQA10102DQB103235', 'DQA10102DQB103241', 'DQA10102DQB103242', 'DQA10102DQB103251', 'DQA10102DQB103254', 'DQA10102DQB103264', 'DQA10102DQB103265', 'DQA10102DQB10347', 'DQA10102DQB10352', 'DQA10102DQB10357', 'DQA10102DQB10362', 'DQA10102DQB10368', 'DQA10102DQB10369', 'DQA10102DQB10372', 'DQA10102DQB10375', 'DQA10102DQB10382', 'DQA10102DQB10387', 'DQA10102DQB10396', 'DQA10102DQB10422', 'DQA10102DQB10423', 'DQA10102DQB10434', 'DQA10102DQB10504', 'DQA10102DQB105103', 'DQA10102DQB105117', 'DQA10102DQB10518', 'DQA10102DQB10523', 'DQA10102DQB10524', 'DQA10102DQB10528', 'DQA10102DQB10535', 'DQA10102DQB10537', 'DQA10102DQB10542', 'DQA10102DQB10546', 'DQA10102DQB10552', 'DQA10102DQB10583', 'DQA10102DQB10605', 'DQA10102DQB106108', 'DQA10102DQB106110', 'DQA10102DQB106123', 'DQA10102DQB106126', 'DQA10102DQB10613', 'DQA10102DQB106140', 'DQA10102DQB106153', 'DQA10102DQB10620', 'DQA10102DQB106214', 'DQA10102DQB10648', 'DQA10102DQB10652', 'DQA10103DQB10207', 'DQA10103DQB10212', 'DQA10103DQB10225', 'DQA10103DQB10230', 'DQA10103DQB10248', 'DQA10103DQB10271', 'DQA10103DQB10285', 'DQA10103DQB103104', 'DQA10103DQB103105', 'DQA10103DQB103108', 'DQA10103DQB103109', 'DQA10103DQB103113', 'DQA10103DQB103114', 'DQA10103DQB103119', 'DQA10103DQB103120', 'DQA10103DQB103121', 'DQA10103DQB103129', 'DQA10103DQB103131', 'DQA10103DQB103132', 'DQA10103DQB103133', 'DQA10103DQB103134', 'DQA10103DQB103135', 'DQA10103DQB103138', 'DQA10103DQB103139', 'DQA10103DQB103142', 'DQA10103DQB103147', 'DQA10103DQB103154', 'DQA10103DQB103157', 'DQA10103DQB103158', 'DQA10103DQB103163', 'DQA10103DQB103166', 'DQA10103DQB103167', 'DQA10103DQB103172', 'DQA10103DQB103180', 'DQA10103DQB103184', 'DQA10103DQB103185', 'DQA10103DQB103186', 'DQA10103DQB103188', 'DQA10103DQB103191', 'DQA10103DQB103194', 'DQA10103DQB103195', 'DQA10103DQB103196', 'DQA10103DQB103201', 'DQA10103DQB103207', 'DQA10103DQB103208', 'DQA10103DQB103231', 'DQA10103DQB103232', 'DQA10103DQB103235', 'DQA10103DQB103241', 'DQA10103DQB103242', 'DQA10103DQB103251', 'DQA10103DQB103254', 'DQA10103DQB103264', 'DQA10103DQB103265', 'DQA10103DQB10347', 'DQA10103DQB10352', 'DQA10103DQB10357', 'DQA10103DQB10362', 'DQA10103DQB10368', 'DQA10103DQB10369', 'DQA10103DQB10372', 'DQA10103DQB10375', 'DQA10103DQB10382', 'DQA10103DQB10387', 'DQA10103DQB10396', 'DQA10103DQB10422', 'DQA10103DQB10423', 'DQA10103DQB10434', 'DQA10103DQB10504', 'DQA10103DQB105103', 'DQA10103DQB105117', 'DQA10103DQB10518', 'DQA10103DQB10523', 'DQA10103DQB10524', 'DQA10103DQB10528', 'DQA10103DQB10535', 'DQA10103DQB10537', 'DQA10103DQB10542', 'DQA10103DQB10546', 'DQA10103DQB10552', 'DQA10103DQB10583', 'DQA10103DQB10605', 'DQA10103DQB106108', 'DQA10103DQB106110', 'DQA10103DQB106123', 'DQA10103DQB106126', 'DQA10103DQB10613', 'DQA10103DQB106140', 'DQA10103DQB106153', 'DQA10103DQB10620', 'DQA10103DQB106214', 'DQA10103DQB10648', 'DQA10103DQB10652', 'DQA10104DQB10207', 'DQA10104DQB10212', 'DQA10104DQB10225', 'DQA10104DQB10230', 'DQA10104DQB10248', 'DQA10104DQB10271', 'DQA10104DQB10285', 'DQA10104DQB103104', 'DQA10104DQB103105', 'DQA10104DQB103108', 'DQA10104DQB103109', 'DQA10104DQB103113', 'DQA10104DQB103114', 'DQA10104DQB103119', 'DQA10104DQB103120', 'DQA10104DQB103121', 'DQA10104DQB103129', 'DQA10104DQB103131', 'DQA10104DQB103132', 'DQA10104DQB103133', 'DQA10104DQB103134', 'DQA10104DQB103135', 'DQA10104DQB103138', 'DQA10104DQB103139', 'DQA10104DQB103142', 'DQA10104DQB103147', 'DQA10104DQB103154', 'DQA10104DQB103157', 'DQA10104DQB103158', 'DQA10104DQB103163', 'DQA10104DQB103166', 'DQA10104DQB103167', 'DQA10104DQB103172', 'DQA10104DQB103180', 'DQA10104DQB103184', 'DQA10104DQB103185', 'DQA10104DQB103186', 'DQA10104DQB103188', 'DQA10104DQB103191', 'DQA10104DQB103194', 'DQA10104DQB103195', 'DQA10104DQB103196', 'DQA10104DQB103201', 'DQA10104DQB103207', 'DQA10104DQB103208', 'DQA10104DQB103231', 'DQA10104DQB103232', 'DQA10104DQB103235', 'DQA10104DQB103241', 'DQA10104DQB103242', 'DQA10104DQB103251', 'DQA10104DQB103254', 'DQA10104DQB103264', 'DQA10104DQB103265', 'DQA10104DQB10347', 'DQA10104DQB10352', 'DQA10104DQB10357', 'DQA10104DQB10362', 'DQA10104DQB10368', 'DQA10104DQB10369', 'DQA10104DQB10372', 'DQA10104DQB10375', 'DQA10104DQB10382', 'DQA10104DQB10387', 'DQA10104DQB10396', 'DQA10104DQB10422', 'DQA10104DQB10423', 'DQA10104DQB10434', 'DQA10104DQB10504', 'DQA10104DQB105103', 'DQA10104DQB105117', 'DQA10104DQB10518', 'DQA10104DQB10523', 'DQA10104DQB10524', 'DQA10104DQB10528', 'DQA10104DQB10535', 'DQA10104DQB10537', 'DQA10104DQB10542', 'DQA10104DQB10546', 'DQA10104DQB10552', 'DQA10104DQB10583', 'DQA10104DQB10605', 'DQA10104DQB106108', 'DQA10104DQB106110', 'DQA10104DQB106123', 'DQA10104DQB106126', 'DQA10104DQB10613', 'DQA10104DQB106140', 'DQA10104DQB106153', 'DQA10104DQB10620', 'DQA10104DQB106214', 'DQA10104DQB10648', 'DQA10104DQB10652', 'DQA10105DQB10207', 'DQA10105DQB10212', 'DQA10105DQB10225', 'DQA10105DQB10230', 'DQA10105DQB10248', 'DQA10105DQB10271', 'DQA10105DQB10285', 'DQA10105DQB103104', 'DQA10105DQB103105', 'DQA10105DQB103108', 'DQA10105DQB103109', 'DQA10105DQB103113', 'DQA10105DQB103114', 'DQA10105DQB103119', 'DQA10105DQB103120', 'DQA10105DQB103121', 'DQA10105DQB103129', 'DQA10105DQB103131', 'DQA10105DQB103132', 'DQA10105DQB103133', 'DQA10105DQB103134', 'DQA10105DQB103135', 'DQA10105DQB103138', 'DQA10105DQB103139', 'DQA10105DQB103142', 'DQA10105DQB103147', 'DQA10105DQB103154', 'DQA10105DQB103157', 'DQA10105DQB103158', 'DQA10105DQB103163', 'DQA10105DQB103166', 'DQA10105DQB103167', 'DQA10105DQB103172', 'DQA10105DQB103180', 'DQA10105DQB103184', 'DQA10105DQB103185', 'DQA10105DQB103186', 'DQA10105DQB103188', 'DQA10105DQB103191', 'DQA10105DQB103194', 'DQA10105DQB103195', 'DQA10105DQB103196', 'DQA10105DQB103201', 'DQA10105DQB103207', 'DQA10105DQB103208', 'DQA10105DQB103231', 'DQA10105DQB103232', 'DQA10105DQB103235', 'DQA10105DQB103241', 'DQA10105DQB103242', 'DQA10105DQB103251', 'DQA10105DQB103254', 'DQA10105DQB103264', 'DQA10105DQB103265', 'DQA10105DQB10347', 'DQA10105DQB10352', 'DQA10105DQB10357', 'DQA10105DQB10362', 'DQA10105DQB10368', 'DQA10105DQB10369', 'DQA10105DQB10372', 'DQA10105DQB10375', 'DQA10105DQB10382', 'DQA10105DQB10387', 'DQA10105DQB10396', 'DQA10105DQB10422', 'DQA10105DQB10423', 'DQA10105DQB10434', 'DQA10105DQB10504', 'DQA10105DQB105103', 'DQA10105DQB105117', 'DQA10105DQB10518', 'DQA10105DQB10523', 'DQA10105DQB10524', 'DQA10105DQB10528', 'DQA10105DQB10535', 'DQA10105DQB10537', 'DQA10105DQB10542', 'DQA10105DQB10546', 'DQA10105DQB10552', 'DQA10105DQB10583', 'DQA10105DQB10605', 'DQA10105DQB106108', 'DQA10105DQB106110', 'DQA10105DQB106123', 'DQA10105DQB106126', 'DQA10105DQB10613', 'DQA10105DQB106140', 'DQA10105DQB106153', 'DQA10105DQB10620', 'DQA10105DQB106214', 'DQA10105DQB10648', 'DQA10105DQB10652', 'DQA10106DQB10207', 'DQA10106DQB10212', 'DQA10106DQB10225', 'DQA10106DQB10230', 'DQA10106DQB10248', 'DQA10106DQB10271', 'DQA10106DQB10285', 'DQA10106DQB103104', 'DQA10106DQB103105', 'DQA10106DQB103108', 'DQA10106DQB103109', 'DQA10106DQB103113', 'DQA10106DQB103114', 'DQA10106DQB103119', 'DQA10106DQB103120', 'DQA10106DQB103121', 'DQA10106DQB103129', 'DQA10106DQB103131', 'DQA10106DQB103132', 'DQA10106DQB103133', 'DQA10106DQB103134', 'DQA10106DQB103135', 'DQA10106DQB103138', 'DQA10106DQB103139', 'DQA10106DQB103142', 'DQA10106DQB103147', 'DQA10106DQB103154', 'DQA10106DQB103157', 'DQA10106DQB103158', 'DQA10106DQB103163', 'DQA10106DQB103166', 'DQA10106DQB103167', 'DQA10106DQB103172', 'DQA10106DQB103180', 'DQA10106DQB103184', 'DQA10106DQB103185', 'DQA10106DQB103186', 'DQA10106DQB103188', 'DQA10106DQB103191', 'DQA10106DQB103194', 'DQA10106DQB103195', 'DQA10106DQB103196', 'DQA10106DQB103201', 'DQA10106DQB103207', 'DQA10106DQB103208', 'DQA10106DQB103231', 'DQA10106DQB103232', 'DQA10106DQB103235', 'DQA10106DQB103241', 'DQA10106DQB103242', 'DQA10106DQB103251', 'DQA10106DQB103254', 'DQA10106DQB103264', 'DQA10106DQB103265', 'DQA10106DQB10347', 'DQA10106DQB10352', 'DQA10106DQB10357', 'DQA10106DQB10362', 'DQA10106DQB10368', 'DQA10106DQB10369', 'DQA10106DQB10372', 'DQA10106DQB10375', 'DQA10106DQB10382', 'DQA10106DQB10387', 'DQA10106DQB10396', 'DQA10106DQB10422', 'DQA10106DQB10423', 'DQA10106DQB10434', 'DQA10106DQB10504', 'DQA10106DQB105103', 'DQA10106DQB105117', 'DQA10106DQB10518', 'DQA10106DQB10523', 'DQA10106DQB10524', 'DQA10106DQB10528', 'DQA10106DQB10535', 'DQA10106DQB10537', 'DQA10106DQB10542', 'DQA10106DQB10546', 'DQA10106DQB10552', 'DQA10106DQB10583', 'DQA10106DQB10605', 'DQA10106DQB106108', 'DQA10106DQB106110', 'DQA10106DQB106123', 'DQA10106DQB106126', 'DQA10106DQB10613', 'DQA10106DQB106140', 'DQA10106DQB106153', 'DQA10106DQB10620', 'DQA10106DQB106214', 'DQA10106DQB10648', 'DQA10106DQB10652', 'DQA10107DQB10207', 'DQA10107DQB10212', 'DQA10107DQB10225', 'DQA10107DQB10230', 'DQA10107DQB10248', 'DQA10107DQB10271', 'DQA10107DQB10285', 'DQA10107DQB103104', 'DQA10107DQB103105', 'DQA10107DQB103108', 'DQA10107DQB103109', 'DQA10107DQB103113', 'DQA10107DQB103114', 'DQA10107DQB103119', 'DQA10107DQB103120', 'DQA10107DQB103121', 'DQA10107DQB103129', 'DQA10107DQB103131', 'DQA10107DQB103132', 'DQA10107DQB103133', 'DQA10107DQB103134', 'DQA10107DQB103135', 'DQA10107DQB103138', 'DQA10107DQB103139', 'DQA10107DQB103142', 'DQA10107DQB103147', 'DQA10107DQB103154', 'DQA10107DQB103157', 'DQA10107DQB103158', 'DQA10107DQB103163', 'DQA10107DQB103166', 'DQA10107DQB103167', 'DQA10107DQB103172', 'DQA10107DQB103180', 'DQA10107DQB103184', 'DQA10107DQB103185', 'DQA10107DQB103186', 'DQA10107DQB103188', 'DQA10107DQB103191', 'DQA10107DQB103194', 'DQA10107DQB103195', 'DQA10107DQB103196', 'DQA10107DQB103201', 'DQA10107DQB103207', 'DQA10107DQB103208', 'DQA10107DQB103231', 'DQA10107DQB103232', 'DQA10107DQB103235', 'DQA10107DQB103241', 'DQA10107DQB103242', 'DQA10107DQB103251', 'DQA10107DQB103254', 'DQA10107DQB103264', 'DQA10107DQB103265', 'DQA10107DQB10347', 'DQA10107DQB10352', 'DQA10107DQB10357', 'DQA10107DQB10362', 'DQA10107DQB10368', 'DQA10107DQB10369', 'DQA10107DQB10372', 'DQA10107DQB10375', 'DQA10107DQB10382', 'DQA10107DQB10387', 'DQA10107DQB10396', 'DQA10107DQB10422', 'DQA10107DQB10423', 'DQA10107DQB10434', 'DQA10107DQB10504', 'DQA10107DQB105103', 'DQA10107DQB105117', 'DQA10107DQB10518', 'DQA10107DQB10523', 'DQA10107DQB10524', 'DQA10107DQB10528', 'DQA10107DQB10535', 'DQA10107DQB10537', 'DQA10107DQB10542', 'DQA10107DQB10546', 'DQA10107DQB10552', 'DQA10107DQB10583', 'DQA10107DQB10605', 'DQA10107DQB106108', 'DQA10107DQB106110', 'DQA10107DQB106123', 'DQA10107DQB106126', 'DQA10107DQB10613', 'DQA10107DQB106140', 'DQA10107DQB106153', 'DQA10107DQB10620', 'DQA10107DQB106214', 'DQA10107DQB10648', 'DQA10107DQB10652', 'DQA10108DQB10207', 'DQA10108DQB10212', 'DQA10108DQB10225', 'DQA10108DQB10230', 'DQA10108DQB10248', 'DQA10108DQB10271', 'DQA10108DQB10285', 'DQA10108DQB103104', 'DQA10108DQB103105', 'DQA10108DQB103108', 'DQA10108DQB103109', 'DQA10108DQB103113', 'DQA10108DQB103114', 'DQA10108DQB103119', 'DQA10108DQB103120', 'DQA10108DQB103121', 'DQA10108DQB103129', 'DQA10108DQB103131', 'DQA10108DQB103132', 'DQA10108DQB103133', 'DQA10108DQB103134', 'DQA10108DQB103135', 'DQA10108DQB103138', 'DQA10108DQB103139', 'DQA10108DQB103142', 'DQA10108DQB103147', 'DQA10108DQB103154', 'DQA10108DQB103157', 'DQA10108DQB103158', 'DQA10108DQB103163', 'DQA10108DQB103166', 'DQA10108DQB103167', 'DQA10108DQB103172', 'DQA10108DQB103180', 'DQA10108DQB103184', 'DQA10108DQB103185', 'DQA10108DQB103186', 'DQA10108DQB103188', 'DQA10108DQB103191', 'DQA10108DQB103194', 'DQA10108DQB103195', 'DQA10108DQB103196', 'DQA10108DQB103201', 'DQA10108DQB103207', 'DQA10108DQB103208', 'DQA10108DQB103231', 'DQA10108DQB103232', 'DQA10108DQB103235', 'DQA10108DQB103241', 'DQA10108DQB103242', 'DQA10108DQB103251', 'DQA10108DQB103254', 'DQA10108DQB103264', 'DQA10108DQB103265', 'DQA10108DQB10347', 'DQA10108DQB10352', 'DQA10108DQB10357', 'DQA10108DQB10362', 'DQA10108DQB10368', 'DQA10108DQB10369', 'DQA10108DQB10372', 'DQA10108DQB10375', 'DQA10108DQB10382', 'DQA10108DQB10387', 'DQA10108DQB10396', 'DQA10108DQB10422', 'DQA10108DQB10423', 'DQA10108DQB10434', 'DQA10108DQB10504', 'DQA10108DQB105103', 'DQA10108DQB105117', 'DQA10108DQB10518', 'DQA10108DQB10523', 'DQA10108DQB10524', 'DQA10108DQB10528', 'DQA10108DQB10535', 'DQA10108DQB10537', 'DQA10108DQB10542', 'DQA10108DQB10546', 'DQA10108DQB10552', 'DQA10108DQB10583', 'DQA10108DQB10605', 'DQA10108DQB106108', 'DQA10108DQB106110', 'DQA10108DQB106123', 'DQA10108DQB106126', 'DQA10108DQB10613', 'DQA10108DQB106140', 'DQA10108DQB106153', 'DQA10108DQB10620', 'DQA10108DQB106214', 'DQA10108DQB10648', 'DQA10108DQB10652', 'DQA10109DQB10207', 'DQA10109DQB10212', 'DQA10109DQB10225', 'DQA10109DQB10230', 'DQA10109DQB10248', 'DQA10109DQB10271', 'DQA10109DQB10285', 'DQA10109DQB103104', 'DQA10109DQB103105', 'DQA10109DQB103108', 'DQA10109DQB103109', 'DQA10109DQB103113', 'DQA10109DQB103114', 'DQA10109DQB103119', 'DQA10109DQB103120', 'DQA10109DQB103121', 'DQA10109DQB103129', 'DQA10109DQB103131', 'DQA10109DQB103132', 'DQA10109DQB103133', 'DQA10109DQB103134', 'DQA10109DQB103135', 'DQA10109DQB103138', 'DQA10109DQB103139', 'DQA10109DQB103142', 'DQA10109DQB103147', 'DQA10109DQB103154', 'DQA10109DQB103157', 'DQA10109DQB103158', 'DQA10109DQB103163', 'DQA10109DQB103166', 'DQA10109DQB103167', 'DQA10109DQB103172', 'DQA10109DQB103180', 'DQA10109DQB103184', 'DQA10109DQB103185', 'DQA10109DQB103186', 'DQA10109DQB103188', 'DQA10109DQB103191', 'DQA10109DQB103194', 'DQA10109DQB103195', 'DQA10109DQB103196', 'DQA10109DQB103201', 'DQA10109DQB103207', 'DQA10109DQB103208', 'DQA10109DQB103231', 'DQA10109DQB103232', 'DQA10109DQB103235', 'DQA10109DQB103241', 'DQA10109DQB103242', 'DQA10109DQB103251', 'DQA10109DQB103254', 'DQA10109DQB103264', 'DQA10109DQB103265', 'DQA10109DQB10347', 'DQA10109DQB10352', 'DQA10109DQB10357', 'DQA10109DQB10362', 'DQA10109DQB10368', 'DQA10109DQB10369', 'DQA10109DQB10372', 'DQA10109DQB10375', 'DQA10109DQB10382', 'DQA10109DQB10387', 'DQA10109DQB10396', 'DQA10109DQB10422', 'DQA10109DQB10423', 'DQA10109DQB10434', 'DQA10109DQB10504', 'DQA10109DQB105103', 'DQA10109DQB105117', 'DQA10109DQB10518', 'DQA10109DQB10523', 'DQA10109DQB10524', 'DQA10109DQB10528', 'DQA10109DQB10535', 'DQA10109DQB10537', 'DQA10109DQB10542', 'DQA10109DQB10546', 'DQA10109DQB10552', 'DQA10109DQB10583', 'DQA10109DQB10605', 'DQA10109DQB106108', 'DQA10109DQB106110', 'DQA10109DQB106123', 'DQA10109DQB106126', 'DQA10109DQB10613', 'DQA10109DQB106140', 'DQA10109DQB106153', 'DQA10109DQB10620', 'DQA10109DQB106214', 'DQA10109DQB10648', 'DQA10109DQB10652', 'DQA10110DQB10201', 'DQA10110DQB10202', 'DQA10110DQB10203', 'DQA10110DQB10204', 'DQA10110DQB10205', 'DQA10110DQB10206', 'DQA10110DQB10207', 'DQA10110DQB10212', 'DQA10110DQB10225', 'DQA10110DQB10230', 'DQA10110DQB10248', 'DQA10110DQB10271', 'DQA10110DQB10285', 'DQA10110DQB10301', 'DQA10110DQB10302', 'DQA10110DQB10303', 'DQA10110DQB10304', 'DQA10110DQB10305', 'DQA10110DQB10306', 'DQA10110DQB10307', 'DQA10110DQB10308', 'DQA10110DQB10309', 'DQA10110DQB103104', 'DQA10110DQB103105', 'DQA10110DQB103108', 'DQA10110DQB103109', 'DQA10110DQB10310', 'DQA10110DQB103113', 'DQA10110DQB103114', 'DQA10110DQB103119', 'DQA10110DQB10311', 'DQA10110DQB103120', 'DQA10110DQB103121', 'DQA10110DQB103129', 'DQA10110DQB10312', 'DQA10110DQB103131', 'DQA10110DQB103132', 'DQA10110DQB103133', 'DQA10110DQB103134', 'DQA10110DQB103135', 'DQA10110DQB103138', 'DQA10110DQB103139', 'DQA10110DQB10313', 'DQA10110DQB103142', 'DQA10110DQB103147', 'DQA10110DQB10314', 'DQA10110DQB103154', 'DQA10110DQB103157', 'DQA10110DQB103158', 'DQA10110DQB10315', 'DQA10110DQB103163', 'DQA10110DQB103166', 'DQA10110DQB103167', 'DQA10110DQB10316', 'DQA10110DQB103172', 'DQA10110DQB10317', 'DQA10110DQB103180', 'DQA10110DQB103184', 'DQA10110DQB103185', 'DQA10110DQB103186', 'DQA10110DQB103188', 'DQA10110DQB10318', 'DQA10110DQB103191', 'DQA10110DQB103194', 'DQA10110DQB103195', 'DQA10110DQB103196', 'DQA10110DQB10319', 'DQA10110DQB103201', 'DQA10110DQB103207', 'DQA10110DQB103208', 'DQA10110DQB10320', 'DQA10110DQB10321', 'DQA10110DQB10322', 'DQA10110DQB103231', 'DQA10110DQB103232', 'DQA10110DQB103235', 'DQA10110DQB10323', 'DQA10110DQB103241', 'DQA10110DQB103242', 'DQA10110DQB10324', 'DQA10110DQB103251', 'DQA10110DQB103254', 'DQA10110DQB10325', 'DQA10110DQB103264', 'DQA10110DQB103265', 'DQA10110DQB10326', 'DQA10110DQB10327', 'DQA10110DQB10328', 'DQA10110DQB10329', 'DQA10110DQB10330', 'DQA10110DQB10331', 'DQA10110DQB10332', 'DQA10110DQB10333', 'DQA10110DQB10334', 'DQA10110DQB10335', 'DQA10110DQB10336', 'DQA10110DQB10337', 'DQA10110DQB10338', 'DQA10110DQB10347', 'DQA10110DQB10352', 'DQA10110DQB10357', 'DQA10110DQB10362', 'DQA10110DQB10368', 'DQA10110DQB10369', 'DQA10110DQB10372', 'DQA10110DQB10375', 'DQA10110DQB10382', 'DQA10110DQB10387', 'DQA10110DQB10396', 'DQA10110DQB10401', 'DQA10110DQB10402', 'DQA10110DQB10403', 'DQA10110DQB10404', 'DQA10110DQB10405', 'DQA10110DQB10406', 'DQA10110DQB10407', 'DQA10110DQB10408', 'DQA10110DQB10422', 'DQA10110DQB10423', 'DQA10110DQB10434', 'DQA10110DQB10501', 'DQA10110DQB10502', 'DQA10110DQB10503', 'DQA10110DQB10504', 'DQA10110DQB10505', 'DQA10110DQB10506', 'DQA10110DQB10507', 'DQA10110DQB10508', 'DQA10110DQB10509', 'DQA10110DQB105103', 'DQA10110DQB10510', 'DQA10110DQB105117', 'DQA10110DQB10511', 'DQA10110DQB10512', 'DQA10110DQB10513', 'DQA10110DQB10514', 'DQA10110DQB10518', 'DQA10110DQB10523', 'DQA10110DQB10524', 'DQA10110DQB10528', 'DQA10110DQB10535', 'DQA10110DQB10537', 'DQA10110DQB10542', 'DQA10110DQB10546', 'DQA10110DQB10552', 'DQA10110DQB10583', 'DQA10110DQB10601', 'DQA10110DQB10602', 'DQA10110DQB10603', 'DQA10110DQB10604', 'DQA10110DQB10605', 'DQA10110DQB10607', 'DQA10110DQB10608', 'DQA10110DQB10609', 'DQA10110DQB106108', 'DQA10110DQB10610', 'DQA10110DQB106110', 'DQA10110DQB10611', 'DQA10110DQB106123', 'DQA10110DQB106126', 'DQA10110DQB10612', 'DQA10110DQB10613', 'DQA10110DQB106140', 'DQA10110DQB10614', 'DQA10110DQB106153', 'DQA10110DQB10615', 'DQA10110DQB10616', 'DQA10110DQB10617', 'DQA10110DQB10618', 'DQA10110DQB10619', 'DQA10110DQB10620', 'DQA10110DQB106214', 'DQA10110DQB10621', 'DQA10110DQB10622', 'DQA10110DQB10623', 'DQA10110DQB10624', 'DQA10110DQB10625', 'DQA10110DQB10627', 'DQA10110DQB10628', 'DQA10110DQB10629', 'DQA10110DQB10630', 'DQA10110DQB10631', 'DQA10110DQB10632', 'DQA10110DQB10633', 'DQA10110DQB10634', 'DQA10110DQB10635', 'DQA10110DQB10636', 'DQA10110DQB10637', 'DQA10110DQB10638', 'DQA10110DQB10639', 'DQA10110DQB10640', 'DQA10110DQB10641', 'DQA10110DQB10642', 'DQA10110DQB10643', 'DQA10110DQB10644', 'DQA10110DQB10648', 'DQA10110DQB10652', 'DQA10201DQB10207', 'DQA10201DQB10212', 'DQA10201DQB10225', 'DQA10201DQB10230', 'DQA10201DQB10248', 'DQA10201DQB10271', 'DQA10201DQB10285', 'DQA10201DQB103104', 'DQA10201DQB103105', 'DQA10201DQB103108', 'DQA10201DQB103109', 'DQA10201DQB103113', 'DQA10201DQB103114', 'DQA10201DQB103119', 'DQA10201DQB103120', 'DQA10201DQB103121', 'DQA10201DQB103129', 'DQA10201DQB103131', 'DQA10201DQB103132', 'DQA10201DQB103133', 'DQA10201DQB103134', 'DQA10201DQB103135', 'DQA10201DQB103138', 'DQA10201DQB103139', 'DQA10201DQB103142', 'DQA10201DQB103147', 'DQA10201DQB103154', 'DQA10201DQB103157', 'DQA10201DQB103158', 'DQA10201DQB103163', 'DQA10201DQB103166', 'DQA10201DQB103167', 'DQA10201DQB103172', 'DQA10201DQB103180', 'DQA10201DQB103184', 'DQA10201DQB103185', 'DQA10201DQB103186', 'DQA10201DQB103188', 'DQA10201DQB103191', 'DQA10201DQB103194', 'DQA10201DQB103195', 'DQA10201DQB103196', 'DQA10201DQB103201', 'DQA10201DQB103207', 'DQA10201DQB103208', 'DQA10201DQB103231', 'DQA10201DQB103232', 'DQA10201DQB103235', 'DQA10201DQB103241', 'DQA10201DQB103242', 'DQA10201DQB103251', 'DQA10201DQB103254', 'DQA10201DQB103264', 'DQA10201DQB103265', 'DQA10201DQB10347', 'DQA10201DQB10352', 'DQA10201DQB10357', 'DQA10201DQB10362', 'DQA10201DQB10368', 'DQA10201DQB10369', 'DQA10201DQB10372', 'DQA10201DQB10375', 'DQA10201DQB10382', 'DQA10201DQB10387', 'DQA10201DQB10396', 'DQA10201DQB10422', 'DQA10201DQB10423', 'DQA10201DQB10434', 'DQA10201DQB10504', 'DQA10201DQB105103', 'DQA10201DQB105117', 'DQA10201DQB10518', 'DQA10201DQB10523', 'DQA10201DQB10524', 'DQA10201DQB10528', 'DQA10201DQB10535', 'DQA10201DQB10537', 'DQA10201DQB10542', 'DQA10201DQB10546', 'DQA10201DQB10552', 'DQA10201DQB10583', 'DQA10201DQB10605', 'DQA10201DQB106108', 'DQA10201DQB106110', 'DQA10201DQB106123', 'DQA10201DQB106126', 'DQA10201DQB10613', 'DQA10201DQB106140', 'DQA10201DQB106153', 'DQA10201DQB10620', 'DQA10201DQB106214', 'DQA10201DQB10648', 'DQA10201DQB10652', 'DQA10301DQB10207', 'DQA10301DQB10212', 'DQA10301DQB10225', 'DQA10301DQB10230', 'DQA10301DQB10248', 'DQA10301DQB10271', 'DQA10301DQB10285', 'DQA10301DQB103104', 'DQA10301DQB103105', 'DQA10301DQB103108', 'DQA10301DQB103109', 'DQA10301DQB103113', 'DQA10301DQB103114', 'DQA10301DQB103119', 'DQA10301DQB103120', 'DQA10301DQB103121', 'DQA10301DQB103129', 'DQA10301DQB103131', 'DQA10301DQB103132', 'DQA10301DQB103133', 'DQA10301DQB103134', 'DQA10301DQB103135', 'DQA10301DQB103138', 'DQA10301DQB103139', 'DQA10301DQB103142', 'DQA10301DQB103147', 'DQA10301DQB103154', 'DQA10301DQB103157', 'DQA10301DQB103158', 'DQA10301DQB103163', 'DQA10301DQB103166', 'DQA10301DQB103167', 'DQA10301DQB103172', 'DQA10301DQB103180', 'DQA10301DQB103184', 'DQA10301DQB103185', 'DQA10301DQB103186', 'DQA10301DQB103188', 'DQA10301DQB103191', 'DQA10301DQB103194', 'DQA10301DQB103195', 'DQA10301DQB103196', 'DQA10301DQB103201', 'DQA10301DQB103207', 'DQA10301DQB103208', 'DQA10301DQB103231', 'DQA10301DQB103232', 'DQA10301DQB103235', 'DQA10301DQB103241', 'DQA10301DQB103242', 'DQA10301DQB103251', 'DQA10301DQB103254', 'DQA10301DQB103264', 'DQA10301DQB103265', 'DQA10301DQB10347', 'DQA10301DQB10352', 'DQA10301DQB10357', 'DQA10301DQB10362', 'DQA10301DQB10368', 'DQA10301DQB10369', 'DQA10301DQB10372', 'DQA10301DQB10375', 'DQA10301DQB10382', 'DQA10301DQB10387', 'DQA10301DQB10396', 'DQA10301DQB10422', 'DQA10301DQB10423', 'DQA10301DQB10434', 'DQA10301DQB10504', 'DQA10301DQB105103', 'DQA10301DQB105117', 'DQA10301DQB10518', 'DQA10301DQB10523', 'DQA10301DQB10524', 'DQA10301DQB10528', 'DQA10301DQB10535', 'DQA10301DQB10537', 'DQA10301DQB10542', 'DQA10301DQB10546', 'DQA10301DQB10552', 'DQA10301DQB10583', 'DQA10301DQB10605', 'DQA10301DQB106108', 'DQA10301DQB106110', 'DQA10301DQB106123', 'DQA10301DQB106126', 'DQA10301DQB10613', 'DQA10301DQB106140', 'DQA10301DQB106153', 'DQA10301DQB10620', 'DQA10301DQB106214', 'DQA10301DQB10648', 'DQA10301DQB10652', 'DQA10302DQB10207', 'DQA10302DQB10212', 'DQA10302DQB10225', 'DQA10302DQB10230', 'DQA10302DQB10248', 'DQA10302DQB10271', 'DQA10302DQB10285', 'DQA10302DQB103104', 'DQA10302DQB103105', 'DQA10302DQB103108', 'DQA10302DQB103109', 'DQA10302DQB103113', 'DQA10302DQB103114', 'DQA10302DQB103119', 'DQA10302DQB103120', 'DQA10302DQB103121', 'DQA10302DQB103129', 'DQA10302DQB103131', 'DQA10302DQB103132', 'DQA10302DQB103133', 'DQA10302DQB103134', 'DQA10302DQB103135', 'DQA10302DQB103138', 'DQA10302DQB103139', 'DQA10302DQB103142', 'DQA10302DQB103147', 'DQA10302DQB103154', 'DQA10302DQB103157', 'DQA10302DQB103158', 'DQA10302DQB103163', 'DQA10302DQB103166', 'DQA10302DQB103167', 'DQA10302DQB103172', 'DQA10302DQB103180', 'DQA10302DQB103184', 'DQA10302DQB103185', 'DQA10302DQB103186', 'DQA10302DQB103188', 'DQA10302DQB103191', 'DQA10302DQB103194', 'DQA10302DQB103195', 'DQA10302DQB103196', 'DQA10302DQB103201', 'DQA10302DQB103207', 'DQA10302DQB103208', 'DQA10302DQB103231', 'DQA10302DQB103232', 'DQA10302DQB103235', 'DQA10302DQB103241', 'DQA10302DQB103242', 'DQA10302DQB103251', 'DQA10302DQB103254', 'DQA10302DQB103264', 'DQA10302DQB103265', 'DQA10302DQB10347', 'DQA10302DQB10352', 'DQA10302DQB10357', 'DQA10302DQB10362', 'DQA10302DQB10368', 'DQA10302DQB10369', 'DQA10302DQB10372', 'DQA10302DQB10375', 'DQA10302DQB10382', 'DQA10302DQB10387', 'DQA10302DQB10396', 'DQA10302DQB10422', 'DQA10302DQB10423', 'DQA10302DQB10434', 'DQA10302DQB10504', 'DQA10302DQB105103', 'DQA10302DQB105117', 'DQA10302DQB10518', 'DQA10302DQB10523', 'DQA10302DQB10524', 'DQA10302DQB10528', 'DQA10302DQB10535', 'DQA10302DQB10537', 'DQA10302DQB10542', 'DQA10302DQB10546', 'DQA10302DQB10552', 'DQA10302DQB10583', 'DQA10302DQB10605', 'DQA10302DQB106108', 'DQA10302DQB106110', 'DQA10302DQB106123', 'DQA10302DQB106126', 'DQA10302DQB10613', 'DQA10302DQB106140', 'DQA10302DQB106153', 'DQA10302DQB10620', 'DQA10302DQB106214', 'DQA10302DQB10648', 'DQA10302DQB10652', 'DQA10303DQB10207', 'DQA10303DQB10212', 'DQA10303DQB10225', 'DQA10303DQB10230', 'DQA10303DQB10248', 'DQA10303DQB10271', 'DQA10303DQB10285', 'DQA10303DQB103104', 'DQA10303DQB103105', 'DQA10303DQB103108', 'DQA10303DQB103109', 'DQA10303DQB103113', 'DQA10303DQB103114', 'DQA10303DQB103119', 'DQA10303DQB103120', 'DQA10303DQB103121', 'DQA10303DQB103129', 'DQA10303DQB103131', 'DQA10303DQB103132', 'DQA10303DQB103133', 'DQA10303DQB103134', 'DQA10303DQB103135', 'DQA10303DQB103138', 'DQA10303DQB103139', 'DQA10303DQB103142', 'DQA10303DQB103147', 'DQA10303DQB103154', 'DQA10303DQB103157', 'DQA10303DQB103158', 'DQA10303DQB103163', 'DQA10303DQB103166', 'DQA10303DQB103167', 'DQA10303DQB103172', 'DQA10303DQB103180', 'DQA10303DQB103184', 'DQA10303DQB103185', 'DQA10303DQB103186', 'DQA10303DQB103188', 'DQA10303DQB103191', 'DQA10303DQB103194', 'DQA10303DQB103195', 'DQA10303DQB103196', 'DQA10303DQB103201', 'DQA10303DQB103207', 'DQA10303DQB103208', 'DQA10303DQB103231', 'DQA10303DQB103232', 'DQA10303DQB103235', 'DQA10303DQB103241', 'DQA10303DQB103242', 'DQA10303DQB103251', 'DQA10303DQB103254', 'DQA10303DQB103264', 'DQA10303DQB103265', 'DQA10303DQB10347', 'DQA10303DQB10352', 'DQA10303DQB10357', 'DQA10303DQB10362', 'DQA10303DQB10368', 'DQA10303DQB10369', 'DQA10303DQB10372', 'DQA10303DQB10375', 'DQA10303DQB10382', 'DQA10303DQB10387', 'DQA10303DQB10396', 'DQA10303DQB10422', 'DQA10303DQB10423', 'DQA10303DQB10434', 'DQA10303DQB10504', 'DQA10303DQB105103', 'DQA10303DQB105117', 'DQA10303DQB10518', 'DQA10303DQB10523', 'DQA10303DQB10524', 'DQA10303DQB10528', 'DQA10303DQB10535', 'DQA10303DQB10537', 'DQA10303DQB10542', 'DQA10303DQB10546', 'DQA10303DQB10552', 'DQA10303DQB10583', 'DQA10303DQB10605', 'DQA10303DQB106108', 'DQA10303DQB106110', 'DQA10303DQB106123', 'DQA10303DQB106126', 'DQA10303DQB10613', 'DQA10303DQB106140', 'DQA10303DQB106153', 'DQA10303DQB10620', 'DQA10303DQB106214', 'DQA10303DQB10648', 'DQA10303DQB10652', 'DQA10401DQB10207', 'DQA10401DQB10212', 'DQA10401DQB10225', 'DQA10401DQB10230', 'DQA10401DQB10248', 'DQA10401DQB10271', 'DQA10401DQB10285', 'DQA10401DQB103104', 'DQA10401DQB103105', 'DQA10401DQB103108', 'DQA10401DQB103109', 'DQA10401DQB103113', 'DQA10401DQB103114', 'DQA10401DQB103119', 'DQA10401DQB103120', 'DQA10401DQB103121', 'DQA10401DQB103129', 'DQA10401DQB103131', 'DQA10401DQB103132', 'DQA10401DQB103133', 'DQA10401DQB103134', 'DQA10401DQB103135', 'DQA10401DQB103138', 'DQA10401DQB103139', 'DQA10401DQB103142', 'DQA10401DQB103147', 'DQA10401DQB103154', 'DQA10401DQB103157', 'DQA10401DQB103158', 'DQA10401DQB103163', 'DQA10401DQB103166', 'DQA10401DQB103167', 'DQA10401DQB103172', 'DQA10401DQB103180', 'DQA10401DQB103184', 'DQA10401DQB103185', 'DQA10401DQB103186', 'DQA10401DQB103188', 'DQA10401DQB103191', 'DQA10401DQB103194', 'DQA10401DQB103195', 'DQA10401DQB103196', 'DQA10401DQB103201', 'DQA10401DQB103207', 'DQA10401DQB103208', 'DQA10401DQB103231', 'DQA10401DQB103232', 'DQA10401DQB103235', 'DQA10401DQB103241', 'DQA10401DQB103242', 'DQA10401DQB103251', 'DQA10401DQB103254', 'DQA10401DQB103264', 'DQA10401DQB103265', 'DQA10401DQB10347', 'DQA10401DQB10352', 'DQA10401DQB10357', 'DQA10401DQB10362', 'DQA10401DQB10368', 'DQA10401DQB10369', 'DQA10401DQB10372', 'DQA10401DQB10375', 'DQA10401DQB10382', 'DQA10401DQB10387', 'DQA10401DQB10396', 'DQA10401DQB10422', 'DQA10401DQB10423', 'DQA10401DQB10434', 'DQA10401DQB10504', 'DQA10401DQB105103', 'DQA10401DQB105117', 'DQA10401DQB10518', 'DQA10401DQB10523', 'DQA10401DQB10524', 'DQA10401DQB10528', 'DQA10401DQB10535', 'DQA10401DQB10537', 'DQA10401DQB10542', 'DQA10401DQB10546', 'DQA10401DQB10552', 'DQA10401DQB10583', 'DQA10401DQB10605', 'DQA10401DQB106108', 'DQA10401DQB106110', 'DQA10401DQB106123', 'DQA10401DQB106126', 'DQA10401DQB10613', 'DQA10401DQB106140', 'DQA10401DQB106153', 'DQA10401DQB10620', 'DQA10401DQB106214', 'DQA10401DQB10648', 'DQA10401DQB10652', 'DQA10402DQB10207', 'DQA10402DQB10212', 'DQA10402DQB10225', 'DQA10402DQB10230', 'DQA10402DQB10248', 'DQA10402DQB10271', 'DQA10402DQB10285', 'DQA10402DQB103104', 'DQA10402DQB103105', 'DQA10402DQB103108', 'DQA10402DQB103109', 'DQA10402DQB103113', 'DQA10402DQB103114', 'DQA10402DQB103119', 'DQA10402DQB103120', 'DQA10402DQB103121', 'DQA10402DQB103129', 'DQA10402DQB103131', 'DQA10402DQB103132', 'DQA10402DQB103133', 'DQA10402DQB103134', 'DQA10402DQB103135', 'DQA10402DQB103138', 'DQA10402DQB103139', 'DQA10402DQB103142', 'DQA10402DQB103147', 'DQA10402DQB103154', 'DQA10402DQB103157', 'DQA10402DQB103158', 'DQA10402DQB103163', 'DQA10402DQB103166', 'DQA10402DQB103167', 'DQA10402DQB103172', 'DQA10402DQB103180', 'DQA10402DQB103184', 'DQA10402DQB103185', 'DQA10402DQB103186', 'DQA10402DQB103188', 'DQA10402DQB103191', 'DQA10402DQB103194', 'DQA10402DQB103195', 'DQA10402DQB103196', 'DQA10402DQB103201', 'DQA10402DQB103207', 'DQA10402DQB103208', 'DQA10402DQB103231', 'DQA10402DQB103232', 'DQA10402DQB103235', 'DQA10402DQB103241', 'DQA10402DQB103242', 'DQA10402DQB103251', 'DQA10402DQB103254', 'DQA10402DQB103264', 'DQA10402DQB103265', 'DQA10402DQB10347', 'DQA10402DQB10352', 'DQA10402DQB10357', 'DQA10402DQB10362', 'DQA10402DQB10368', 'DQA10402DQB10369', 'DQA10402DQB10372', 'DQA10402DQB10375', 'DQA10402DQB10382', 'DQA10402DQB10387', 'DQA10402DQB10396', 'DQA10402DQB10422', 'DQA10402DQB10423', 'DQA10402DQB10434', 'DQA10402DQB10504', 'DQA10402DQB105103', 'DQA10402DQB105117', 'DQA10402DQB10518', 'DQA10402DQB10523', 'DQA10402DQB10524', 'DQA10402DQB10528', 'DQA10402DQB10535', 'DQA10402DQB10537', 'DQA10402DQB10542', 'DQA10402DQB10546', 'DQA10402DQB10552', 'DQA10402DQB10583', 'DQA10402DQB10605', 'DQA10402DQB106108', 'DQA10402DQB106110', 'DQA10402DQB106123', 'DQA10402DQB106126', 'DQA10402DQB10613', 'DQA10402DQB106140', 'DQA10402DQB106153', 'DQA10402DQB10620', 'DQA10402DQB106214', 'DQA10402DQB10648', 'DQA10402DQB10652', 'DQA10404DQB10207', 'DQA10404DQB10212', 'DQA10404DQB10225', 'DQA10404DQB10230', 'DQA10404DQB10248', 'DQA10404DQB10271', 'DQA10404DQB10285', 'DQA10404DQB103104', 'DQA10404DQB103105', 'DQA10404DQB103108', 'DQA10404DQB103109', 'DQA10404DQB103113', 'DQA10404DQB103114', 'DQA10404DQB103119', 'DQA10404DQB103120', 'DQA10404DQB103121', 'DQA10404DQB103129', 'DQA10404DQB103131', 'DQA10404DQB103132', 'DQA10404DQB103133', 'DQA10404DQB103134', 'DQA10404DQB103135', 'DQA10404DQB103138', 'DQA10404DQB103139', 'DQA10404DQB103142', 'DQA10404DQB103147', 'DQA10404DQB103154', 'DQA10404DQB103157', 'DQA10404DQB103158', 'DQA10404DQB103163', 'DQA10404DQB103166', 'DQA10404DQB103167', 'DQA10404DQB103172', 'DQA10404DQB103180', 'DQA10404DQB103184', 'DQA10404DQB103185', 'DQA10404DQB103186', 'DQA10404DQB103188', 'DQA10404DQB103191', 'DQA10404DQB103194', 'DQA10404DQB103195', 'DQA10404DQB103196', 'DQA10404DQB103201', 'DQA10404DQB103207', 'DQA10404DQB103208', 'DQA10404DQB103231', 'DQA10404DQB103232', 'DQA10404DQB103235', 'DQA10404DQB103241', 'DQA10404DQB103242', 'DQA10404DQB103251', 'DQA10404DQB103254', 'DQA10404DQB103264', 'DQA10404DQB103265', 'DQA10404DQB10347', 'DQA10404DQB10352', 'DQA10404DQB10357', 'DQA10404DQB10362', 'DQA10404DQB10368', 'DQA10404DQB10369', 'DQA10404DQB10372', 'DQA10404DQB10375', 'DQA10404DQB10382', 'DQA10404DQB10387', 'DQA10404DQB10396', 'DQA10404DQB10422', 'DQA10404DQB10423', 'DQA10404DQB10434', 'DQA10404DQB10504', 'DQA10404DQB105103', 'DQA10404DQB105117', 'DQA10404DQB10518', 'DQA10404DQB10523', 'DQA10404DQB10524', 'DQA10404DQB10528', 'DQA10404DQB10535', 'DQA10404DQB10537', 'DQA10404DQB10542', 'DQA10404DQB10546', 'DQA10404DQB10552', 'DQA10404DQB10583', 'DQA10404DQB10605', 'DQA10404DQB106108', 'DQA10404DQB106110', 'DQA10404DQB106123', 'DQA10404DQB106126', 'DQA10404DQB10613', 'DQA10404DQB106140', 'DQA10404DQB106153', 'DQA10404DQB10620', 'DQA10404DQB106214', 'DQA10404DQB10648', 'DQA10404DQB10652', 'DQA10501DQB10207', 'DQA10501DQB10212', 'DQA10501DQB10225', 'DQA10501DQB10230', 'DQA10501DQB10248', 'DQA10501DQB10271', 'DQA10501DQB10285', 'DQA10501DQB103104', 'DQA10501DQB103105', 'DQA10501DQB103108', 'DQA10501DQB103109', 'DQA10501DQB103113', 'DQA10501DQB103114', 'DQA10501DQB103119', 'DQA10501DQB103120', 'DQA10501DQB103121', 'DQA10501DQB103129', 'DQA10501DQB103131', 'DQA10501DQB103132', 'DQA10501DQB103133', 'DQA10501DQB103134', 'DQA10501DQB103135', 'DQA10501DQB103138', 'DQA10501DQB103139', 'DQA10501DQB103142', 'DQA10501DQB103147', 'DQA10501DQB103154', 'DQA10501DQB103157', 'DQA10501DQB103158', 'DQA10501DQB103163', 'DQA10501DQB103166', 'DQA10501DQB103167', 'DQA10501DQB103172', 'DQA10501DQB103180', 'DQA10501DQB103184', 'DQA10501DQB103185', 'DQA10501DQB103186', 'DQA10501DQB103188', 'DQA10501DQB103191', 'DQA10501DQB103194', 'DQA10501DQB103195', 'DQA10501DQB103196', 'DQA10501DQB103201', 'DQA10501DQB103207', 'DQA10501DQB103208', 'DQA10501DQB103231', 'DQA10501DQB103232', 'DQA10501DQB103235', 'DQA10501DQB103241', 'DQA10501DQB103242', 'DQA10501DQB103251', 'DQA10501DQB103254', 'DQA10501DQB103264', 'DQA10501DQB103265', 'DQA10501DQB10347', 'DQA10501DQB10352', 'DQA10501DQB10357', 'DQA10501DQB10362', 'DQA10501DQB10368', 'DQA10501DQB10369', 'DQA10501DQB10372', 'DQA10501DQB10375', 'DQA10501DQB10382', 'DQA10501DQB10387', 'DQA10501DQB10396', 'DQA10501DQB10422', 'DQA10501DQB10423', 'DQA10501DQB10434', 'DQA10501DQB10504', 'DQA10501DQB105103', 'DQA10501DQB105117', 'DQA10501DQB10518', 'DQA10501DQB10523', 'DQA10501DQB10524', 'DQA10501DQB10528', 'DQA10501DQB10535', 'DQA10501DQB10537', 'DQA10501DQB10542', 'DQA10501DQB10546', 'DQA10501DQB10552', 'DQA10501DQB10583', 'DQA10501DQB10605', 'DQA10501DQB106108', 'DQA10501DQB106110', 'DQA10501DQB106123', 'DQA10501DQB106126', 'DQA10501DQB10613', 'DQA10501DQB106140', 'DQA10501DQB106153', 'DQA10501DQB10620', 'DQA10501DQB106214', 'DQA10501DQB10648', 'DQA10501DQB10652', 'DQA10502DQB10201', 'DQA10502DQB10202', 'DQA10502DQB10203', 'DQA10502DQB10204', 'DQA10502DQB10205', 'DQA10502DQB10206', 'DQA10502DQB10207', 'DQA10502DQB10212', 'DQA10502DQB10225', 'DQA10502DQB10230', 'DQA10502DQB10248', 'DQA10502DQB10271', 'DQA10502DQB10285', 'DQA10502DQB10301', 'DQA10502DQB10302', 'DQA10502DQB10303', 'DQA10502DQB10304', 'DQA10502DQB10305', 'DQA10502DQB10306', 'DQA10502DQB10307', 'DQA10502DQB10308', 'DQA10502DQB10309', 'DQA10502DQB103104', 'DQA10502DQB103105', 'DQA10502DQB103108', 'DQA10502DQB103109', 'DQA10502DQB10310', 'DQA10502DQB103113', 'DQA10502DQB103114', 'DQA10502DQB103119', 'DQA10502DQB10311', 'DQA10502DQB103120', 'DQA10502DQB103121', 'DQA10502DQB103129', 'DQA10502DQB10312', 'DQA10502DQB103131', 'DQA10502DQB103132', 'DQA10502DQB103133', 'DQA10502DQB103134', 'DQA10502DQB103135', 'DQA10502DQB103138', 'DQA10502DQB103139', 'DQA10502DQB10313', 'DQA10502DQB103142', 'DQA10502DQB103147', 'DQA10502DQB10314', 'DQA10502DQB103154', 'DQA10502DQB103157', 'DQA10502DQB103158', 'DQA10502DQB10315', 'DQA10502DQB103163', 'DQA10502DQB103166', 'DQA10502DQB103167', 'DQA10502DQB10316', 'DQA10502DQB103172', 'DQA10502DQB10317', 'DQA10502DQB103180', 'DQA10502DQB103184', 'DQA10502DQB103185', 'DQA10502DQB103186', 'DQA10502DQB103188', 'DQA10502DQB10318', 'DQA10502DQB103191', 'DQA10502DQB103194', 'DQA10502DQB103195', 'DQA10502DQB103196', 'DQA10502DQB10319', 'DQA10502DQB103201', 'DQA10502DQB103207', 'DQA10502DQB103208', 'DQA10502DQB10320', 'DQA10502DQB10321', 'DQA10502DQB10322', 'DQA10502DQB103231', 'DQA10502DQB103232', 'DQA10502DQB103235', 'DQA10502DQB10323', 'DQA10502DQB103241', 'DQA10502DQB103242', 'DQA10502DQB10324', 'DQA10502DQB103251', 'DQA10502DQB103254', 'DQA10502DQB10325', 'DQA10502DQB103264', 'DQA10502DQB103265', 'DQA10502DQB10326', 'DQA10502DQB10327', 'DQA10502DQB10328', 'DQA10502DQB10329', 'DQA10502DQB10330', 'DQA10502DQB10331', 'DQA10502DQB10332', 'DQA10502DQB10333', 'DQA10502DQB10334', 'DQA10502DQB10335', 'DQA10502DQB10336', 'DQA10502DQB10337', 'DQA10502DQB10338', 'DQA10502DQB10347', 'DQA10502DQB10352', 'DQA10502DQB10357', 'DQA10502DQB10362', 'DQA10502DQB10368', 'DQA10502DQB10369', 'DQA10502DQB10372', 'DQA10502DQB10375', 'DQA10502DQB10382', 'DQA10502DQB10387', 'DQA10502DQB10396', 'DQA10502DQB10401', 'DQA10502DQB10402', 'DQA10502DQB10403', 'DQA10502DQB10404', 'DQA10502DQB10405', 'DQA10502DQB10406', 'DQA10502DQB10407', 'DQA10502DQB10408', 'DQA10502DQB10422', 'DQA10502DQB10423', 'DQA10502DQB10434', 'DQA10502DQB10501', 'DQA10502DQB10502', 'DQA10502DQB10503', 'DQA10502DQB10504', 'DQA10502DQB10505', 'DQA10502DQB10506', 'DQA10502DQB10507', 'DQA10502DQB10508', 'DQA10502DQB10509', 'DQA10502DQB105103', 'DQA10502DQB10510', 'DQA10502DQB105117', 'DQA10502DQB10511', 'DQA10502DQB10512', 'DQA10502DQB10513', 'DQA10502DQB10514', 'DQA10502DQB10518', 'DQA10502DQB10523', 'DQA10502DQB10524', 'DQA10502DQB10528', 'DQA10502DQB10535', 'DQA10502DQB10537', 'DQA10502DQB10542', 'DQA10502DQB10546', 'DQA10502DQB10552', 'DQA10502DQB10583', 'DQA10502DQB10601', 'DQA10502DQB10602', 'DQA10502DQB10603', 'DQA10502DQB10604', 'DQA10502DQB10605', 'DQA10502DQB10607', 'DQA10502DQB10608', 'DQA10502DQB10609', 'DQA10502DQB106108', 'DQA10502DQB10610', 'DQA10502DQB106110', 'DQA10502DQB10611', 'DQA10502DQB106123', 'DQA10502DQB106126', 'DQA10502DQB10612', 'DQA10502DQB10613', 'DQA10502DQB106140', 'DQA10502DQB10614', 'DQA10502DQB106153', 'DQA10502DQB10615', 'DQA10502DQB10616', 'DQA10502DQB10617', 'DQA10502DQB10618', 'DQA10502DQB10619', 'DQA10502DQB10620', 'DQA10502DQB106214', 'DQA10502DQB10621', 'DQA10502DQB10622', 'DQA10502DQB10623', 'DQA10502DQB10624', 'DQA10502DQB10625', 'DQA10502DQB10627', 'DQA10502DQB10628', 'DQA10502DQB10629', 'DQA10502DQB10630', 'DQA10502DQB10631', 'DQA10502DQB10632', 'DQA10502DQB10633', 'DQA10502DQB10634', 'DQA10502DQB10635', 'DQA10502DQB10636', 'DQA10502DQB10637', 'DQA10502DQB10638', 'DQA10502DQB10639', 'DQA10502DQB10640', 'DQA10502DQB10641', 'DQA10502DQB10642', 'DQA10502DQB10643', 'DQA10502DQB10644', 'DQA10502DQB10648', 'DQA10502DQB10652', 'DQA10503DQB10207', 'DQA10503DQB10212', 'DQA10503DQB10225', 'DQA10503DQB10230', 'DQA10503DQB10248', 'DQA10503DQB10271', 'DQA10503DQB10285', 'DQA10503DQB103104', 'DQA10503DQB103105', 'DQA10503DQB103108', 'DQA10503DQB103109', 'DQA10503DQB103113', 'DQA10503DQB103114', 'DQA10503DQB103119', 'DQA10503DQB103120', 'DQA10503DQB103121', 'DQA10503DQB103129', 'DQA10503DQB103131', 'DQA10503DQB103132', 'DQA10503DQB103133', 'DQA10503DQB103134', 'DQA10503DQB103135', 'DQA10503DQB103138', 'DQA10503DQB103139', 'DQA10503DQB103142', 'DQA10503DQB103147', 'DQA10503DQB103154', 'DQA10503DQB103157', 'DQA10503DQB103158', 'DQA10503DQB103163', 'DQA10503DQB103166', 'DQA10503DQB103167', 'DQA10503DQB103172', 'DQA10503DQB103180', 'DQA10503DQB103184', 'DQA10503DQB103185', 'DQA10503DQB103186', 'DQA10503DQB103188', 'DQA10503DQB103191', 'DQA10503DQB103194', 'DQA10503DQB103195', 'DQA10503DQB103196', 'DQA10503DQB103201', 'DQA10503DQB103207', 'DQA10503DQB103208', 'DQA10503DQB103231', 'DQA10503DQB103232', 'DQA10503DQB103235', 'DQA10503DQB103241', 'DQA10503DQB103242', 'DQA10503DQB103251', 'DQA10503DQB103254', 'DQA10503DQB103264', 'DQA10503DQB103265', 'DQA10503DQB10347', 'DQA10503DQB10352', 'DQA10503DQB10357', 'DQA10503DQB10362', 'DQA10503DQB10368', 'DQA10503DQB10369', 'DQA10503DQB10372', 'DQA10503DQB10375', 'DQA10503DQB10382', 'DQA10503DQB10387', 'DQA10503DQB10396', 'DQA10503DQB10422', 'DQA10503DQB10423', 'DQA10503DQB10434', 'DQA10503DQB10504', 'DQA10503DQB105103', 'DQA10503DQB105117', 'DQA10503DQB10518', 'DQA10503DQB10523', 'DQA10503DQB10524', 'DQA10503DQB10528', 'DQA10503DQB10535', 'DQA10503DQB10537', 'DQA10503DQB10542', 'DQA10503DQB10546', 'DQA10503DQB10552', 'DQA10503DQB10583', 'DQA10503DQB10605', 'DQA10503DQB106108', 'DQA10503DQB106110', 'DQA10503DQB106123', 'DQA10503DQB106126', 'DQA10503DQB10613', 'DQA10503DQB106140', 'DQA10503DQB106153', 'DQA10503DQB10620', 'DQA10503DQB106214', 'DQA10503DQB10648', 'DQA10503DQB10652', 'DQA10504DQB10207', 'DQA10504DQB10212', 'DQA10504DQB10225', 'DQA10504DQB10230', 'DQA10504DQB10248', 'DQA10504DQB10271', 'DQA10504DQB10285', 'DQA10504DQB103104', 'DQA10504DQB103105', 'DQA10504DQB103108', 'DQA10504DQB103109', 'DQA10504DQB103113', 'DQA10504DQB103114', 'DQA10504DQB103119', 'DQA10504DQB103120', 'DQA10504DQB103121', 'DQA10504DQB103129', 'DQA10504DQB103131', 'DQA10504DQB103132', 'DQA10504DQB103133', 'DQA10504DQB103134', 'DQA10504DQB103135', 'DQA10504DQB103138', 'DQA10504DQB103139', 'DQA10504DQB103142', 'DQA10504DQB103147', 'DQA10504DQB103154', 'DQA10504DQB103157', 'DQA10504DQB103158', 'DQA10504DQB103163', 'DQA10504DQB103166', 'DQA10504DQB103167', 'DQA10504DQB103172', 'DQA10504DQB103180', 'DQA10504DQB103184', 'DQA10504DQB103185', 'DQA10504DQB103186', 'DQA10504DQB103188', 'DQA10504DQB103191', 'DQA10504DQB103194', 'DQA10504DQB103195', 'DQA10504DQB103196', 'DQA10504DQB103201', 'DQA10504DQB103207', 'DQA10504DQB103208', 'DQA10504DQB103231', 'DQA10504DQB103232', 'DQA10504DQB103235', 'DQA10504DQB103241', 'DQA10504DQB103242', 'DQA10504DQB103251', 'DQA10504DQB103254', 'DQA10504DQB103264', 'DQA10504DQB103265', 'DQA10504DQB10347', 'DQA10504DQB10352', 'DQA10504DQB10357', 'DQA10504DQB10362', 'DQA10504DQB10368', 'DQA10504DQB10369', 'DQA10504DQB10372', 'DQA10504DQB10375', 'DQA10504DQB10382', 'DQA10504DQB10387', 'DQA10504DQB10396', 'DQA10504DQB10422', 'DQA10504DQB10423', 'DQA10504DQB10434', 'DQA10504DQB10504', 'DQA10504DQB105103', 'DQA10504DQB105117', 'DQA10504DQB10518', 'DQA10504DQB10523', 'DQA10504DQB10524', 'DQA10504DQB10528', 'DQA10504DQB10535', 'DQA10504DQB10537', 'DQA10504DQB10542', 'DQA10504DQB10546', 'DQA10504DQB10552', 'DQA10504DQB10583', 'DQA10504DQB10605', 'DQA10504DQB106108', 'DQA10504DQB106110', 'DQA10504DQB106123', 'DQA10504DQB106126', 'DQA10504DQB10613', 'DQA10504DQB106140', 'DQA10504DQB106153', 'DQA10504DQB10620', 'DQA10504DQB106214', 'DQA10504DQB10648', 'DQA10504DQB10652', 'DQA10505DQB10207', 'DQA10505DQB10212', 'DQA10505DQB10225', 'DQA10505DQB10230', 'DQA10505DQB10248', 'DQA10505DQB10271', 'DQA10505DQB10285', 'DQA10505DQB103104', 'DQA10505DQB103105', 'DQA10505DQB103108', 'DQA10505DQB103109', 'DQA10505DQB103113', 'DQA10505DQB103114', 'DQA10505DQB103119', 'DQA10505DQB103120', 'DQA10505DQB103121', 'DQA10505DQB103129', 'DQA10505DQB103131', 'DQA10505DQB103132', 'DQA10505DQB103133', 'DQA10505DQB103134', 'DQA10505DQB103135', 'DQA10505DQB103138', 'DQA10505DQB103139', 'DQA10505DQB103142', 'DQA10505DQB103147', 'DQA10505DQB103154', 'DQA10505DQB103157', 'DQA10505DQB103158', 'DQA10505DQB103163', 'DQA10505DQB103166', 'DQA10505DQB103167', 'DQA10505DQB103172', 'DQA10505DQB103180', 'DQA10505DQB103184', 'DQA10505DQB103185', 'DQA10505DQB103186', 'DQA10505DQB103188', 'DQA10505DQB103191', 'DQA10505DQB103194', 'DQA10505DQB103195', 'DQA10505DQB103196', 'DQA10505DQB103201', 'DQA10505DQB103207', 'DQA10505DQB103208', 'DQA10505DQB103231', 'DQA10505DQB103232', 'DQA10505DQB103235', 'DQA10505DQB103241', 'DQA10505DQB103242', 'DQA10505DQB103251', 'DQA10505DQB103254', 'DQA10505DQB103264', 'DQA10505DQB103265', 'DQA10505DQB10347', 'DQA10505DQB10352', 'DQA10505DQB10357', 'DQA10505DQB10362', 'DQA10505DQB10368', 'DQA10505DQB10369', 'DQA10505DQB10372', 'DQA10505DQB10375', 'DQA10505DQB10382', 'DQA10505DQB10387', 'DQA10505DQB10396', 'DQA10505DQB10422', 'DQA10505DQB10423', 'DQA10505DQB10434', 'DQA10505DQB10504', 'DQA10505DQB105103', 'DQA10505DQB105117', 'DQA10505DQB10518', 'DQA10505DQB10523', 'DQA10505DQB10524', 'DQA10505DQB10528', 'DQA10505DQB10535', 'DQA10505DQB10537', 'DQA10505DQB10542', 'DQA10505DQB10546', 'DQA10505DQB10552', 'DQA10505DQB10583', 'DQA10505DQB10605', 'DQA10505DQB106108', 'DQA10505DQB106110', 'DQA10505DQB106123', 'DQA10505DQB106126', 'DQA10505DQB10613', 'DQA10505DQB106140', 'DQA10505DQB106153', 'DQA10505DQB10620', 'DQA10505DQB106214', 'DQA10505DQB10648', 'DQA10505DQB10652', 'DQA10506DQB10207', 'DQA10506DQB10212', 'DQA10506DQB10225', 'DQA10506DQB10230', 'DQA10506DQB10248', 'DQA10506DQB10271', 'DQA10506DQB10285', 'DQA10506DQB103104', 'DQA10506DQB103105', 'DQA10506DQB103108', 'DQA10506DQB103109', 'DQA10506DQB103113', 'DQA10506DQB103114', 'DQA10506DQB103119', 'DQA10506DQB103120', 'DQA10506DQB103121', 'DQA10506DQB103129', 'DQA10506DQB103131', 'DQA10506DQB103132', 'DQA10506DQB103133', 'DQA10506DQB103134', 'DQA10506DQB103135', 'DQA10506DQB103138', 'DQA10506DQB103139', 'DQA10506DQB103142', 'DQA10506DQB103147', 'DQA10506DQB103154', 'DQA10506DQB103157', 'DQA10506DQB103158', 'DQA10506DQB103163', 'DQA10506DQB103166', 'DQA10506DQB103167', 'DQA10506DQB103172', 'DQA10506DQB103180', 'DQA10506DQB103184', 'DQA10506DQB103185', 'DQA10506DQB103186', 'DQA10506DQB103188', 'DQA10506DQB103191', 'DQA10506DQB103194', 'DQA10506DQB103195', 'DQA10506DQB103196', 'DQA10506DQB103201', 'DQA10506DQB103207', 'DQA10506DQB103208', 'DQA10506DQB103231', 'DQA10506DQB103232', 'DQA10506DQB103235', 'DQA10506DQB103241', 'DQA10506DQB103242', 'DQA10506DQB103251', 'DQA10506DQB103254', 'DQA10506DQB103264', 'DQA10506DQB103265', 'DQA10506DQB10347', 'DQA10506DQB10352', 'DQA10506DQB10357', 'DQA10506DQB10362', 'DQA10506DQB10368', 'DQA10506DQB10369', 'DQA10506DQB10372', 'DQA10506DQB10375', 'DQA10506DQB10382', 'DQA10506DQB10387', 'DQA10506DQB10396', 'DQA10506DQB10422', 'DQA10506DQB10423', 'DQA10506DQB10434', 'DQA10506DQB10504', 'DQA10506DQB105103', 'DQA10506DQB105117', 'DQA10506DQB10518', 'DQA10506DQB10523', 'DQA10506DQB10524', 'DQA10506DQB10528', 'DQA10506DQB10535', 'DQA10506DQB10537', 'DQA10506DQB10542', 'DQA10506DQB10546', 'DQA10506DQB10552', 'DQA10506DQB10583', 'DQA10506DQB10605', 'DQA10506DQB106108', 'DQA10506DQB106110', 'DQA10506DQB106123', 'DQA10506DQB106126', 'DQA10506DQB10613', 'DQA10506DQB106140', 'DQA10506DQB106153', 'DQA10506DQB10620', 'DQA10506DQB106214', 'DQA10506DQB10648', 'DQA10506DQB10652', 'DQA10507DQB10207', 'DQA10507DQB10212', 'DQA10507DQB10225', 'DQA10507DQB10230', 'DQA10507DQB10248', 'DQA10507DQB10271', 'DQA10507DQB10285', 'DQA10507DQB103104', 'DQA10507DQB103105', 'DQA10507DQB103108', 'DQA10507DQB103109', 'DQA10507DQB103113', 'DQA10507DQB103114', 'DQA10507DQB103119', 'DQA10507DQB103120', 'DQA10507DQB103121', 'DQA10507DQB103129', 'DQA10507DQB103131', 'DQA10507DQB103132', 'DQA10507DQB103133', 'DQA10507DQB103134', 'DQA10507DQB103135', 'DQA10507DQB103138', 'DQA10507DQB103139', 'DQA10507DQB103142', 'DQA10507DQB103147', 'DQA10507DQB103154', 'DQA10507DQB103157', 'DQA10507DQB103158', 'DQA10507DQB103163', 'DQA10507DQB103166', 'DQA10507DQB103167', 'DQA10507DQB103172', 'DQA10507DQB103180', 'DQA10507DQB103184', 'DQA10507DQB103185', 'DQA10507DQB103186', 'DQA10507DQB103188', 'DQA10507DQB103191', 'DQA10507DQB103194', 'DQA10507DQB103195', 'DQA10507DQB103196', 'DQA10507DQB103201', 'DQA10507DQB103207', 'DQA10507DQB103208', 'DQA10507DQB103231', 'DQA10507DQB103232', 'DQA10507DQB103235', 'DQA10507DQB103241', 'DQA10507DQB103242', 'DQA10507DQB103251', 'DQA10507DQB103254', 'DQA10507DQB103264', 'DQA10507DQB103265', 'DQA10507DQB10347', 'DQA10507DQB10352', 'DQA10507DQB10357', 'DQA10507DQB10362', 'DQA10507DQB10368', 'DQA10507DQB10369', 'DQA10507DQB10372', 'DQA10507DQB10375', 'DQA10507DQB10382', 'DQA10507DQB10387', 'DQA10507DQB10396', 'DQA10507DQB10422', 'DQA10507DQB10423', 'DQA10507DQB10434', 'DQA10507DQB10504', 'DQA10507DQB105103', 'DQA10507DQB105117', 'DQA10507DQB10518', 'DQA10507DQB10523', 'DQA10507DQB10524', 'DQA10507DQB10528', 'DQA10507DQB10535', 'DQA10507DQB10537', 'DQA10507DQB10542', 'DQA10507DQB10546', 'DQA10507DQB10552', 'DQA10507DQB10583', 'DQA10507DQB10605', 'DQA10507DQB106108', 'DQA10507DQB106110', 'DQA10507DQB106123', 'DQA10507DQB106126', 'DQA10507DQB10613', 'DQA10507DQB106140', 'DQA10507DQB106153', 'DQA10507DQB10620', 'DQA10507DQB106214', 'DQA10507DQB10648', 'DQA10507DQB10652', 'DQA10508DQB10207', 'DQA10508DQB10212', 'DQA10508DQB10225', 'DQA10508DQB10230', 'DQA10508DQB10248', 'DQA10508DQB10271', 'DQA10508DQB10285', 'DQA10508DQB103104', 'DQA10508DQB103105', 'DQA10508DQB103108', 'DQA10508DQB103109', 'DQA10508DQB103113', 'DQA10508DQB103114', 'DQA10508DQB103119', 'DQA10508DQB103120', 'DQA10508DQB103121', 'DQA10508DQB103129', 'DQA10508DQB103131', 'DQA10508DQB103132', 'DQA10508DQB103133', 'DQA10508DQB103134', 'DQA10508DQB103135', 'DQA10508DQB103138', 'DQA10508DQB103139', 'DQA10508DQB103142', 'DQA10508DQB103147', 'DQA10508DQB103154', 'DQA10508DQB103157', 'DQA10508DQB103158', 'DQA10508DQB103163', 'DQA10508DQB103166', 'DQA10508DQB103167', 'DQA10508DQB103172', 'DQA10508DQB103180', 'DQA10508DQB103184', 'DQA10508DQB103185', 'DQA10508DQB103186', 'DQA10508DQB103188', 'DQA10508DQB103191', 'DQA10508DQB103194', 'DQA10508DQB103195', 'DQA10508DQB103196', 'DQA10508DQB103201', 'DQA10508DQB103207', 'DQA10508DQB103208', 'DQA10508DQB103231', 'DQA10508DQB103232', 'DQA10508DQB103235', 'DQA10508DQB103241', 'DQA10508DQB103242', 'DQA10508DQB103251', 'DQA10508DQB103254', 'DQA10508DQB103264', 'DQA10508DQB103265', 'DQA10508DQB10347', 'DQA10508DQB10352', 'DQA10508DQB10357', 'DQA10508DQB10362', 'DQA10508DQB10368', 'DQA10508DQB10369', 'DQA10508DQB10372', 'DQA10508DQB10375', 'DQA10508DQB10382', 'DQA10508DQB10387', 'DQA10508DQB10396', 'DQA10508DQB10422', 'DQA10508DQB10423', 'DQA10508DQB10434', 'DQA10508DQB10504', 'DQA10508DQB105103', 'DQA10508DQB105117', 'DQA10508DQB10518', 'DQA10508DQB10523', 'DQA10508DQB10524', 'DQA10508DQB10528', 'DQA10508DQB10535', 'DQA10508DQB10537', 'DQA10508DQB10542', 'DQA10508DQB10546', 'DQA10508DQB10552', 'DQA10508DQB10583', 'DQA10508DQB10605', 'DQA10508DQB106108', 'DQA10508DQB106110', 'DQA10508DQB106123', 'DQA10508DQB106126', 'DQA10508DQB10613', 'DQA10508DQB106140', 'DQA10508DQB106153', 'DQA10508DQB10620', 'DQA10508DQB106214', 'DQA10508DQB10648', 'DQA10508DQB10652', 'DQA10509DQB10207', 'DQA10509DQB10212', 'DQA10509DQB10225', 'DQA10509DQB10230', 'DQA10509DQB10248', 'DQA10509DQB10271', 'DQA10509DQB10285', 'DQA10509DQB103104', 'DQA10509DQB103105', 'DQA10509DQB103108', 'DQA10509DQB103109', 'DQA10509DQB103113', 'DQA10509DQB103114', 'DQA10509DQB103119', 'DQA10509DQB103120', 'DQA10509DQB103121', 'DQA10509DQB103129', 'DQA10509DQB103131', 'DQA10509DQB103132', 'DQA10509DQB103133', 'DQA10509DQB103134', 'DQA10509DQB103135', 'DQA10509DQB103138', 'DQA10509DQB103139', 'DQA10509DQB103142', 'DQA10509DQB103147', 'DQA10509DQB103154', 'DQA10509DQB103157', 'DQA10509DQB103158', 'DQA10509DQB103163', 'DQA10509DQB103166', 'DQA10509DQB103167', 'DQA10509DQB103172', 'DQA10509DQB103180', 'DQA10509DQB103184', 'DQA10509DQB103185', 'DQA10509DQB103186', 'DQA10509DQB103188', 'DQA10509DQB103191', 'DQA10509DQB103194', 'DQA10509DQB103195', 'DQA10509DQB103196', 'DQA10509DQB103201', 'DQA10509DQB103207', 'DQA10509DQB103208', 'DQA10509DQB103231', 'DQA10509DQB103232', 'DQA10509DQB103235', 'DQA10509DQB103241', 'DQA10509DQB103242', 'DQA10509DQB103251', 'DQA10509DQB103254', 'DQA10509DQB103264', 'DQA10509DQB103265', 'DQA10509DQB10347', 'DQA10509DQB10352', 'DQA10509DQB10357', 'DQA10509DQB10362', 'DQA10509DQB10368', 'DQA10509DQB10369', 'DQA10509DQB10372', 'DQA10509DQB10375', 'DQA10509DQB10382', 'DQA10509DQB10387', 'DQA10509DQB10396', 'DQA10509DQB10422', 'DQA10509DQB10423', 'DQA10509DQB10434', 'DQA10509DQB10504', 'DQA10509DQB105103', 'DQA10509DQB105117', 'DQA10509DQB10518', 'DQA10509DQB10523', 'DQA10509DQB10524', 'DQA10509DQB10528', 'DQA10509DQB10535', 'DQA10509DQB10537', 'DQA10509DQB10542', 'DQA10509DQB10546', 'DQA10509DQB10552', 'DQA10509DQB10583', 'DQA10509DQB10605', 'DQA10509DQB106108', 'DQA10509DQB106110', 'DQA10509DQB106123', 'DQA10509DQB106126', 'DQA10509DQB10613', 'DQA10509DQB106140', 'DQA10509DQB106153', 'DQA10509DQB10620', 'DQA10509DQB106214', 'DQA10509DQB10648', 'DQA10509DQB10652', 'DQA10510DQB10207', 'DQA10510DQB10212', 'DQA10510DQB10225', 'DQA10510DQB10230', 'DQA10510DQB10248', 'DQA10510DQB10271', 'DQA10510DQB10285', 'DQA10510DQB103104', 'DQA10510DQB103105', 'DQA10510DQB103108', 'DQA10510DQB103109', 'DQA10510DQB103113', 'DQA10510DQB103114', 'DQA10510DQB103119', 'DQA10510DQB103120', 'DQA10510DQB103121', 'DQA10510DQB103129', 'DQA10510DQB103131', 'DQA10510DQB103132', 'DQA10510DQB103133', 'DQA10510DQB103134', 'DQA10510DQB103135', 'DQA10510DQB103138', 'DQA10510DQB103139', 'DQA10510DQB103142', 'DQA10510DQB103147', 'DQA10510DQB103154', 'DQA10510DQB103157', 'DQA10510DQB103158', 'DQA10510DQB103163', 'DQA10510DQB103166', 'DQA10510DQB103167', 'DQA10510DQB103172', 'DQA10510DQB103180', 'DQA10510DQB103184', 'DQA10510DQB103185', 'DQA10510DQB103186', 'DQA10510DQB103188', 'DQA10510DQB103191', 'DQA10510DQB103194', 'DQA10510DQB103195', 'DQA10510DQB103196', 'DQA10510DQB103201', 'DQA10510DQB103207', 'DQA10510DQB103208', 'DQA10510DQB103231', 'DQA10510DQB103232', 'DQA10510DQB103235', 'DQA10510DQB103241', 'DQA10510DQB103242', 'DQA10510DQB103251', 'DQA10510DQB103254', 'DQA10510DQB103264', 'DQA10510DQB103265', 'DQA10510DQB10347', 'DQA10510DQB10352', 'DQA10510DQB10357', 'DQA10510DQB10362', 'DQA10510DQB10368', 'DQA10510DQB10369', 'DQA10510DQB10372', 'DQA10510DQB10375', 'DQA10510DQB10382', 'DQA10510DQB10387', 'DQA10510DQB10396', 'DQA10510DQB10422', 'DQA10510DQB10423', 'DQA10510DQB10434', 'DQA10510DQB10504', 'DQA10510DQB105103', 'DQA10510DQB105117', 'DQA10510DQB10518', 'DQA10510DQB10523', 'DQA10510DQB10524', 'DQA10510DQB10528', 'DQA10510DQB10535', 'DQA10510DQB10537', 'DQA10510DQB10542', 'DQA10510DQB10546', 'DQA10510DQB10552', 'DQA10510DQB10583', 'DQA10510DQB10605', 'DQA10510DQB106108', 'DQA10510DQB106110', 'DQA10510DQB106123', 'DQA10510DQB106126', 'DQA10510DQB10613', 'DQA10510DQB106140', 'DQA10510DQB106153', 'DQA10510DQB10620', 'DQA10510DQB106214', 'DQA10510DQB10648', 'DQA10510DQB10652', 'DQA10511DQB10207', 'DQA10511DQB10212', 'DQA10511DQB10225', 'DQA10511DQB10230', 'DQA10511DQB10248', 'DQA10511DQB10271', 'DQA10511DQB10285', 'DQA10511DQB103104', 'DQA10511DQB103105', 'DQA10511DQB103108', 'DQA10511DQB103109', 'DQA10511DQB103113', 'DQA10511DQB103114', 'DQA10511DQB103119', 'DQA10511DQB103120', 'DQA10511DQB103121', 'DQA10511DQB103129', 'DQA10511DQB103131', 'DQA10511DQB103132', 'DQA10511DQB103133', 'DQA10511DQB103134', 'DQA10511DQB103135', 'DQA10511DQB103138', 'DQA10511DQB103139', 'DQA10511DQB103142', 'DQA10511DQB103147', 'DQA10511DQB103154', 'DQA10511DQB103157', 'DQA10511DQB103158', 'DQA10511DQB103163', 'DQA10511DQB103166', 'DQA10511DQB103167', 'DQA10511DQB103172', 'DQA10511DQB103180', 'DQA10511DQB103184', 'DQA10511DQB103185', 'DQA10511DQB103186', 'DQA10511DQB103188', 'DQA10511DQB103191', 'DQA10511DQB103194', 'DQA10511DQB103195', 'DQA10511DQB103196', 'DQA10511DQB103201', 'DQA10511DQB103207', 'DQA10511DQB103208', 'DQA10511DQB103231', 'DQA10511DQB103232', 'DQA10511DQB103235', 'DQA10511DQB103241', 'DQA10511DQB103242', 'DQA10511DQB103251', 'DQA10511DQB103254', 'DQA10511DQB103264', 'DQA10511DQB103265', 'DQA10511DQB10347', 'DQA10511DQB10352', 'DQA10511DQB10357', 'DQA10511DQB10362', 'DQA10511DQB10368', 'DQA10511DQB10369', 'DQA10511DQB10372', 'DQA10511DQB10375', 'DQA10511DQB10382', 'DQA10511DQB10387', 'DQA10511DQB10396', 'DQA10511DQB10422', 'DQA10511DQB10423', 'DQA10511DQB10434', 'DQA10511DQB10504', 'DQA10511DQB105103', 'DQA10511DQB105117', 'DQA10511DQB10518', 'DQA10511DQB10523', 'DQA10511DQB10524', 'DQA10511DQB10528', 'DQA10511DQB10535', 'DQA10511DQB10537', 'DQA10511DQB10542', 'DQA10511DQB10546', 'DQA10511DQB10552', 'DQA10511DQB10583', 'DQA10511DQB10605', 'DQA10511DQB106108', 'DQA10511DQB106110', 'DQA10511DQB106123', 'DQA10511DQB106126', 'DQA10511DQB10613', 'DQA10511DQB106140', 'DQA10511DQB106153', 'DQA10511DQB10620', 'DQA10511DQB106214', 'DQA10511DQB10648', 'DQA10511DQB10652', 'DQA10601DQB10207', 'DQA10601DQB10212', 'DQA10601DQB10225', 'DQA10601DQB10230', 'DQA10601DQB10248', 'DQA10601DQB10271', 'DQA10601DQB10285', 'DQA10601DQB103104', 'DQA10601DQB103105', 'DQA10601DQB103108', 'DQA10601DQB103109', 'DQA10601DQB103113', 'DQA10601DQB103114', 'DQA10601DQB103119', 'DQA10601DQB103120', 'DQA10601DQB103121', 'DQA10601DQB103129', 'DQA10601DQB103131', 'DQA10601DQB103132', 'DQA10601DQB103133', 'DQA10601DQB103134', 'DQA10601DQB103135', 'DQA10601DQB103138', 'DQA10601DQB103139', 'DQA10601DQB103142', 'DQA10601DQB103147', 'DQA10601DQB103154', 'DQA10601DQB103157', 'DQA10601DQB103158', 'DQA10601DQB103163', 'DQA10601DQB103166', 'DQA10601DQB103167', 'DQA10601DQB103172', 'DQA10601DQB103180', 'DQA10601DQB103184', 'DQA10601DQB103185', 'DQA10601DQB103186', 'DQA10601DQB103188', 'DQA10601DQB103191', 'DQA10601DQB103194', 'DQA10601DQB103195', 'DQA10601DQB103196', 'DQA10601DQB103201', 'DQA10601DQB103207', 'DQA10601DQB103208', 'DQA10601DQB103231', 'DQA10601DQB103232', 'DQA10601DQB103235', 'DQA10601DQB103241', 'DQA10601DQB103242', 'DQA10601DQB103251', 'DQA10601DQB103254', 'DQA10601DQB103264', 'DQA10601DQB103265', 'DQA10601DQB10347', 'DQA10601DQB10352', 'DQA10601DQB10357', 'DQA10601DQB10362', 'DQA10601DQB10368', 'DQA10601DQB10369', 'DQA10601DQB10372', 'DQA10601DQB10375', 'DQA10601DQB10382', 'DQA10601DQB10387', 'DQA10601DQB10396', 'DQA10601DQB10422', 'DQA10601DQB10423', 'DQA10601DQB10434', 'DQA10601DQB10504', 'DQA10601DQB105103', 'DQA10601DQB105117', 'DQA10601DQB10518', 'DQA10601DQB10523', 'DQA10601DQB10524', 'DQA10601DQB10528', 'DQA10601DQB10535', 'DQA10601DQB10537', 'DQA10601DQB10542', 'DQA10601DQB10546', 'DQA10601DQB10552', 'DQA10601DQB10583', 'DQA10601DQB10605', 'DQA10601DQB106108', 'DQA10601DQB106110', 'DQA10601DQB106123', 'DQA10601DQB106126', 'DQA10601DQB10613', 'DQA10601DQB106140', 'DQA10601DQB106153', 'DQA10601DQB10620', 'DQA10601DQB106214', 'DQA10601DQB10648', 'DQA10601DQB10652', 'DQA10602DQB10207', 'DQA10602DQB10212', 'DQA10602DQB10225', 'DQA10602DQB10230', 'DQA10602DQB10248', 'DQA10602DQB10271', 'DQA10602DQB10285', 'DQA10602DQB103104', 'DQA10602DQB103105', 'DQA10602DQB103108', 'DQA10602DQB103109', 'DQA10602DQB103113', 'DQA10602DQB103114', 'DQA10602DQB103119', 'DQA10602DQB103120', 'DQA10602DQB103121', 'DQA10602DQB103129', 'DQA10602DQB103131', 'DQA10602DQB103132', 'DQA10602DQB103133', 'DQA10602DQB103134', 'DQA10602DQB103135', 'DQA10602DQB103138', 'DQA10602DQB103139', 'DQA10602DQB103142', 'DQA10602DQB103147', 'DQA10602DQB103154', 'DQA10602DQB103157', 'DQA10602DQB103158', 'DQA10602DQB103163', 'DQA10602DQB103166', 'DQA10602DQB103167', 'DQA10602DQB103172', 'DQA10602DQB103180', 'DQA10602DQB103184', 'DQA10602DQB103185', 'DQA10602DQB103186', 'DQA10602DQB103188', 'DQA10602DQB103191', 'DQA10602DQB103194', 'DQA10602DQB103195', 'DQA10602DQB103196', 'DQA10602DQB103201', 'DQA10602DQB103207', 'DQA10602DQB103208', 'DQA10602DQB103231', 'DQA10602DQB103232', 'DQA10602DQB103235', 'DQA10602DQB103241', 'DQA10602DQB103242', 'DQA10602DQB103251', 'DQA10602DQB103254', 'DQA10602DQB103264', 'DQA10602DQB103265', 'DQA10602DQB10347', 'DQA10602DQB10352', 'DQA10602DQB10357', 'DQA10602DQB10362', 'DQA10602DQB10368', 'DQA10602DQB10369', 'DQA10602DQB10372', 'DQA10602DQB10375', 'DQA10602DQB10382', 'DQA10602DQB10387', 'DQA10602DQB10396', 'DQA10602DQB10422', 'DQA10602DQB10423', 'DQA10602DQB10434', 'DQA10602DQB10504', 'DQA10602DQB105103', 'DQA10602DQB105117', 'DQA10602DQB10518', 'DQA10602DQB10523', 'DQA10602DQB10524', 'DQA10602DQB10528', 'DQA10602DQB10535', 'DQA10602DQB10537', 'DQA10602DQB10542', 'DQA10602DQB10546', 'DQA10602DQB10552', 'DQA10602DQB10583', 'DQA10602DQB10605', 'DQA10602DQB106108', 'DQA10602DQB106110', 'DQA10602DQB106123', 'DQA10602DQB106126', 'DQA10602DQB10613', 'DQA10602DQB106140', 'DQA10602DQB106153', 'DQA10602DQB10620', 'DQA10602DQB106214', 'DQA10602DQB10648', 'DQA10602DQB10652']
    print(len(alleles_to_add))

    OUTPUT_FILE=DATA_DIR + '/netmhciipan-4.2/alleles_to_add.txt'
    with open(OUTPUT_FILE, 'w') as f:
        # These alleles are already stripped
        for allele in alleles_to_add:
            if allele in alleles_dict:
                f.write(alleles_dict[allele] + '\n')

def test_alleles():
     tool_label = 'DQA10506-DQB103158'
     result = single_prediction(['ASSASSSSAAAAAAAT'], [(tool_label, 16)])
     print(result)

if __name__=='__main__':
    # main()

    # check_allelelist()

    # add_alleles()

    test_alleles()