import pandas as pd
from pathlib import Path
DATA_DIR = str(Path(__file__).parent) + "/data"


def pickle_autocomplete_datasource():
    AUTOCOMPLETE_DATAFILE = "{}/allele_datasource.tsv".format(DATA_DIR)

    # Read over the TSV file
    autocomp_df = pd.read_csv(AUTOCOMPLETE_DATAFILE, skipinitialspace=True, sep='\t', encoding='utf-8')
    
    # Write to feather file
    autocomp_df.to_feather('pickles/autocomp_data_info.feather')

    print("Finished pickling allele_datasource.tsv...")


def pickle_molecule():
    MOLECULE_FILE = "{}/mhc_alleles.tsv".format(DATA_DIR)
    
    # Read over the TSV file
    molecule_df = pd.read_csv(MOLECULE_FILE, skipinitialspace=True, sep='\t', encoding='utf-8')

    # Write to feather file
    molecule_df.to_feather('pickles/molecule_info.feather')

    print("Finished pickling mhc_alleles.tsv...")

def pickle_tools_mapping():
    MAPPED_MRO_FILE = "{}/tools-mapping.tsv".format(DATA_DIR)
    # HEADER = ["Tools Type",	"Method", "Tools Label", "MRO ID", "IEDB Label", "Lengths"]

    # Read over the TSV file
    # mapped_mro_df = pd.read_csv(MAPPED_MRO_FILE, skipinitialspace=True, usecols=HEADER, sep='\t', encoding='utf-8')
    mapped_mro_df = pd.read_csv(MAPPED_MRO_FILE, skipinitialspace=True, sep='\t', encoding='utf-8')
    
    # Write to feather file
    mapped_mro_df.to_feather('pickles/tools_mapping_info.feather')

    print("Finished pickling tools-mapping.tsv...")


if __name__ == '__main__' :
    pickle_tools_mapping()
    pickle_molecule()
    pickle_autocomplete_datasource()