import unittest
import pandas as pd
import os
from pathlib import Path
from netmhciipan_4_1_executable import single_prediction
SKIP_NETMHCIIPAN_CI = eval(os.getenv('SKIP_NETMHCIIPAN_CI', "False"))

@unittest.skipIf(SKIP_NETMHCIIPAN_CI, "CI Can't seem to find location of netmhciipan_4_1_executable")
class NetMHCIIpan41ExecutableTest(unittest.TestCase):
    NUM_SAMPLES = 50
    PROJECT_DIR = str(Path(__file__).parent.parent)
    DATA_DIR = PROJECT_DIR + '/data'
    TEST_DIR = PROJECT_DIR + '/tests'

    '''test cases for netmhciipan 4.1 and netmhciipan_el 4.1'''
    def test_base_case(self):
        TM_FILE = self.DATA_DIR + '/tools-mapping.tsv'

        tm_df = pd.read_csv(TM_FILE, sep='\t', index_col=False)
        alleles_df = tm_df[(tm_df['Tool']=='netmhciipan') & (tm_df['Tool Version']==4.1)]

        # Randomly select 50 rows from the dataframe
        random_sample_df = alleles_df.sample(n=self.NUM_SAMPLES)

        for row in random_sample_df.itertuples():
            # Edge case: Skip if DPA, DPB or DQA, DQB alleles are single alleles and not paired
            if row._4.startswith('DQB') or row._4.startswith('DPB'): continue
            if row._4.startswith('DQA') or row._4.startswith('DPA'): 
                split_names = row._4.split('/')
                if len(split_names) == 1 : continue

            # Columns: Tool Group, Tool, Tool Version, Tool Label, MRO ID, Lengths
            tool_label = row._4.replace("/","-")  
            result = single_prediction(['ASSASSSSAAAAAAAT'], [(tool_label, 16)])

            if not result:
                raise ValueError(f"Tool Label ({tool_label}) is not compatible with netmhciipan-4.1 method.")

if __name__=='__main__':
    unittest.main()