#! /usr/bin/env python3

import os
import sys

# adding all packages in method folder to the python path
script_dir = os.path.dirname(os.path.realpath(__file__))
root_dir = os.path.join(script_dir, '..')
sys.path.insert(1, root_dir)
import paths

tc1_path = paths.tcell_class_i_path
tc2_path = paths.tcell_class_ii_path
pepx_db_path = paths.pepx_db_path
icerfire_python_path = paths.icerfire_python_path
icerfire_python_module = paths.icerfire_python_module
icerfire_python_lib_path = paths.icerfire_python_lib_path

print(f'Searching for TC1 tool under: {tc1_path}')
if not os.path.exists(tc1_path):
    print(f'Error: path not found ({tc1_path})')
    print('Please provide a valid path to the TC1 standalone tool and reconfigure')
    sys.exit(1)
   
# now validate the the tcell_mhci.py file is found
tc1_full_path = os.path.join(tc1_path, 'src', 'tcell_mhci.py')
tc2_full_path = os.path.join(tc2_path, 'src', 'tcell_mhcii.py')
netmhcpan_path = os.path.join(tc1_path, 'method', 'netmhcpan-4.1-executable', 'netmhcpan_4_1_executable', 'netMHCpan')
nxg_tools_path = os.path.join(tc1_path, 'method', 'nxg-tools')

print(f'Searching for tcell_mhci.py script at: {tc1_full_path}')
if not os.path.exists(tc1_full_path):
    print(f'Error: tcell_mhci.py script not found in expected location ({tc1_full_path})')
    print('Please provide a valid path to the TC1 standalone tool and reconfigure')
    sys.exit(1)

print(f'Searching for tcell_mhcii.py script at: {tc2_full_path}')
if not os.path.exists(tc2_full_path):
    print(f'Error: tcell_mhcii.py script not found in expected location ({tc2_full_path})')
    print('Please provide a valid path to the TC2 standalone tool and reconfigure')
    sys.exit(1)

print(f'Searching for netMHCpan script at: {netmhcpan_path}')
if not os.path.exists(netmhcpan_path):
    print(f'Error: netMHCpan script not found in expected location ({netmhcpan_path})')
    print('Please provide a valid path to the netMHCpan tool and reconfigure')
    sys.exit(1)

if pepx_db_path:
    print(f'Searching for PepX Database at: {pepx_db_path}')
    if not os.path.exists(pepx_db_path):
        print(f'Error: PepX Database not found in expected location ({pepx_db_path})')
        print('Please provide a valid path to the PepX Database file and reconfigure')

if icerfire_python_path:
    if not os.path.exists(icerfire_python_path):
        print(f'Error: ICERFIRE python path not found in expected location ({icerfire_python_path})')
        print('Please provide a valid path to the python binary to be used with ICERFIRE and reconfigure')

if icerfire_python_lib_path:
    if not os.path.exists(icerfire_python_lib_path):
        print(f'Error: ICERFIRE python lib path not found in expected location ({icerfire_python_lib_path})')
        print('Please provide a valid path to the python library path to be used with ICERFIRE and reconfigure')

# now print that path into a file
path_config_file = os.path.join(script_dir, 'path_config.py')
with open(path_config_file, "w") as f:
    print(f'TC1_EXECUTABLE_PATH="{tc1_full_path}"', file=f)
    print(f'TC2_EXECUTABLE_PATH="{tc2_full_path}"', file=f)
    print(f'NETMHCPANPATH="{netmhcpan_path}"', file=f)
    print(f'NXG_TOOLS_PATH="{nxg_tools_path}"', file=f)
    if pepx_db_path:
        print(f'PEPXDBPATH="{pepx_db_path}"', file=f)
    if icerfire_python_path:
        print(f'ICERFIRE_PYTHON="{icerfire_python_path}"', file=f)
    if icerfire_python_module:
        print(f'ICERFIRE_PYTHON_MODULE="{icerfire_python_module}"', file=f)
    if icerfire_python_lib_path:
        print(f'ICERFIRE_LD_LIBRARY_PATH="{icerfire_python_lib_path}"', file=f)

print("Configuration complete!")
