import sys 
import unittest
from pathlib import Path
PROJECT_DIR = str(Path(__file__).resolve().parents[1])
sys.path.insert(1, PROJECT_DIR)
from allele_validator import AlleleValidator

class TestIEDB2MROID(unittest.TestCase):
    validator = AlleleValidator()

    def test_positive_cases(self):        
        '''True Case: Simple + Input/Return type agreement'''
        iedb_label = 'BoLA-2*026:01'
        result = self.validator.convert_iedblabel_to_mroid(iedb_label)
        expected_result = 'MRO:0036894'
        self.assertEqual(expected_result, result)

        iedb_label = 'HLA-DRB5*02:02'
        result = self.validator.convert_iedblabel_to_mroid(iedb_label)
        expected_result = 'MRO:0001349'
        self.assertEqual(expected_result, result)

        iedb_label = ['HLA-DRB5*02:02']
        result = self.validator.convert_iedblabel_to_mroid(iedb_label)
        expected_result = ['MRO:0001349']
        self.assertEqual(expected_result, result)

    def test_negative_cases(self):
        tool_labels = 'HLA-C03:214'
        result = self.validator.convert_iedblabel_to_mroid(tool_labels)
        expected_result = None
        self.assertEqual(expected_result, result)

        tool_labels = ['HLA-C03:214']
        result = self.validator.convert_iedblabel_to_mroid(tool_labels)
        expected_result = [None]
        self.assertEqual(expected_result, result)

    def test_multiple_input_positive_cases(self):
        iedb_labels = ['BoLA-2*026:01', 'HLA-DRB5*02:02', 'H2-IAq', 'HLA-DPA1*01:07/DPB1*29:01']
        result = self.validator.convert_iedblabel_to_mroid(iedb_labels)
        expected_result = ['MRO:0036894', 'MRO:0001349', 'MRO:0000978', 'MRO:0041541']
        self.assertEqual(expected_result, result)

    def test_multiple_input_negative_cases(self):
        tool_labels = ['BoLA-2:06901', 'BoLA-DQA*010:01:01/DQB*010:02:01']
        result = self.validator.convert_iedblabel_to_mroid(tool_labels)
        expected_result = [None, 'MRO:0000938']
        self.assertEqual(expected_result, result)

        iedb_labels = ['BoLA-2:06901', 'BoLA-DQA*010:01:01/DQB*010:02:01',  'HLA-DPA1*01:07/DPB1*132:01']
        result = self.validator.convert_iedblabel_to_mroid(iedb_labels)
        expected_result = [None, 'MRO:0000938', 'MRO:0041523']
        self.assertEqual(expected_result, result)

if __name__ == "__main__":
    unittest.main()