import sys
import unittest
from pathlib import Path
PROJECT_DIR = str(Path(__file__).resolve().parents[1])
sys.path.insert(1, PROJECT_DIR)
from allele_validator import AlleleValidator

class TestMethod2MROID(unittest.TestCase):
    validator = AlleleValidator()

    def test_positive_cases(self):        
        '''True Case: Simple + Input/Return type agreement'''
        tool_label = 'BoLA-2:02601'
        result = self.validator.convert_methodlabel_to_mroid(tool_label)
        expected_result = 'MRO:0036894'
        self.assertEqual(expected_result, result)

        tool_label = 'DRB5*02:02'
        result = self.validator.convert_methodlabel_to_mroid(tool_label)
        expected_result = 'MRO:0001349'
        self.assertEqual(expected_result, result)

        tool_label = ['DRB5*02:02']
        result = self.validator.convert_methodlabel_to_mroid(tool_label)
        expected_result = ['MRO:0001349']
        self.assertEqual(expected_result, result)

    def test_negative_cases(self):
        iedb_label = 'HLA-C*03:214'
        result = self.validator.convert_methodlabel_to_mroid(iedb_label)
        expected_result = None
        self.assertEqual(expected_result, result)

        iedb_label = ['HLA-C*03:214']
        result = self.validator.convert_methodlabel_to_mroid(iedb_label)
        expected_result = [None]
        self.assertEqual(expected_result, result)

    def test_multiple_input_positive_cases(self):
        tool_labels = ['BoLA-2:02601', 'DRB5*02:02', 'H2-IAq', 'DPA1*01:07/DPB1*29:01']
        result = self.validator.convert_methodlabel_to_mroid(tool_labels)
        expected_result = ['MRO:0036894', 'MRO:0001349', 'MRO:0000978', 'MRO:0041541']
        self.assertEqual(expected_result, result)


    def test_multiple_input_negative_cases(self):
        tool_labels = ['BoLA-2*069:01', 'BoLA-DQA*010:01:01/DQB*010:02:01', 'DRB*13:11']
        result = self.validator.convert_methodlabel_to_mroid(tool_labels)
        expected_result = [None, None, None]
        self.assertEqual(expected_result, result)

        tool_labels = ['BoLA-2*069:01', 'BoLA-DQA*010:01:01/DQB*010:02:01', 'DPA1*01:07/DPB1*132:01']
        result = self.validator.convert_methodlabel_to_mroid(tool_labels)
        expected_result = [None, None, 'MRO:0041523']
        self.assertEqual(expected_result, result)

if __name__ == "__main__":
    unittest.main()