'''
Created on Dec 13, 2023
@author: Yan
'''
from unittest import TestCase
import unittest
from icerfire_1_0_executable import icerfire_prediction

'''
 python tests.py
....
----------------------------------------------------------------------
Ran 4 tests in 0.978s

OK
'''

class Testicerfire_1_0(TestCase):
    maxDiff = None
    def test_HLA_prediction(self):
        result = icerfire_prediction(['ASSASSSSAAAAAAAT'], [('DRB1*13:02', 16)])
        expected_result = [[('ASSSSAAAA', 19012.82)]]
        result = list(result.values())
        self.assertEqual(result, expected_result)

    def test_H2_prediction(self):
        result = icerfire_prediction(['ASSASSSSAAAAAAAT'], [('H2-IAb', 15)])
        expected_result = [[('ASSSSAAAA', 223.31), ('SSSSAAAAA', 288.29)]]
        result = [list(v) for k,v in result.items()]
        self.assertEqual(result, expected_result)

    def test_length(self):
        result = icerfire_prediction(['ASSASSSSAAAAAAAT'], [('H2-IAb', 10)])
        expected_result = [[('SSASSSSAA', 11223.1), ('SASSSSAAA', 10464.08), ('ASSSSAAAA', 3954.74), ('SSSSAAAAA', 4601.54), ('SSSAAAAAA', 5860.82), ('SSAAAAAAA', 5009.02), ('SAAAAAAAT', 5997.85)]]
        result = [list(v) for k,v in result.items()]
        self.assertEqual(result, expected_result)

    def test_ValueError(self):
        with self.assertRaises(ValueError):
            result = icerfire_prediction('ASSASSSSAAAAAAAT', 'DRB1*13:02', 20)
def main():
    params = {
        "input_sequence_text": "RKLYCVLLFLSAAE\tRKLYCVLLFLSAFE\nCVLLLSAFFEATYM\tCVLLLSAFFEFTYM\nLSAFEFTAYMINFG\tLSAFEFTFYMINFG\nEFTYMAFFGRGQNA\tEFTYMNFFGRGQNA",
        "peptide_length_range": None,
        "alleles": "HLA-A*02:01",
        "predictors": [
            {
            "type": "icerfire",
            "method": "icerfire"
            }
        ]
    }
    params2 = {
        "input_sequence_text": "SVLDVGVAV,SVLDVGGAV\nLLQICERIPTI,LLQVCERIPTI\nPLLPALSPGL,PLLPALSPGS",
        "peptide_length_range": None,
        "alleles": "HLA-A*02:01",
        "predictors": [
            {
            "type": "icerfire",
            "method": "icerfire"
            }
        ]
    }
    #params["input_sequence_text"] = "VLLFLSAAE,VLLFLSAFE" # this won't work it's not in pepx database."
    #params["input_sequence_text"] = "VLLFLSAAE,VLLFLSAFE,6.21" # this would work by using user-provided expression values."
    #params["input_sequence_text"] = "SVLDVGVAV,SVLDVGGAV\nLLQICERIPTI,LLQVCERIPTI"
    #params["input_sequence_text"] = "SVLDVGVAV,SVLDVGGAV"
    params["input_sequence_text"] = "VLLFLSAAE,VLLFLSAFE\nSVLDVGVAV,SVLDVGGAV\nLLQICERIPTI,LLQVCERIPTI"
    print(params)

    result = icerfire_prediction(params)
    print(result)

if __name__ == '__main__':
    #unittest.main()
    main()
