#!/bin/bash

database_file="pepX-prod-20231018.indexed.sqlite"

# Quit if the database file already exists
if [ -e "$database_file" ]; then
    echo "Database file ($database_file) already exists.  Move or delete it and rerun this script to download."
    exit 1
fi

# pull the latest models
echo "Downloding the latest pepX database."
wget https://downloads.iedb.org/datasets/pepx/LATEST/pepX-prod-20231018.indexed.sqlite

if [ -e 'pepx.sqlite' ]; then
    echo "pepx.sqlite already exists.  Manually remove and symlink $database_file to pepx.sqlite"
    exit 1
fi

ln -s $database_file pepx.sqlite
  
