from ExampleArgumentParser import PepXArgumentParser
import json
import sys
import pandas as pd
# from pepx_argparser import PepxArgumentParser
# from split import split_parameters_file
# from aggregation import aggregate_result_file


def export_result_from_aggregate(**kwargs):
    output_format = kwargs['output_format']
    output_file = kwargs['output_file']
    result = kwargs['result']

    # process collapsed header
    collapsed_headers = json.loads(result['collapsed_header_map']).values()
    formatted_collapsed_headers = ['pepx.' + header for header in collapsed_headers]
    
    # process expanded header
    expanded_headers = json.loads(result['expanded_header_map']).values()
    formatted_expanded_headers = ['pepx.' + header for header in expanded_headers]
    
    # components of json result file
    warnings = []
    result_json_collapsed = {
        # collapsed or expanded
        "type": "collapsed",
        "table_columns": formatted_collapsed_headers,
        "table_data": result['collapsed']
    }

    result_json_expanded = {
        # collapsed or expanded
        "type": "expanded",
        "table_columns": formatted_expanded_headers,
        "table_data": result['expanded']
    }

    json_result = {
        "warnings": warnings,
        "results": [result_json_collapsed, result_json_expanded]
    }

    json_result = json.dumps(json_result)

    outfile_path = output_file.name + '.' + output_format

    with open(outfile_path, 'w') as f:
        f.write(json_result)

def display_or_export_result(**kwargs):
    # If -j/-t flag is not set, then save the file as CSV in
    # current directory. If path is not set and only name of the
    # file is set, then save to current dir.
    output_file = kwargs['output_file']
    output_format = kwargs['output_format']
    pg_summary = kwargs['pg_summary']
    result = kwargs['result']

    if output_file :
        if output_format == 'csv' :
            if pg_summary :
                collapsed_header = list(json.loads(result['collapsed_header_map']).keys())
                result_df = pd.DataFrame(result['collapsed'])
                result_df.to_csv(output_file, header=collapsed_header, sep=',')
            else :
                # Default should be the expanded result
                expanded_header = list(json.loads(result['expanded_header_map']).keys())
                result_df = pd.DataFrame(result['expanded'])
                result_df.to_csv(output_file, header=expanded_header, sep=',')
                
        if output_format == 'tsv' :
            if pg_summary :
                collapsed_header = list(json.loads(result['collapsed_header_map']).keys())
                result_df = pd.DataFrame(result['collapsed'])
                result_df.to_csv(output_file, header=collapsed_header, sep='\t')
            else :
                expanded_header = list(json.loads(result['expanded_header_map']).keys())
                result_df = pd.DataFrame(result['expanded'])
                result_df.to_csv(output_file, header=expanded_header, sep='\t')
                
                
        if output_format == 'json' :
            if pg_summary :
                output_file.write(result['collapsed_json'])
            else :
                output_file.write(result['expanded_json'])
                
    else :
        if output_format == 'csv' or output_format == 'tsv' :
            if pg_summary :
                collapsed_header = list(json.loads(result['collapsed_header_map']).keys())
                result_df = pd.DataFrame(result['collapsed'], columns=collapsed_header)
                print(result_df.to_string(index=False))
            else :
                expanded_header = list(json.loads(result['expanded_header_map']).keys())
                result_df = pd.DataFrame(result['expanded'], columns=expanded_header)
                print(result_df.to_string(index=False))
                
        if output_format == 'json' :
            if pg_summary :
                print(result['collapsed_json'])
            else :
                print(result['expanded_json'])


def process(**kwargs):
    sequences = kwargs['sequences']
    qlevel = kwargs['qlevel']
    dataset = kwargs['dataset']
    dataset_id = dataset['dataset_id']
    pepx_db = kwargs['database']
    unmapped_peptides = kwargs['unmapped_peptides']

    collapsed_header = ""
    expanded_header = ""

    peptide_dictionary = pepx_db.peptide_lookup(sequences, dataset_id, qlevel)

    # Used for Summary table
    # available_peptides = peptide_dictionary['collapsed']['peptide'].tolist()

    # Rename table headers so that it can be used in the downloaded file.
    if qlevel == 'gene':
        expanded_header = [ 
            "Peptide", 
            "Total Peptide TPM", 
            "Median Peptide TPM", 
            "Max Peptide TPM",
            "Total Scaled Peptide TPM", 
            "Median Scaled Peptide TPM",
            "Max Scaled Peptide TPM",
            "Total Gene TPM",
            "Median Gene TPM",
            "Max Gene TPM",
            "Gene Symbols",
            "Gene ENSG IDs",
            "Gene TPMs",
            "Peptide TPMs",
            "Scaled Peptide TPMs",
            "Proteins Encoded by Gene",
            "Proteins Containing Peptide (per Gene)",
            "Fraction of Proteins Containing Peptide (per Gene)",
            "Gene Mean Occurrences per Protein"
        ]
        collapsed_header = [
            "Peptide",
            "Gene ENSG ID",
            "Gene Symbol",
            "Proteins Encoded by Gene",
            "Proteins Containing Peptide",
            "Fraction of Matching Proteins",
            "Mean Occurrences per Protein",
            "Gene TPM",
            "Peptide TPM",
            "Scaled Peptide TPM",
        ]

    if qlevel == 'transcript':
        expanded_header = [
            "Peptide",
            "Total Peptide TPM",
            "Median Peptide TPM",
            "Max Peptide TPM",
            "Total Transcript TPM",
            "Median Transcript TPM",
            "Max Transcript TPM",
            "Number of Genes",
            "Number of Transcripts",
            "Gene Symbols",
            "Gene ENSG IDs",
            "Transcript ENST IDs",
            "Protein ENSP IDs",
            "Number of Transcript Occurences",
            "Transcript TPMs",
            "Transcript Peptide TPMs"
        ]
        collapsed_header = [
            "Peptide",
            "Gene ENSG ID",
            "Protein ENSP ID",
            "Transcript ENST ID",
            "Gene Symbol",
            "Number of Occurences",
            "Transcript TPM",
            "Peptide TPM"
        ]

    collapsed_header_orig = list(peptide_dictionary['collapsed'].columns)[1:]
    expanded_header_orig = list(peptide_dictionary['expanded'].columns)[1:]

    if unmapped_peptides :
        # include unmapped peptides to the result dataframes
        upeptides = peptide_dictionary['unmapped']
        for upeptide in upeptides :
            ''' Collapsed Dataframe '''
            row_data = ['-'] * len(collapsed_header_orig)
            row_data[0] = upeptide
            
            # Empty row containing the unmapped peptide
            new_row = pd.DataFrame([row_data], columns=collapsed_header_orig)

            # Append this row to the end of the existing 'collapsed' dataframe
            collapsed_res = pd.concat([peptide_dictionary['collapsed'], new_row], ignore_index=True)
            peptide_dictionary['collapsed'] = collapsed_res

            ''' Expanded Dataframe '''
            row_data = ['-'] * len(expanded_header_orig)
            row_data[0] = upeptide

            # Empty row containing the unmapped peptide
            new_row = pd.DataFrame([row_data], columns=expanded_header_orig)

            # Append this row to the end of the existing 'collapsed' dataframe
            expanded_res = pd.concat([peptide_dictionary['expanded'], new_row], ignore_index=True)
            peptide_dictionary['expanded'] = expanded_res

    collapsed_header_map = dict(zip(collapsed_header, collapsed_header_orig))
    expanded_header_map = dict(zip(expanded_header, expanded_header_orig))
    collapsed_header_json = json.dumps(collapsed_header_map)
    expanded_header_json = json.dumps(expanded_header_map)


    # Filter dataframe as certain columns needs to be removed
    collapsed_result = peptide_dictionary['collapsed']
    expanded_result = peptide_dictionary['expanded']


    # col_to_remove = ['dataset_id']
    collapsed_result = collapsed_result.drop('dataset_id', axis=1)
    expanded_result = expanded_result.drop('dataset_id', axis=1)
        
    # Additional columns to remove
    if qlevel == 'transcript' :
        collapsed_result = collapsed_result.drop('transcript_enst_ids', axis=1)
        expanded_result = expanded_result.drop('transcript_enst_id', axis=1)


    result = {
        # Need df in list format so that the result page can render them into a table
        'collapsed': collapsed_result.values.tolist(),
        'expanded': expanded_result.values.tolist(),
        # It will use json form of the df when actually downloading tables.
        # Seems simpler and faster(?) to use json to rebuild the dataframe than turning list into dataframe again.
        'collapsed_json': collapsed_result.to_json(orient='columns'),
        'expanded_json': expanded_result.to_json(orient='columns'),
        # Header information will be used when downloading the table.
        'collapsed_header_map': collapsed_header_json,
        'expanded_header_map': expanded_header_json
    }

    return result



def main():
    ex = PepXArgumentParser()
    # ex.parser.add_argument(
    #         'foo',
    #         type=str,
    #         nargs='?',
    #         action='store',
    #         help='Space separated peptide sequences.')
    args = ex.parser.parse_args()
    print(args)

    # Retrieve Values
    sequences = args.sequences
    qlevel = args.quant_level
    datasource = args.datasource
    database = args.db_path
    # dataset = args.dataset
    
    print(sequences)
    print(qlevel)
    print(datasource)
    print(database)

    # result = process(
    #     sequences=sequences, 
    #     qlevel=qlevel,
    #     datasource=datasource,
    #     dataset=dataset,
    #     database=database,
    #     unmapped_peptides=unmapped_peptides)


if __name__ == "__main__":
    main()