import os
from setuptools import setup, find_packages

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

# get content of README
with open(os.path.join(os.path.dirname(__file__), 'README.md')) as readme:
    README = readme.read()

# get requirements
with open('requirements.txt') as f:
    required = f.read().splitlines()

setup(
    name="pepx_database_interface",
    version="1.0.1",
    packages=find_packages(),
    install_required=required,
    description='PepX database interface that will be used for PepX package.',
    long_description=README,
    # Important only if the package will be widely distributed.  See more at:
    #    https://pypi.python.org/pypi?%3Aaction=list_classifiers
    classifiers=[
        'Intended Audience :: Developers',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python :: 3',
    ]
)
