#!/bin/bash

# Wrapper script for run_stage_prediction.py which will set up the environment
# and run the tool for the given stage. To use:
#
# sh run_stage_prediction.sh {STAGE_ID}
#
# By default, the dev server will be used as the source for the stage
# information.  Setting the 'NXG_ENV' environment variable will
# override this behavior.

# pull the stage id from the command line parameter
stage_id=$1

# pull the environment name from the NXG_ENV variable; if not set, default to dev
env_name="${NXG_ENV:=dev}"

# load the NXG_AUTH_TOKEN into the environment
. /apps/iedb-libs/secrets.env

# define the modules & virtualenv for nxg-tools
PYTHON_MODULE_NXGTOOLS=python/3.11.3
PYTHON_VENV_NXGTOOLS=/apps/python-virtualenvs/nxg-tools

module unload python
module load $PYTHON_MODULE_NXGTOOLS
source $PYTHON_VENV_NXGTOOLS/bin/activate

echo "Running T cell MHC-I for stage: $stage_id"
echo "Using settings: $env_name"

# we get the directory of this script because the run_stage_prediction script
# should be in the same directory
SCRIPT_DIR=$( cd -- "$( dirname -- "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )

python $SCRIPT_DIR/run_stage_prediction.py \
--stage-id $stage_id \
--env-name $env_name
