import sys
import unittest
from pathlib import Path
PROJECT_DIR = str(Path(__file__).resolve().parents[1])
sys.path.insert(1, PROJECT_DIR)
from allele_validator import AlleleValidator

class TestMROID2IEDBLabel(unittest.TestCase):
    validator = AlleleValidator()

    def test_positive_cases(self):        
        '''True Case: Simple + Input/Return type agreement'''
        mroid = 'MRO:0036894'
        result = self.validator.convert_mroid_to_iedblabel(mroid)
        expected_result = 'BoLA-2*026:01'
        self.assertEqual(expected_result, result)

        mroid = 'MRO:0001349'
        result = self.validator.convert_mroid_to_iedblabel(mroid)
        expected_result = 'HLA-DRB5*02:02'
        self.assertEqual(expected_result, result)

        mroid = ['MRO:0001349']
        result = self.validator.convert_mroid_to_iedblabel(mroid)
        expected_result = ['HLA-DRB5*02:02']
        self.assertEqual(expected_result, result)

    def test_negative_cases(self):
        mroid = 'MRO:1135734'
        result = self.validator.convert_mroid_to_iedblabel(mroid)
        expected_result = None
        self.assertEqual(expected_result, result)

        mroid = ['MRO:1135734']
        result = self.validator.convert_mroid_to_iedblabel(mroid)
        expected_result = [None]
        self.assertEqual(expected_result, result)

    def test_multiple_input_positive_cases(self):
        mroids = ['MRO:0036894', 'MRO:0001349', 'MRO:0000978', 'MRO:0041541']
        result = self.validator.convert_mroid_to_iedblabel(mroids)
        expected_result = ['BoLA-2*026:01', 'HLA-DRB5*02:02', 'H2-IAq', 'HLA-DPA1*01:07/DPB1*29:01']
        self.assertEqual(expected_result, result)

    def test_multiple_input_negative_cases(self):
        mroids = ['MRO:1135734', 'MRO:0000938']
        result = self.validator.convert_mroid_to_iedblabel(mroids)
        expected_result = [None, 'BoLA-DQA*010:01:01/DQB*010:02:01']
        self.assertEqual(expected_result, result)

        mroids = ['MRO:1135734', 'MRO:0000938', 'MRO:0041523']
        result = self.validator.convert_mroid_to_iedblabel(mroids)
        expected_result = [None, 'BoLA-DQA*010:01:01/DQB*010:02:01',  'HLA-DPA1*01:07/DPB1*132:01']
        self.assertEqual(expected_result, result)

if __name__ == "__main__":
    unittest.main()