import sys
import unittest
from pathlib import Path
PROJECT_DIR = str(Path(__file__).resolve().parents[1])
sys.path.insert(1, PROJECT_DIR)
from allele_validator import AlleleValidator

class TestAvailableLengths(unittest.TestCase):
    validator = AlleleValidator()

    def test_positive_cases(self):        
        '''True Case: Simple + Input/Return type agreement'''
        iedb_label = 'HLA-A*02:03'
        result = self.validator.get_available_lengths(iedb_label, method='icerfire', tools_group='pvc')
        expected_result = '8,9,10,11,12'
        self.assertEqual(expected_result, result)

        iedb_label = 'BoLA-1*031:02'
        result = self.validator.get_available_lengths(iedb_label, method='netmhcpan')
        expected_result = '8,9,10,11,12,13,14'
        self.assertEqual(expected_result, result)

        result = self.validator.get_available_lengths(iedb_label, method='pickpocket')
        expected_result = '8,9,10,11,12,13,14,15'
        self.assertEqual(expected_result, result)

    def test_negative_cases(self):
        iedb_label = 'BoLA-1*031:02'
        result = self.validator.get_available_lengths(iedb_label, method='netmhciipan')
        expected_result = None
        self.assertEqual(expected_result, result)

    def test_multiple_input_positive_cases(self):
        iedb_label = ['BoLA-2*069:01', 'BoLA-3*011:01']
        result = self.validator.get_available_lengths(iedb_label, method='netmhcpan', version='4.1', tools_group='mhci')
        expected_result = ['8,9,10,11,12,13,14', '8,9,10,11,12,13,14']
        self.assertEqual(expected_result, result)

    def test_multiple_input_negative_cases(self):
        iedb_label = ['BoLA-2*069:01', 'BoLA-DQA*010:01:01/DQB*010:02:01']
        result = self.validator.get_available_lengths(iedb_label, method='netmhcpan', version='4.1', tools_group='mhci')
        expected_result = ['8,9,10,11,12,13,14', None]
        self.assertEqual(expected_result, result)

if __name__ == "__main__":
    unittest.main()