import argparse
import textwrap

class NGArgumentParser(argparse.ArgumentParser):
    def __init__(self):
        '''
        It is the developer's responsibility to customize these parameters.
        At the minimum, the below parameters should be customized before deploying.

        Developers can choose to futher customize other parameters of ArgumentParser()
        from here:
        https://docs.python.org/3/library/argparse.html#argparse.ArgumentParser
        '''
        super().__init__()
        # self.prog='The name of the program (default: os.path.basename(sys.argv[0]))'
        # self.usage='The string describing the program usage (default: generated from arguments added to parser)'
        self.formatter_class=argparse.RawDescriptionHelpFormatter
        self.description='Text to display before the argument help (by default, no text)'
        self.epilog=textwrap.dedent('''
        Please contact us with any issues encountered or questions about the software
        through any of the channels listed below.

        IEDB Help Desk: https://help.iedb.org/
        Email: help@iedb.org
        ''')
        
        self.subparser = self.add_subparsers(
            title='subcommands',
            description='Here are list of valid subcommands.',
            help='additional help',
            dest='subcommand',
            # Explicitly set this to prevent the following error.
            # TypeError: __init__() got an unexpected keyword argument 'prog'
            parser_class=argparse.ArgumentParser,
            required=True
            )
        
        # Create subparser 'prediction'
        # self.parser_predict = self.subparser.add_parser('predict', help='Perform individual prediction.')
        self.parser_predict=None

        # Create subparser 'split'
        # -----------------------------------------------------
        parser_split = self.subparser.add_parser('preprocess', 
                                                 help='Preprocess jobs.',
                                                 description='This is where it will split the jobs and output job_descriptions.json.')
        parser_split.add_argument("--json-input", "-j",
                                 dest="json_filename",
                                 help="JSON file containing input parameters.",
                                 metavar="JSON_FILE")
        parser_split.add_argument("--dir",
                            dest="split_parameters_dir",
                            default='',
                            help="the diretory for the JSON files that input parameters splitted into")

        parser_split.add_argument("--inputs-dir",
                            dest="split_inputs_dir",
                            default=None,
                            help="the diretory for the sequence and peptide files that input sequences splitted into")
        parser_split.add_argument("--assume-valid",
                                 action="store_true",
                                 dest="assume_valid_flag",
                                 default=False,
                                 #help="flag to indicate skipping validation")
                                 help=argparse.SUPPRESS)


        # Create subparser 'aggregate'
        # -----------------------------------------------------
        parser_agg = self.subparser.add_parser('postprocess', 
                                               help='Postprocess jobs.',
                                               description='This is where it will aggregate the results into a file.')
        parser_agg.add_argument("--job-desc-file",
                            dest="job_desc_file",
                            default='',
                            help="the file path for the job description")

        parser_agg.add_argument("--aggregate-input-dir",
                            dest="aggregate_input_dir",
                            default='',
                            help="the diretory for the JSON files which have input parameters")

        parser_agg.add_argument("--aggregate-result-dir",
                            dest="aggregate_result_dir",
                            default='',
                            help="the diretory for the JSON files contains results need to be aggregated as well as the place we place the final result file")
        

    def add_predict_subparser(self, help='', description=''):
        '''
        This is where prediction subparser will be created with user specified
        help and description texts, and attaching some common arguments across tools.
        '''
        # add subparser
        self.parser_predict = self.subparser.add_parser('predict', help=help, description=description)

        # add common arguments across tools
        self.parser_predict.add_argument("--json-input", "-j",
                                 dest="json_filename",
                                 help="JSON file containing input parameters.",
                                 metavar="JSON_FILE")
        
        return self.parser_predict
    
    def process_split(json_filename, split_parameters_dir=None, split_inputs_dir=None, assume_valid=False):
        pass


