#!/bin/bash

# Wrapper script for run_stage_filter.py which will set up the enviroment
# and run the tool for the given stage. To use:
#
# sh run_tcell_filter.sh {STAGE_ID} {INPUT_STAGE_ID}
#
# By default, the dev server will be used as the source for the stage
# information.  Setting the 'NXG_BASE_URI' environment variable will
# override this behavior.

# pull the stage id from the command line parameter
stage_id=$1
input_stage_id=$2

# pull the base_uri from the environment; if not set, use the dev server
base_uri="${NXG_BASE_URI:=https://api-nextgen-tools-dev.iedb.org/api/v1}"

# load the NXG_AUTH_TOKEN into the environment
. /apps/iedb-libs/secrets.env

# load the module and virtualenv
module unload python
module load python/3.11.3
source /apps/python-virtualenvs/tcell_mhci/bin/activate

echo "Running stage filter for: $stage_id"
echo "Using server: $base_uri"

python /apps/iedb-libs/nxg-tools/nxg_hpc_jobs/run_stage_filter.py \
--stage_id $stage_id \
--input_stage_id $input_stage_id \
--base_uri $base_uri
