from src.validators import InputManager
import json
import os


if __name__ == "__main__":
    examples_dir = 'examples'
    example_files = [f for f in os.listdir(examples_dir) if os.path.isfile(os.path.join(examples_dir, f)) and f.endswith('.json')]
    print("Available example files:", example_files)

    print("--------------------------------")
    for example_file in example_files:
        full_example_file_path = f"examples/{example_file}"

        with open(full_example_file_path) as f:
            data = json.load(f)

        manager = InputManager(data)
        print("Analyzing", full_example_file_path)
        # print(manager.input_type)
        print(manager.describe())
        print("--------------------------------")
    