# This is a script that's not part of the Allele Validator, and should not be 
# included in the package. The following code will retrieve MHCII alleles and 
# try to create synonyms for them because most MHCII alleles don't seem to have 
# the synonyms. 
# Thus, this code will generate synonyms with different formats and organize 
# them into a excel sheet.
import pandas as pd
from pathlib import Path
DATA_DIR = str(Path(__file__).parent) + "/data"


def main():
    MOLECULE_FILE = "{}/mhc_alleles.tsv".format(DATA_DIR)
    
    # Read over the TSV file
    molecule_df = pd.read_csv(MOLECULE_FILE, skipinitialspace=True, sep='\t', encoding='utf-8')
    print(molecule_df)

    print(molecule_df['IEDB Label'])



if __name__=='__main__':
    main()