import sys
import json
import unittest
from pathlib import Path
PROJECT_DIR = str(Path(__file__).resolve().parents[1])
sys.path.insert(1, PROJECT_DIR)
from allele_validator import AlleleValidator

@unittest.skip("This test is intentionally skipped in all environments for the moment.")
class TestAlleleInfo(unittest.TestCase):
    def test_validate_alleles(self):
        validator = AlleleValidator()
        
        '''True Case: Simple + Input/Return type agreement'''
        iedb_label = "BoLA-1*009:01"
        result = validator.get_allele_info(iedb_label)
        expected_result = \
        {
            'IEDB Label': 'BoLA-1*009:01', 
            'Tool Label': 'BoLA-1:00901', 
            'MRO ID': 'MRO:0036770', 
            'Synonyms': 'BoLA-1:00901', 
            'Tools Info': [
                {
                    'Group': 'mhci', 
                    'Tool': 'netmhcpan', 
                    'Version': 4.1, 
                    'Lengths': '8,9,10,11,12,13,14'
                 }, 
                 {
                     'Group': 'mhci', 
                     'Tool': 'pickpocket', 
                     'Version': 1.1, 
                     'Lengths': '8,9,10,11,12,13,14,15'
                  }
            ]
        }

        result = json.dumps(result)
        expected_result = json.dumps(expected_result)
        self.assertEqual(result, expected_result)


        iedb_label = 'HLA-A*02:01'
        result = validator.get_allele_info(iedb_label)
        expected_result = \
        {
            'IEDB Label': 'HLA-A*02:01', 
            'Tool Label': 'HLA-A*02:01', 
            'MRO ID': 'MRO:0001007', 
            'Synonyms': 'HLA-A2.1|HLA-A*020101|HLA-A02:01|HLA-A0201|HLA-A*0201',
            'Tools Info': [
                {
                    'Group': 'mhci', 
                    'Tool': 'mhcflurry', 
                    'Version': 2.0, 
                    'Lengths': '8,9,10,11,12,13,14,15'
                }, 
                {
                    'Group': 'mhci', 
                    'Tool': 'ann', 
                    'Version': 4.0, 
                    'Lengths': '8,9,10,11,12,13,14'
                }, 
                {
                    'Group': 'mhci', 
                    'Tool': 'comblib_sidney2008', 
                    'Version': 1.0, 
                    'Lengths': '9'
                }, 
                {
                    'Group': 'mhci', 
                    'Tool': 'consensus', 
                    'Version': 2.18, 
                    'Lengths': '8,9,10,11,12,13,14'
                }, 
                {
                    'Group': 'mhci', 
                    'Tool': 'pickpocket', 
                    'Version': 1.1, 
                    'Lengths': '8,9,10,11,12,13,14,15'
                }, 
                {
                    'Group': 'mhci', 
                    'Tool': 'smmpmbec', 
                    'Version': 1.0, 
                    'Lengths': '8,9,10,11'
                }, 
                {
                    'Group': 'mhci', 
                    'Tool': 'smm', 
                    'Version': 1.0, 
                    'Lengths': '8,9,10,11'
                }, 
                {
                    'Group': 'mhci', 
                    'Tool': 'mhcnp', 
                    'Version': 1.0, 
                    'Lengths': '8,9,10,11'
                }, 
                {
                    'Group': 'mhci', 
                    'Tool': 'netctl', 
                    'Version': 1.1, 
                    'Lengths': '9'
                }, 
                {
                    'Group': 'mhci', 
                    'Tool': 'immunogenicity', 
                    'Version': 3.0, 
                    'Lengths': '9'
                }, 
                {
                    'Group': 'pvc', 
                    'Tool': 'icerfire', 
                    'Version': 1.0, 
                    'Lengths': '8,9,10,11,12'
                }, 
                {
                    'Group': 'mhci', 
                    'Tool': 'netctlpan', 
                    'Version': 1.1, 
                    'Lengths': '8,9,10,11'
                }, 
                {
                    'Group': 'mhci', 
                    'Tool': 'netmhcpan', 
                    'Version': 4.1, 
                    'Lengths': '8,9,10,11,12,13,14'
                }
            ]
        }

        result = json.dumps(result)
        expected_result = json.dumps(expected_result)
        self.assertEqual(result, expected_result)


        iedb_labels = ["BoLA-1*009:01", "HLA-B*35:03"]
        result = validator.get_allele_info(iedb_labels)
        expected_result = \
        [   
            {
            'IEDB Label': 'BoLA-1*009:01', 
            'Tool Label': 'BoLA-1:00901', 
            'MRO ID': 'MRO:0036770', 
            'Synonyms': 'BoLA-1:00901', 
            'Tools Info': [
                {
                    'Group': 'mhci', 
                    'Tool': 'netmhcpan', 
                    'Version': 4.1, 
                    'Lengths': '8,9,10,11,12,13,14'
                 }, 
                 {
                     'Group': 'mhci', 
                     'Tool': 'pickpocket', 
                     'Version': 1.1, 
                     'Lengths': '8,9,10,11,12,13,14,15'
                  }
            ]
            },
            {
                'IEDB Label': 'HLA-B*35:03', 
                'Tool Label': 'HLA-B*35:03', 
                'MRO ID': 'MRO:0001094', 
                'Synonyms': 'HLA-B35:03|HLA-B3503|HLA-B*3503',
                'Tools Info': [
                    {
                        'Group': 'mhci', 
                        'Tool': 'smm', 
                        'Version': 1.0, 
                        'Lengths': '9,10'
                    }, 
                    {
                        'Group': 'mhci', 
                        'Tool': 'smmpmbec', 
                        'Version': 1.0, 
                        'Lengths': '9,10'
                    }, 
                    {
                        'Group': 'mhci', 
                        'Tool': 'pickpocket', 
                        'Version': 1.1, 
                        'Lengths': '8,9,10,11,12,13,14,15'
                    }, 
                    {
                        'Group': 'mhci', 
                        'Tool': 'consensus', 
                        'Version': 2.18, 
                        'Lengths': '8,9,10,11,12,13,14'
                    }, 
                    {
                        'Group': 'mhci', 
                        'Tool': 'netctl', 
                        'Version': 1.1, 
                        'Lengths': '9'
                    }, 
                    {
                        'Group': 'mhci', 
                        'Tool': 'mhcflurry', 
                        'Version': 2.0, 
                        'Lengths': '8,9,10,11,12,13,14,15'
                    }, 
                    {
                        'Group': 'mhci', 
                        'Tool': 'ann', 
                        'Version': 4.0, 
                        'Lengths': '8,9,10,11,12,13,14'
                    }, 
                    {
                        'Group': 'pvc', 
                        'Tool': 'icerfire', 
                        'Version': 1.0, 
                        'Lengths': '8,9,10,11,12'
                    }, 
                    {
                        'Group': 'mhci', 
                        'Tool': 'netctlpan', 
                        'Version': 1.1, 
                        'Lengths': '8,9,10,11'
                    }, 
                    {
                        'Group': 'mhci', 
                        'Tool': 'netmhcpan', 
                        'Version': 4.1, 
                        'Lengths': '8,9,10,11,12,13,14'
                    }
                ]
            }
        ]

        result = json.dumps(result)
        expected_result = json.dumps(expected_result)
        self.assertEqual(result, expected_result)


if __name__ == "__main__":
    unittest.main()