import pickle
import pandas as pd
from pathlib import Path
DATA_DIR = str(Path(__file__).resolve().parents[0]) + "/data"


def pickle_autocomplete_datasource():
    AUTOCOMPLETE_DATAFILE = "{}/allele_datasource.tsv".format(DATA_DIR)

    # Read over the TSV file
    autocomp_df = pd.read_csv(AUTOCOMPLETE_DATAFILE, skipinitialspace=True, sep='\t', encoding='utf-8')

    # Write to pickle file
    with open('pickles/autocomp_data_info.p', 'wb') as pickled_file:
        pickle.dump(autocomp_df, pickled_file)
    
    print("Finished pickling allele_datasource.tsv...")


def pickle_molecule():
    MOLECULE_FILE = "{}/mhc_alleles.tsv".format(DATA_DIR)
    
    # Read over the TSV file
    molecule_df = pd.read_csv(MOLECULE_FILE, skipinitialspace=True, sep='\t', encoding='utf-8')

    # Write to pickle file
    with open('pickles/molecule_info.p', 'wb') as pickled_file:
        pickle.dump(molecule_df, pickled_file)
    
    print("Finished pickling mhc_alleles.tsv...")

def pickle_tools_mapping():
    MAPPED_MRO_FILE = "{}/tools-mapping.tsv".format(DATA_DIR)
    # HEADER = ["Tools Type",	"Method", "Tools Label", "MRO ID", "IEDB Label", "Lengths"]

    # Read over the TSV file
    # mapped_mro_df = pd.read_csv(MAPPED_MRO_FILE, skipinitialspace=True, usecols=HEADER, sep='\t', encoding='utf-8')
    mapped_mro_df = pd.read_csv(MAPPED_MRO_FILE, skipinitialspace=True, sep='\t', encoding='utf-8')

    # Write to pickle file
    with open('pickles/tools_mapping_info.p', 'wb') as pickled_file:
        pickle.dump(mapped_mro_df, pickled_file)
    
    print("Finished pickling tools-mapping.tsv...")


if __name__ == '__main__' :
    pickle_tools_mapping()
    pickle_molecule()
    pickle_autocomplete_datasource()