import os
from setuptools import setup, find_packages

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

# Get all of the bin/ data/ netMHCpan-2.3/ test/ files for use as package data
def recursive_walk(startdir):
    file_list = []
    for dirname, subdirList, fileList in os.walk(startdir, followlinks=True):
        if '.svn' in subdirList:
            subdirList.remove('.svn')
        for fname in fileList:
            file_list.append(os.path.join(dirname, fname))
            for sdname in subdirList:
                sdfiles = recursive_walk(sdname)
                file_list.extend(sdfiles)
    return file_list

pkg_data_files = ['netCTLpan', 'netCTLpan.1']
os.chdir('netctlpan_1_1_executable')
for subdir in ['bin','data','netMHCpan-2.3','test']:
    file_list = recursive_walk(subdir)
    pkg_data_files.extend(file_list)
os.chdir(os.pardir)

with open(os.path.join(os.path.dirname(__file__), 'README.rst')) as readme:
    README = readme.read()

setup(
    name = "netctlpan-1.1-executable",
    version = "1.1.0.9",
    author = 'Dorjee Gyaltsen',
    author_email = 'dorjee@lji.org',
    packages = ['netctlpan_1_1_executable' ],
    package_data = { 'netctlpan_1_1_executable': pkg_data_files },
    description = 'Python package to provide netCTLpan-1.1 executable',
    long_description = README,
    keywords = 'T cell epitope prediction',
    classifiers = [
        'Intended Audience :: Developers',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python :: 3.7',
    ]
)

