#! /usr/bin/python
import os
import sys
import unittest
import json
#from distutils.spawn import find_executable
import subprocess


class Util_test(unittest.TestCase):

    def test_example(self):
        self.assertEqual(1,1) 

    def test_os_popen_example(self):
        cmd = 'echo example'
        with os.popen(cmd) as process:
            result = process.read()
        self.assertEqual(result, 'example\n')

    def test_help(self):        
        cmd = 'python3 src/tcell_mhci.py -h'
        with os.popen(cmd) as process:
            result = process.read()

        with open(os.path.join(os.path.dirname(__file__), 'src', 'example_commands.txt'), 'r') as f:
            expected_output = f.read()+"\n"
        self.assertEqual(result, expected_output)
        # if not options are given, help info will be returned as well
        cmd = 'python3 src/tcell_mhci.py'
        with os.popen(cmd) as process:
            result = process.read()
        self.assertEqual(result, expected_output)

    def test_recommended(self):
        cmd='python3 src/tcell_mhci.py -v'
        with os.popen(cmd) as process:
            result = process.read()
        expected_output = '''| Tool Group     | Method             | Version   |
|:---------------|:-------------------|:----------|
| binding        | consensus          | 2.18      |
| binding        | ann                | 4.0       |
| binding        | netmhcpan_ba       | 4.1       |
| binding        | netmhcpan_el       | 4.1       |
| binding        | comblib_sidney2008 | 1.0       |
| binding        | smm                | 1.0       |
| binding        | smmpmbec           | 1.0       |
| binding        | mhcnp              | 2.0.3     |
| binding        | mhcflurry          | 2.1.1     |
| processing     | basic_processing   | 1.0       |
| processing     | netchop            | 3.1       |
| processing     | netctl             | 1.1       |
| processing     | netctlpan          | 1.1       |
| immunogenicity | immunogenicity     | 1.0       |
'''
        self.assertEqual(result, expected_output)


class TestCommonPrediction(unittest.TestCase):
    maxDiff = None
    def test_netmhcpan_el(self):

        cmd="python3 src/tcell_mhci.py --method=netmhcpan_el --allele=HLA-A*02:01 -p examples/test.pep"
        with os.popen(cmd) as process:
            result = process.read()
        expected_output = (
            "allele\tpeptide\tcore\ticore\tscore\tpercentile\n"
            "HLA-A*02:01\tKMKGDYFRY\tKMKGDYFRY\tKMKGDYFRY\t0.00605\t6.3\n"
            "HLA-A*02:01\tTMDKSELVQK\tTMDSELVQK\tTMDKSELVQK\t0.001846\t11\n"
            "HLA-A*02:01\tEILNSPEKAC\tELNSPEKAC\tEILNSPEKAC\t0.000223\t25\n"
        )
        self.assertEqual(result, expected_output)

    def test_json_input(self):

        cmd="python3 src/tcell_mhci.py -j examples/binding.json"
        with os.popen(cmd) as process:
            result = process.read()
        expected_output = (
            "allele\tpeptide\tcore\ticore\tic50\tpercentile\n"
            "HLA-A*01:01\tTMDKSELVQK\tTMDKSELQK\tTMDKSELVQK\t11772.61\t3.2\n"
            "HLA-A*02:01\tKMKGDYFRYF\tKMKGDYFYF\tKMKGDYFRYF\t6678.01\t9.7\n"
            "HLA-A*01:01\tKMKGDYFRYF\tKMKGDYFYF\tKMKGDYFRYF\t23695.75\t13\n"
            "HLA-A*02:01\tTMDKSELVQK\tTMDSELVQK\tTMDKSELVQK\t24545.96\t31\n"
            "HLA-A*02:01\tEILNSPEKAC\tELNSPEKAC\tEILNSPEKAC\t33036.2\t49\n"
            "HLA-A*01:01\tEILNSPEKAC\tEILNSPEKC\tEILNSPEKAC\t42395.54\t87\n"
        )
        self.assertEqual(result, expected_output)

    def test_json_output(self):

        cmd="python3 src/tcell_mhci.py  -j examples/binding.json -o output -f json"
        with os.popen(cmd) as process:
            printed_result = process.read()
        with open('output.json','r') as f:
            result = json.load(f)
        with open('test_data/expected_output.json','r') as f:
            expected_output = json.load(f)

        self.assertEqual(result, expected_output)

    def test_warning(self):

        cmd=["python3", "src/tcell_mhci.py", "-j", "test_data/warnings_binding.json"]
        with subprocess.Popen(cmd, stdout=subprocess.PIPE, stderr=subprocess.PIPE) as process:
            stdoutdata, stderrdata = process.communicate()
        warnings = stderrdata.decode()
        expected_output = (
            "warnings:\n"
            "peptide \"KMKGDYFRYFFFFFFFFFF\" length is out of valid range (8-14)\n"
        )
        self.assertEqual(warnings, expected_output)


    def test_warning_asis(self):

        cmd=["python3", "src/tcell_mhci.py", "-j", "test_data/warnings_asis_binding.json"]
        with subprocess.Popen(cmd, stdout=subprocess.PIPE, stderr=subprocess.PIPE) as process:
            stdoutdata, stderrdata = process.communicate()
        warnings = stderrdata.decode()
        expected_output = (
            "warnings:\n"
            "peptide \"KMKGDYFRYFFFFFFFFFF\" length is out of valid range (8-15)\n"
        )
        self.assertEqual(warnings, expected_output)


    def test_peptide_input_ann(self):

        cmd="python3 src/tcell_mhci.py -p examples/test.pep --method=ann --allele=HLA-A*02:01"
        with os.popen(cmd) as process:
            result = process.read()
        expected_output = (
            "allele\tpeptide\tic50\tpercentile\n"
            "HLA-A*02:01\tKMKGDYFRY\t21153.09\t36\n"
            "HLA-A*02:01\tTMDKSELVQK\t29354.36\t54\n"
            "HLA-A*02:01\tEILNSPEKAC\t33229.79\t65\n"
        )
        self.assertEqual(result, expected_output)


    def test_peptide_input_netmhcpan(self):

        cmd="python3 src/tcell_mhci.py -p examples/test.pep --method=netmhcpan --allele=HLA-A*02:01"
        with os.popen(cmd) as process:
            result = process.read()
        expected_output = (
            "allele\tpeptide\tcore\ticore\tic50\tpercentile\n"
            "HLA-A*02:01\tKMKGDYFRY\tKMKGDYFRY\tKMKGDYFRY\t13647.29\t18\n"
            "HLA-A*02:01\tTMDKSELVQK\tTMDSELVQK\tTMDKSELVQK\t24545.96\t31\n"
            "HLA-A*02:01\tEILNSPEKAC\tELNSPEKAC\tEILNSPEKAC\t33036.2\t49\n"
        )
        self.assertEqual(result, expected_output)

"""
# comments out for using abspath now
class TestSplit(unittest.TestCase):
    maxDiff = None

    def test_binding(self):

        cmd="python3 src/tcell_mhci.py -j examples/binding2\*2.json --split --split-dir=parameter_units"
        with os.popen(cmd) as process:
            printed_result = process.read()
        with open('job_descriptions.json','r') as f:
            result = json.load(f)
        with open('test_data/binding_job_descriptions.json','r') as f:
            expected_output = json.load(f)

        self.assertEqual(result, expected_output)


    def test_netchop(self):

        cmd="python3 src/tcell_mhci.py -j examples/netchop\*3.json --split --split-dir=parameter_units"
        with os.popen(cmd) as process:
            printed_result = process.read()
        with open('job_descriptions.json','r') as f:
            result = json.load(f)
        with open('test_data/netchop_job_descriptions.json','r') as f:
            expected_output = json.load(f)

        self.assertEqual(result, expected_output)
"""


class TestAggregate(unittest.TestCase):
    #maxDiff = None
    def test_netchop_3files(self):
        cmd="python3 src/tcell_mhci.py --aggregate --job-desc-file=\"test_data/aggregation/job_descriptions.json\" --aggregate-input-dir=\"test_data/aggregation/input\"  --aggregate-result-dir=\"test_data/aggregation/output\""
        with os.popen(cmd) as process:
            printed_result = process.read()
        with open('test_data/aggregation/output/aggregated_result.json','r') as f:
            result = json.load(f)
        with open('test_data/aggregation/output/expected_aggregated_result.json','r') as f:
            expected_output = json.load(f)
        # sort results
        result['results'].sort(key=lambda r:(r['result_type'], r.get('method',None)))
        expected_output['results'].sort(key=lambda r:(r['result_type'], r.get('method',None)))
        for res in result['results']:
            if res['result_type'] in ['peptide_table', 'residue_table']:
                res['table_columns'].sort()
                res['table_data'] = [sorted(map(str, row)) for row in res['table_data']]
        for res in  expected_output['results']:
            if res['result_type'] in ['peptide_table', 'residue_table']:
                res['table_columns'].sort()
                res['table_data'] = [sorted(map(str, row)) for row in res['table_data']]
        self.assertEqual(result, expected_output)

class TestSplit(unittest.TestCase):
    #maxDiff = None
    def test_split(self):
        cmd="python3 src/tcell_mhci.py  --split  -j \"test_data/split/input.json\"  --split-dir=\"test_data/split/output\""
        with os.popen(cmd) as process:
            printed_result = process.read()
        with open('test_data/split/output/6.json','r') as f:
            result = json.load(f)
        with open('test_data/split/expected_6.json','r') as f:
            expected_output = json.load(f)
        result.pop('peptide_file_path', None)
        expected_output.pop('peptide_file_path', None)
        result.pop('input_sequence_text_file_path', None)
        expected_output.pop('input_sequence_text_file_path', None)
        self.assertEqual(result, expected_output)

class TestBindingPrediction(unittest.TestCase):
    #maxDiff = None
    def test_netmhcpan_el(self):
        cmd="python3 src/tcell_mhci.py  -j test_data/binding/netmhcpan_el/input.json -o test_data/binding/netmhcpan_el/output -f json"
        with os.popen(cmd) as process:
            printed_result = process.read()
        with open('test_data/binding/netmhcpan_el/output.json','r') as f:
            result = json.load(f)
        with open('test_data/binding/netmhcpan_el/expected_output.json','r') as f:
            expected_output = json.load(f)
        self.assertEqual(result, expected_output)

    def test_netmhcpan_ba(self):
        cmd="python3 src/tcell_mhci.py  -j test_data/binding/netmhcpan_ba/input.json -o test_data/binding/netmhcpan_ba/output -f json"
        with os.popen(cmd) as process:
            printed_result = process.read()
        with open('test_data/binding/netmhcpan_ba/output.json','r') as f:
            result = json.load(f)
        with open('test_data/binding/netmhcpan_ba/expected_output.json','r') as f:
            expected_output = json.load(f)
        self.assertEqual(result, expected_output)

    def test_ann(self):
        cmd="python3 src/tcell_mhci.py  -j test_data/binding/ann/input.json -o test_data/binding/ann/output -f json"
        with os.popen(cmd) as process:
            printed_result = process.read()
        with open('test_data/binding/ann/output.json','r') as f:
            result = json.load(f)
        with open('test_data/binding/ann/expected_output.json','r') as f:
            expected_output = json.load(f)
        self.assertEqual(result, expected_output)

    def test_smm(self):
        cmd="python3 src/tcell_mhci.py  -j test_data/binding/smm/input.json -o test_data/binding/smm/output -f json"
        with os.popen(cmd) as process:
            printed_result = process.read()
        with open('test_data/binding/smm/output.json','r') as f:
            result = json.load(f)
        with open('test_data/binding/smm/expected_output.json','r') as f:
            expected_output = json.load(f)
        self.assertEqual(result, expected_output)

    def test_smmpmbec(self):
        cmd="python3 src/tcell_mhci.py  -j test_data/binding/smmpmbec/input.json -o test_data/binding/smmpmbec/output -f json"
        with os.popen(cmd) as process:
            printed_result = process.read()
        with open('test_data/binding/smmpmbec/output.json','r') as f:
            result = json.load(f)
        with open('test_data/binding/smmpmbec/expected_output.json','r') as f:
            expected_output = json.load(f)
        self.assertEqual(result, expected_output)

    def test_comblib_sidney2008(self):
        cmd="python3 src/tcell_mhci.py  -j test_data/binding/comblib_sidney2008/input.json -o test_data/binding/comblib_sidney2008/output -f json"
        with os.popen(cmd) as process:
            printed_result = process.read()
        with open('test_data/binding/comblib_sidney2008/output.json','r') as f:
            result = json.load(f)
        with open('test_data/binding/comblib_sidney2008/expected_output.json','r') as f:
            expected_output = json.load(f)
        self.assertEqual(result, expected_output)

    '''
    def test_mhcflurry(self):
        cmd="python3 src/tcell_mhci.py  -j test_data/binding/mhcflurry/input.json -o test_data/binding/mhcflurry/output -f json"
        with os.popen(cmd) as process:
            printed_result = process.read()
        with open('test_data/binding/mhcflurry/output.json','r') as f:
            result = json.load(f)
        with open('test_data/binding/mhcflurry/expected_output.json','r') as f:
            expected_output = json.load(f)
        self.assertEqual(result, expected_output)
    '''

class TestImmunogenicityPrediction(unittest.TestCase):
    #maxDiff = None
    def test_immunogenicity(self):
        cmd="python3 src/tcell_mhci.py  -j test_data/immunogenicity/input.json -o test_data/immunogenicity/output -f json"
        with os.popen(cmd) as process:
            printed_result = process.read()
        with open('test_data/immunogenicity/output.json','r') as f:
            result = json.load(f)
        with open('test_data/immunogenicity/expected_output.json','r') as f:
            expected_output = json.load(f)
        self.assertEqual(result, expected_output)


class TestProcessingPrediction(unittest.TestCase):
    #maxDiff = None

    def test_basic_processing(self):
        cmd = "python3 src/tcell_mhci.py  -j test_data/processing/basic_processing/input.json -o test_data/processing/basic_processing/output -f json --input-ic50 test_data/processing/basic_processing/netmhcpan_ba_result.json"
        with os.popen(cmd) as process:
            printed_result = process.read()
        with open('test_data/processing/basic_processing/output.json','r') as f:
            result = json.load(f)
        with open('test_data/processing/basic_processing/expected_output.json','r') as f:
            expected_output = json.load(f)
        self.assertEqual(result, expected_output)

    def test_netchop(self):
        cmd="python3 src/tcell_mhci.py  -j test_data/processing/netchop/input.json -o test_data/processing/netchop/output -f json"
        with os.popen(cmd) as process:
            printed_result = process.read()
        with open('test_data/processing/netchop/output.json','r') as f:
            result = json.load(f)
        with open('test_data/processing/netchop/expected_output.json','r') as f:
            expected_output = json.load(f)
        self.assertEqual(result, expected_output)

    def test_netctl(self):
        cmd="python3 src/tcell_mhci.py  -j test_data/processing/netctl/input.json -o test_data/processing/netctl/output -f json"
        with os.popen(cmd) as process:
            printed_result = process.read()
        with open('test_data/processing/netctl/output.json','r') as f:
            result = json.load(f)
        with open('test_data/processing/netctl/expected_output.json','r') as f:
            expected_output = json.load(f)
        self.assertEqual(result, expected_output)

    def test_netctlpan(self):
        cmd="python3 src/tcell_mhci.py  -j test_data/processing/netctlpan/input.json -o test_data/processing/netctlpan/output -f json"
        with os.popen(cmd) as process:
            printed_result = process.read()
        with open('test_data/processing/netctlpan/output.json','r') as f:
            result = json.load(f)
        with open('test_data/processing/netctlpan/expected_output.json','r') as f:
            expected_output = json.load(f)
        self.assertEqual(result, expected_output)

class TestSequenceURLJSONPrediction(unittest.TestCase):
    #maxDiff = None

    def test_netctl(self):
        cmd="python3 src/tcell_mhci.py  -j test_data/url/json_netchop_input.json -o test_data/url/json_netchop_output -f json"
        with os.popen(cmd) as process:
            printed_result = process.read()
        with open('test_data/url/json_netchop_output.json','r') as f:
            result = json.load(f)
        with open('test_data/url/json_netchop_expected_output.json','r') as f:
            expected_output = json.load(f)
        self.assertEqual(result, expected_output)

    def test_ann(self):
        cmd="python3 src/tcell_mhci.py  -j test_data/url/binding/ann/input.json -o test_data/url/binding/ann/output -f json"
        with os.popen(cmd) as process:
            printed_result = process.read()
        with open('test_data/url/binding/ann/output.json','r') as f:
            result = json.load(f)
        with open('test_data/url/binding/ann/expected_output.json','r') as f:
            expected_output = json.load(f)
        self.assertEqual(result, expected_output)

    def test_smm(self):
        cmd="python3 src/tcell_mhci.py  -j test_data/url/binding/smm/input.json -o test_data/url/binding/smm/output -f json"
        with os.popen(cmd) as process:
            printed_result = process.read()
        with open('test_data/url/binding/smm/output.json','r') as f:
            result = json.load(f)
        with open('test_data/url/binding/smm/expected_output.json','r') as f:
            expected_output = json.load(f)
        self.assertEqual(result, expected_output)

    def test_smmpmbec(self):
        cmd="python3 src/tcell_mhci.py  -j test_data/url/binding/smmpmbec/input.json -o test_data/url/binding/smmpmbec/output -f json"
        with os.popen(cmd) as process:
            printed_result = process.read()
        with open('test_data/url/binding/smmpmbec/output.json','r') as f:
            result = json.load(f)
        with open('test_data/url/binding/smmpmbec/expected_output.json','r') as f:
            expected_output = json.load(f)
        self.assertEqual(result, expected_output)

    def test_comblib_sidney2008(self):
        cmd="python3 src/tcell_mhci.py  -j test_data/url/binding/comblib_sidney2008/input.json -o test_data/url/binding/comblib_sidney2008/output -f json"
        with os.popen(cmd) as process:
            printed_result = process.read()
        with open('test_data/url/binding/comblib_sidney2008/output.json','r') as f:
            result = json.load(f)
        with open('test_data/url/binding/comblib_sidney2008/expected_output.json','r') as f:
            expected_output = json.load(f)
        self.assertEqual(result, expected_output)

    def test_netmhcpan_el(self):
        cmd="python3 src/tcell_mhci.py  -j test_data/url/binding/netmhcpan_el/input.json -o test_data/url/binding/netmhcpan_el/output -f json"
        with os.popen(cmd) as process:
            printed_result = process.read()
        with open('test_data/url/binding/netmhcpan_el/output.json','r') as f:
            result = json.load(f)
        with open('test_data/url/binding/netmhcpan_el/expected_output.json','r') as f:
            expected_output = json.load(f)
        self.assertEqual(result, expected_output)

    def test_netmhcpan_ba(self):
        cmd="python3 src/tcell_mhci.py  -j test_data/url/binding/netmhcpan_ba/input.json -o test_data/url/binding/netmhcpan_ba/output -f json"
        with os.popen(cmd) as process:
            printed_result = process.read()
        with open('test_data/url/binding/netmhcpan_ba/output.json','r') as f:
            result = json.load(f)
        with open('test_data/url/binding/netmhcpan_ba/expected_output.json','r') as f:
            expected_output = json.load(f)
        self.assertEqual(result, expected_output)


class TestSequenceURLCMDPrediction(unittest.TestCase):
    #maxDiff = None

    def test_ann(self):
        cmd="python3 src/tcell_mhci.py -u https://api-nextgen-tools.iedb.org/api/v1/sequence_list_fasta/fad0774f-e65c-492c-bfde-d3bed50baf2b --method=ann --allele=HLA-A*02:01 --length=9,10"
        with os.popen(cmd) as process:
            printed_result = process.read()
        with open('test_data/url/cmd_ann_expected_output.json','r') as f:
            expected_output = f.read()
        self.assertEqual(printed_result, expected_output)

def test():    
    unittest.main()

def main():
    print( 'run MHCI tests...')
    test()

if __name__ == '__main__':   
    main()

