from __future__ import print_function
import os
from setuptools import setup, find_packages

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

# README file
with open('README.rst', 'r') as rmf:
    README = rmf.read()

setup(
    name = "mhcflurry-2.0-percentile-data",
    version = "1.0.0",
    author = "Jason Yan",
    author_email = "jyan@lji.org",
    packages = ['mhcflurry_2_0_percentile_data'],
    package_data = {
        'mhcflurry_2_0_percentile_data': [
            'mhcflurry_percentile_distribution_2021-03-18.p'
        ],
    },
    test_suite = 'tests',
    description = 'Percentile data for mhci MHCFlurryPredictor 2.0',
    long_description = README,
    classifiers = [
        'Intended Audience :: Developers',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python :: 3',
    ],
)
