# Copyright (c) 2015. Mount Sinai School of Medicine
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import os
import logging
import re
import sys

from setuptools import setup

# normally we would import six.PY2 but can't yet assume that six
# is installed here
PY2 = (sys.version_info.major == 2)

readme_dir = os.path.dirname(__file__)
readme_filename = os.path.join(readme_dir, 'README.md')

try:
    with open(readme_filename, 'r') as f:
        readme = f.read()
except:
    logging.warning("Failed to load %s" % readme_filename)
    readme = ""

try:
    import pypandoc
    readme = pypandoc.convert(readme, to='rst', format='md')
except:
    logging.warning("Conversion of long_description from MD to RST failed")
    pass


# Get all of the  data/ files for use as package data
def recursive_walk(startdir):
    file_list = []
    for dirname, subdirList, fileList in os.walk(startdir, followlinks=True):
        if '.svn' in subdirList:
            subdirList.remove('.svn')
        if '.git' in subdirList:
            subdirList.remove('.git')
        for fname in fileList:
            file_list.append(os.path.join(dirname, fname))
            for sdname in subdirList:
                sdfiles = recursive_walk(sdname)
                file_list.extend(sdfiles)
    return file_list

if __name__ == '__main__':
    required_packages = [
        'numpy==1.16.0',
        'protobuf==3.15.5',
        'six',
        'pandas==1.1.5',
        'appdirs',
        'tensorflow>=2.2.0,<2.3.0',
        'scikit-learn',
        'mhcnames',
        'pyyaml',
        'tqdm',
        'np_utils',
    ]
    #x`os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))
    os.chdir('mhcflurry_2_0_predictor')
    pkg_data_files = recursive_walk('data')
    pkg_data_files.append('downloads.yml')
    os.chdir(os.pardir)
    setup(
        name='mhcflurry-2.0-predictor',
        version='1.0.0',
        description="MHC Binding Predictor",
        author="Tim O'Donnell and Alex Rubinsteyn",
        author_email="timodonnell@gmail.com",
        url="https://github.com/hammerlab/mhcflurry",
        license="http://www.apache.org/licenses/LICENSE-2.0.html",
        classifiers=[
            'Development Status :: 5 - Production/Stable',
            'Environment :: Console',
            'Operating System :: OS Independent',
            'Intended Audience :: Science/Research',
            'License :: OSI Approved :: Apache Software License',
            'Programming Language :: Python',
            'Topic :: Scientific/Engineering :: Bio-Informatics',
        ],
        package_data={
            'mhcflurry_2_0_predictor': pkg_data_files,
        },
        install_requires=required_packages,
        long_description=readme,
        packages=[
            'mhcflurry_2_0_predictor',
        ],
    )
