from setuptools import setup
import os

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

# Load README.rst for use as the package's long description.
with open('README.rst') as readme_file:
    README = readme_file.read()

setup(
    name='mhci-smm-percentile-data',
    version='1.0.0',
    author='Jivan Amara',
    author_email='Development@JivanAmara.net',
    packages=['mhci_smm_percentile_data'],
    test_suite = 'tests',
    description='Provides data for calculating SMM score percentiles.',
    long_description=README,
    include_package_data=True,

    classifiers=[
        'Intended Audience :: Developers',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python :: 3',
    ],
)
