import os
from setuptools import setup

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

with open(os.path.join(os.path.dirname(__file__), 'README.rst')) as readme:
    README = readme.read()

setup(
    name="mhcnp-percentile-data",
    version="1.0.1",
    packages=['mhcnp_percentile_data'],
    package_data={
        'mhcnp_percentile_data': ['mhcnp_percentile_distribution_2024-01-08.p']
    },
    test_suite = 'tests',
    description='PyPA package providing percentile data for MHCNP predictor.',
    long_description=README,
    # Important only if the package will be widely distributed.  See more at:
    #    https://pypi.python.org/pypi?%3Aaction=list_classifiers
    classifiers=[
        'Intended Audience :: Developers',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python :: 3',
    ]
)
