
import unittest
from netctl_1_1_executable import predict as netctl_predict
        
class NetCTLPredictorTest(unittest.TestCase):
    
    def basic_test(self):
        sequence_list = ['>sequence-1\nMSLLTEVETPIRNEWGCRCN\n']
        
        scores = netctl_predict(sequence_list)
        predicted_scores = scores.values()[0]
        
        expected_scores = [
                ('1', 'MSLLTEVET', '0.0189', '0.1283', '0.0495', '-0.6020', '0.1031'), 
                ('2', 'SLLTEVETP', '0.0108', '0.0735', '0.0268', '0.2310', '0.0877'), 
                ('3', 'LLTEVETPI', '0.0139', '0.0943', '0.9894', '0.5760', '0.2220'), 
                ('4', 'LTEVETPIR', '0.0396', '0.2691', '0.4982', '1.3710', '0.3874'), 
                ('5', 'TEVETPIRN', '0.0107', '0.0725', '0.0434', '-1.3460', '0.0096'), 
                ('6', 'EVETPIRNE', '0.0161', '0.1091', '0.0111', '-1.7650', '0.0220'), 
                ('7', 'VETPIRNEW', '0.0135', '0.0916', '0.9978', '0.6080', '0.2218'), 
                ('8', 'ETPIRNEWG', '0.0146', '0.0991', '0.0417', '-1.5890', '0.0239'), 
                ('9', 'TPIRNEWGC', '0.0106', '0.0719', '0.0563', '-0.4090', '0.0571'), 
                ('10', 'PIRNEWGCR', '0.0121', '0.0822', '0.5720', '1.1920', '0.1990'), 
                ('11', 'IRNEWGCRC', '0.0115', '0.0784', '0.3724', '0.0050', '0.1159'), 
                ('12', 'RNEWGCRCN', '0.0116', '0.0785', '0.0404', '-1.3590', '0.0146')
            ]
        
        self.assertEqual(predicted_scores, expected_scores)
            

if __name__ == "__main__":
    unittest.main()
