import unittest
import sys
import math
from pathlib import Path
PROJECT_DIR = str(Path(__file__).resolve().parents[1])
sys.path.insert(1, PROJECT_DIR)
from allele_validator import Allele_Validator


class TestAlleleInfo(unittest.TestCase) :
    def test_allele_info(self):
        validator = Allele_Validator()
        result = validator.get_allele_info("BoLA-1*009:01")
        expected_result = \
        {
            'BoLA-1*009:01': {
                'MRO ID': 'MRO:0036770', 
                'Tool Group': 'mhci', 
                'Synonyms': 'BoLA-1:00901|BoLA-N:00901', 
                'In Taxon': 'cattle', 
                'Predictor Availability': 1
                },
        }

        self.assertEqual(result["BoLA-1*009:01"]["MRO ID"], expected_result["BoLA-1*009:01"]["MRO ID"])
        self.assertEqual(result["BoLA-1*009:01"]["Tool Group"], expected_result["BoLA-1*009:01"]["Tool Group"])
        # self.assertEqual(result["BoLA-1*009:01"]["Synonyms"], expected_result["BoLA-1*009:01"]["Synonyms"])
        self.assertEqual(result["BoLA-1*009:01"]["In Taxon"], expected_result["BoLA-1*009:01"]["In Taxon"])
        self.assertEqual(
            result["BoLA-1*009:01"]["Predictor Availability"], 
            expected_result["BoLA-1*009:01"]["Predictor Availability"]
        )

if __name__=="__main__" :
    unittest.main()