from netctl_1_1_executable import predict as netctl_predict

def netctl_test(input_fasta_list, input_params):
    # scores is an ordered dictionary of input name(key) and tuples of prediction scores(value)
    tap_weight = input_params['tap_weight']
    mhc_weight = input_params['mhc_weight']
    cleavage_weight = input_params['cleavage_weight']
    supertype = input_params['supertype']
    sort_output = input_params['sort_output']
    threshold = input_params['threshold']
    
    scores = netctl_predict(input_fasta_list, tap_weight=tap_weight, mhc_weight=mhc_weight, cleavage_weight=cleavage_weight, supertype=supertype, sort_output=sort_output, threshold=threshold)
    for i, key in enumerate(scores.keys(), start=1):
        print("key {}: {}\nvalue {}: {}".format(i, key, i, scores[key]))


if __name__ == '__main__':
    """
    Optional named input parameters:
    tap_weight(default='0.050000'), mhc_weight(default='1.000000'), cleavage_weight(default='0.100000'),   
    supertype(default='A1'), sort_output(default='-1') and threshold(default='0.750000')
    """
    input_fasta_list = [">test1\nMSLLTEVETPIRNEWGCRCN\n>test2\nDSHTVSSFQVDCFLWHVRKQVADQDLGDAPFLDRLRRDQKSLKGRG"]
    
    input_params = {
        'tap_weight':'0.050000',
        'mhc_weight':'1.000000',
        'cleavage_weight':'0.100000',
        'supertype':'A1',
        'sort_output':'-1',
        'threshold':'0.750000',
    }
    netctl_test(input_fasta_list, input_params)
