#!/bin/bash

#################################################################################################################
# Pull down latest molecule_export.tsv and save it as mro_molecules.tsv
#################################################################################################################
BASE_URL="https://api.github.com/repos/IEDB/MRO/releases/latest"

# Extracting out URL to the IEDB zip file
MRO_URL=$(curl -H "Accept: application/vnd.github.v3+json" -s $BASE_URL | \
        python3 -c "import sys, json; data=json.load(sys.stdin); print(data['assets'][0]['browser_download_url'])")

# Download & extract only the molecule_export.tsv file
curl -L -o iedb.zip $MRO_URL 
unzip -p iedb.zip molecule_export.tsv > ./data/mro_molecules.tsv
rm -rf iedb.zip