'''
Unit tests for smm_predictor
'''
import unittest
from mhci_comblib_predictor import single_prediction_comblib_peptides

class MHCIComblibTests(unittest.TestCase):
        
    def test_basic(self):
        allele_name = 'HLA-A*02:01'
        length = '9'
        peptide_list = ['CSANNSHHY','LTDLGLLYT', 'FSDQIEQEA', 'QSSINISGY','LRDLMGVPY']

        result = single_prediction_comblib_peptides(allele_name, length, peptide_list)
        expected_result = (0.004861832584649842, 0.0009616122783836639, 3.241902878227871e-05, 0.002629056987587087, 0.0002468311689697346)

        self.assertEqual(result, expected_result)



if __name__ == '__main__':
    unittest.main()
