'''
Created on Oct 2, 2019
@author: Yan
The code coverage by tests is 100%. (__init__.py)  
'''
from unittest import TestCase
import unittest

from mhci_smm_percentile_data import score_distributions
'''
Name                                                                                                        Stmts   Miss  Cover
-------------------------------------------------------------------------------------------------------------------------------
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/__init__.py                         1607    988    39%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/__init__.py                    0      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/__about__.py        10      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/__init__.py          3      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/_compat.py          12      1    92%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/_structures.py      41     17    59%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/specifiers.py      281    201    28%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/version.py         150     78    48%
mhci_smm_percentile_data/__init__.py                                                                            7      0   100%
tests.py                                                                                                       25      0   100%
-------------------------------------------------------------------------------------------------------------------------------
TOTAL                                                                                                        2136   1285    40%
'''	
class GetModleDataTests(TestCase):

    def test_H2(self):
        distribution = score_distributions[('smm', 'H-2-Db', 9)]
        expected_distribution = [32.0346512248, 124.342615973, 195.263019117, 303.82254687, 373.783391283, 441.184249995, 569.665606808, 707.326615249, 786.357439723, 842.59717748, 976.382529624, 1078.0030758, 1206.75748155, 1281.20905678, 1391.93834849, 1447.50475819, 1533.27480732, 1620.39166282, 1793.16395343, 1993.51725925, 2082.6677881, 2165.80823157, 2226.48616067, 2385.722904, 2556.34814858, 2670.66859819, 2758.16345579, 2881.50913018, 3010.37085017, 3123.3452992, 3188.74653721, 3385.47803159, 3536.87735133, 3610.937737, 3798.56882808, 3887.04886247, 3950.20832561, 4126.8625079, 4232.7244806, 4473.21734277, 4566.88420444, 4684.03358125, 4782.11482611, 4859.8179412, 5030.60247332, 5112.34318786, 5328.68440975, 5592.68037693, 5762.62023645, 5910.44254577, 6034.20416117, 6090.03796483, 6217.56021558, 6304.05509408, 6495.61087144, 6723.88071136, 6912.25895794, 7089.57171496, 7155.17071437, 7372.58859348, 7614.1249599, 7720.04798926, 7972.96761394, 8083.88264188, 8177.48959118, 8291.24980324, 8425.9717748, 8503.93633172, 8602.4072735, 8742.18514724, 8904.71450375, 9133.13758349, 9345.87568672, 9497.73395037, 9696.61159568, 9922.47469473, 10153.5988212, 10294.849451, 10583.2730224, 10854.7543615, 11056.559312, 11210.3713735, 11314.0996627, 11471.4944674, 11631.0788519, 11792.8832764, 11929.4384289, 12151.223248, 12320.2636017, 12520.4517811, 12665.4317798, 12900.8997369, 13201.4002949, 13385.0500666, 13602.5396342, 13791.7698101, 14048.1779546, 14243.607577, 14441.7558963, 14642.6607333, 14914.8881211, 17203.6262933, 19391.8837948, 21508.9891257, 24022.5994514, 26645.2623087, 29827.7160432, 33390.2753161, 36276.0506831, 39593.1449625, 43015.0072069, 46948.3139382, 51123.4318786, 55541.8063602, 60064.7951143, 66011.5605749, 70895.7171496, 76492.7016387, 82341.7324106, 87825.3724045, 94323.5200974, 101535.988212, 108048.812954, 116310.788519, 125493.144033, 133235.513479, 141130.213978, 149148.881211, 160184.319283, 168896.24726, 178903.979078, 189504.706288, 201196.304734, 214595.198235, 227834.768562, 243567.870988, 255634.814858, 270159.348307, 287488.184309, 305928.544154, 322567.048188, 343257.472239, 366961.075527, 388704.886247, 412686.25079, 437139.448478, 463041.589223, 490478.528296, 518346.296597, 550325.960187, 586975.534548, 621756.021558, 657082.650041, 699229.914438, 738958.416544, 791808.209094, 836796.77931, 886380.1057, 945409.582676, 1003737.15366, 1060766.99864, 1126211.60967, 1212327.621, 1275322.43588, 1350890.041, 1460898.35481, 1561780.51426, 1673477.97157, 1784925.11344, 1934728.36997, 2092280.94583, 2226486.16067, 2402259.94514, 2609876.75899, 2828915.66135, 3101844.3414, 3440487.62434, 3772419.66419, 4193918.62931, 4684033.58125, 5147780.2579, 5842786.26942, 6570826.50041, 7475151.51728, 8925241.9907, 10632123.1911, 12753224.3588, 16316236.8123, 23912225.6328, 38337165.527]
        self.assertEqual(distribution, expected_distribution)

    def test_HLA(self):
        distribution = score_distributions[('smm', 'HLA-A02:01', 9)]
        expected_distribution = [2.04225515046, 8.41608280867, 13.9994186105, 20.8022350846, 30.0683779117, 35.7363341235, 42.767119486, 49.5575696483, 53.4699773337, 56.378043451, 59.5813034542, 66.851322007, 73.1324293033, 85.528331534, 93.3490709454, 102.591174075, 106.93256884, 118.33412396, 124.769949699, 132.773070857, 140.640369908, 147.268546339, 165.618939722, 173.424319881, 181.597556274, 190.15598543, 201.887764906, 210.431136143, 220.856405692, 231.798168413, 241.051589735, 251.831469671, 264.30781229, 277.402263223, 287.150779794, 297.927093661, 319.234632411, 335.8226621, 346.824684597, 364.846345097, 394.557224595, 411.253872088, 424.727127062, 445.769140452, 456.152437599, 477.650239673, 496.718116449, 505.952795705, 533.469997984, 557.326893242, 568.997030643, 583.59290051, 605.494217549, 615.332707125, 631.117176348, 644.33244418, 657.824432897, 671.598936892, 688.826743292, 703.250419661, 729.642293834, 751.813292454, 760.518880085, 778.233640489, 809.300856471, 833.892369769, 849.395586411, 873.192506387, 905.962037856, 922.805129664, 942.128192642, 970.755813375, 1004.87027597, 1025.91174075, 1059.52205156, 1089.20593723, 1127.48299382, 1153.74544649, 1167.10518912, 1197.04368536, 1216.49408055, 1253.4586162, 1282.65541807, 1303.49689202, 1324.67701268, 1355.53270411, 1403.16906033, 1425.96872344, 1459.18380191, 1476.080354, 1503.52273666, 1535.00572651, 1570.76060305, 1585.29467196, 1618.48992392, 1644.7882696, 1679.22928678, 1706.51456772, 1734.24319881, 1782.83027329, 1799.3265987, 2178.26142204, 2588.86855203, 3098.20392644, 3656.87402784, 4169.74983338, 4831.81168776, 5458.96110529, 6354.91871621, 7163.24821112, 7963.61030669, 9080.50496043, 10141.6822616, 11300.8211055, 12592.443183, 14424.8066305, 16110.536382, 17502.8995356, 19235.7887966, 21237.8231473, 23502.2802147, 25948.365104, 28190.9687399, 30839.6897244, 33582.26621, 36992.1863338, 40374.7642981, 44168.2304407, 49103.2231188, 52979.7616349, 57162.3401605, 63695.6831682, 69041.465293, 74835.9024145, 81116.6487622, 88127.2057171, 94212.8192642, 102119.810446, 110945.578748, 119154.376921, 130349.689202, 143255.069601, 156714.795391, 168310.031007, 181179.893484, 198202.897918, 213850.367045, 232332.518377, 252993.870921, 274859.023987, 295876.177974, 317767.882508, 351649.496567, 377667.836168, 412201.910174, 444743.899879, 482069.882925, 521326.738294, 567688.373787, 609691.302957, 665441.680829, 727964.163126, 780027.65431, 845492.968188, 927064.60461, 1025911.74075, 1122302.68002, 1236260.51925, 1371229.03305, 1493172.55894, 1648579.89815, 1786940.12152, 1972922.38322, 2188315.81993, 2455330.73381, 2754926.39475, 3155803.83791, 3549032.69298, 4093643.32183, 4743621.18551, 5509472.2505, 6267725.96265, 7397926.29233, 9059620.37856, 10992842.3568, 13555327.0411, 18625588.3395, 24837621.2373, 38824869.0859, 69200622.3077]
        self.assertEqual(distribution, expected_distribution)

    def test_Mamu(self):
        distribution = score_distributions[('smm', 'Mamu-A2201', 9)]
        expected_distribution = [5.16511505445, 31.8478412661, 79.0824289801, 116.166258029, 213.835595295, 274.840038054, 347.600185867, 406.518205689, 468.899748716, 509.424701913, 593.034555521, 666.929610874, 711.344536091, 763.976500289, 818.615568807, 871.124042156, 918.501775181, 977.417251285, 1014.09817232, 1099.20830244, 1180.53807877, 1230.49541557, 1285.5234403, 1339.92348772, 1364.83452525, 1439.06363916, 1479.3808751, 1570.6521025, 1622.10887334, 1667.55435913, 1746.14377487, 1795.06425944, 1849.60929822, 1905.81174913, 1963.72197448, 2051.54005166, 2080.07981668, 2188.16466165, 2307.17214639, 2415.90581976, 2495.0542906, 2594.65727163, 2673.49883999, 2754.73609775, 2805.95046553, 2891.21241432, 2965.37758195, 3048.45648435, 3126.65526526, 3258.96727869, 3327.20837093, 3444.13368207, 3548.78754295, 3631.4494238, 3724.6030966, 3873.28986987, 3936.22576736, 4009.40566807, 4121.73437258, 4237.21011156, 4345.90271285, 4436.9036719, 4519.39186983, 4592.82608028, 4656.7186555, 4787.18267365, 4887.42380725, 4989.76393843, 5082.53057611, 5177.02187435, 5285.42603954, 5371.30730395, 5458.58402664, 5572.88395794, 5742.22228109, 5957.71878657, 6124.63201225, 6252.87864449, 6398.52689849, 6487.53927432, 6669.29610874, 6856.14509681, 7064.47674749, 7146.27953286, 7295.9189367, 7397.41527934, 7552.31333606, 7639.76500289, 7835.73969132, 7926.47328067, 8073.83742133, 8357.56956173, 8552.24236502, 8731.32190469, 8832.42584731, 8996.6329037, 9248.68525326, 9355.77998112, 9507.79917659, 9706.88758255, 9887.35209639, 11805.3807877, 13679.8079376, 15419.8447083, 17663.6316684, 19864.6080326, 22084.1149999, 24721.7949537, 27738.3101615, 30414.4522899, 33579.9465094, 37246.030966, 41503.0487034, 45612.0928793, 49213.0181062, 53220.6286259, 57422.2228109, 62098.3413067, 66846.7042408, 72623.9723415, 77639.0119803, 83575.6956173, 88936.4929844, 94206.311498, 102348.150718, 109415.789904, 115899.083049, 124188.104947, 131546.712788, 139984.515983, 148963.545343, 157427.282953, 166755.435913, 175824.746528, 186243.017738, 196824.882115, 210901.660937, 222371.947719, 233926.810808, 248359.055745, 263075.254979, 278663.443839, 295175.290957, 311228.958923, 328155.736066, 344413.368207, 359815.609536, 375906.642474, 394529.970488, 415030.487034, 436596.248834, 456120.928793, 484261.563645, 508253.057611, 532206.286259, 563741.491282, 591670.613893, 619555.19085, 656266.143861, 696754.849277, 731273.776685, 776390.119803, 824289.940847, 877162.385545, 922741.386745, 968456.236063, 1030575.94206, 1081633.17714, 1143088.88015, 1222024.74471, 1294434.26309, 1396625.60531, 1496511.29827, 1614655.96005, 1738120.97298, 1901428.50374, 2065760.64794, 2275516.55781, 2495054.2906, 2773831.01615, 3126655.26526, 3524357.86134, 3945299.70488, 4550718.79768, 5285426.03954, 6238497.42268, 7657376.48008, 9819288.04332, 13616954.9294, 22494689.3516]
        self.assertEqual(distribution, expected_distribution)

    def test_SLA(self):
        distribution = score_distributions[('smm', 'SLA-10401', 9)]
        expected_distribution = [3.10842218582, 5.4392622687, 6.89509096381, 7.56031690224, 8.50236999303, 9.15250553091, 10.4361424873, 11.6826132575, 12.489354705, 13.0478813853, 14.3396978347, 16.0524009937, 17.2798512649, 18.177744716, 18.7732731865, 19.9774475906, 20.5844847192, 21.7040109569, 22.5704386735, 23.2562667414, 24.1846607663, 24.8622254324, 25.6767468879, 26.4569636114, 27.1981897915, 28.2188947675, 29.2105678709, 30.2370905158, 31.5166464588, 31.9550866848, 32.6994162723, 33.538219287, 34.7168249793, 35.6894618979, 36.6893485024, 37.5439532139, 38.5070279329, 39.3133452169, 40.1365463686, 40.8827404773, 41.8350218356, 42.9081707305, 44.1102988337, 45.6604303076, 46.5093210862, 47.3739939226, 48.8135058078, 50.0656662588, 51.5869676237, 52.5460409574, 54.8959114282, 56.3040972996, 57.4830760277, 58.8220288739, 60.7491212295, 61.5942256881, 62.8839769734, 65.0938561737, 66.610086863, 68.4762549148, 69.910112339, 71.0460602829, 72.3669051594, 74.2232556736, 75.4292865589, 76.3027165324, 77.3641930549, 78.9841593149, 80.638046832, 81.7598338066, 82.7065680624, 83.6642649843, 85.6130560628, 86.6044085295, 88.2145046957, 89.0307434579, 90.4773766644, 91.5250553091, 93.872849278, 95.1787506945, 96.0594288316, 96.9482557832, 97.8453069493, 99.89413716, 100.818446231, 101.751307828, 102.220970526, 103.643005877, 104.843135323, 105.569873218, 106.792314737, 107.532563698, 108.277943821, 109.279827299, 111.05548165, 113.120157205, 114.166845133, 114.958211897, 116.021907135, 117.365377502, 118.178915434, 130.478813853, 142.738129079, 152.946660901, 162.757121359, 173.996294717, 184.73109307, 197.033467339, 210.155132016, 220.56672765, 230.430520063, 242.962920884, 254.413410575, 266.40354522, 277.677058435, 288.097838547, 300.981637044, 312.277001073, 323.996262219, 333.073438093, 344.778360371, 354.437773703, 366.049653425, 377.172482281, 390.42714052, 402.290706636, 412.610238174, 425.147862567, 436.053724183, 451.37759684, 464.02352616, 478.123400914, 494.925693162, 507.621490543, 519.445514004, 533.998454385, 547.696543355, 560.454034711, 573.508686216, 586.867419617, 601.921699384, 615.942256881, 637.587802337, 656.961622091, 673.813953171, 695.889045499, 713.739939973, 733.736290916, 756.031690224, 780.800351196, 798.987527749, 825.163482344, 842.441979639, 862.064974168, 892.359805178, 919.475157696, 938.72849278, 969.482557832, 1003.55227547, 1029.29532443, 1065.46699229, 1100.37318874, 1139.04268675, 1176.35932639, 1217.69914192, 1266.30989359, 1313.83249783, 1366.28090902, 1424.09840492, 1484.36258862, 1547.17699765, 1612.64955101, 1696.4458435, 1776.39687295, 1864.40388829, 1983.99238087, 2116.11857799, 2257.04386735, 2429.62920884, 2597.40696041, 2802.46372623, 3051.68708697, 3424.04922833, 3833.01042105, 4421.19835742, 5206.42959582, 6159.42256881, 7422.32556736, 9215.94766841, 13198.968731]
        self.assertEqual(distribution, expected_distribution)

    def test_key_error(self):
        with self.assertRaises(KeyError):
            distribution = score_distributions[('ann', 'SLA-1*0401', 9)]


if __name__ == '__main__':
    unittest.main()
