'''
Created on Dec 21, 2023
@author: Yan
'''
from unittest import TestCase
import unittest

from mhcnp_percentile_data import score_distributions

class GetModleDataTests(TestCase):

    def test_H2(self):
        distribution = score_distributions[('mhcnp', 'H2-Db', 9)]    
        expected_distribution = [2.7199e-06, 7.3841e-06, 4.32695e-05, 5.16381e-05, 5.6645e-05, 6.00707e-05, 6.142e-05, 8.67669e-05, 9.19798e-05, 0.00010595, 0.000122347, 0.0001429601, 0.0001440471, 0.0001460026, 0.0001506622, 0.0001507943, 0.0001515836, 0.0001577038, 0.000167168, 0.0001683555, 0.0001769042, 0.0002091103, 0.0002098548, 0.0002143277, 0.0002337953, 0.0002409482, 0.000246891, 0.0002501493, 0.0002545196, 0.0002649189, 0.0002656557, 0.00030094, 0.0003365652, 0.00033679, 0.0003451515, 0.0003475636, 0.0003507066, 0.0003507386, 0.0003568893, 0.0003689583, 0.0003699954, 0.0003741103, 0.000374469, 0.0003768739, 0.0003895771, 0.0003899226, 0.0004109366, 0.0004136086, 0.0004243427, 0.0004416449, 0.0004549335, 0.0004727486, 0.0004787266, 0.0004916046, 0.0004967763, 0.0005062391, 0.0005113973, 0.0005272938, 0.0005384077, 0.0005584299, 0.0005607594, 0.0005760302, 0.0005859827, 0.0005895918, 0.0005923513, 0.0006005306, 0.0006026845, 0.000605625, 0.000605861, 0.0006077567, 0.0006322802, 0.0006528232, 0.0006639413, 0.0006676934, 0.0006758917, 0.0006781824, 0.000678315, 0.0007202756, 0.0007223153, 0.0007449756, 0.0007502105, 0.0007564148, 0.0007641827, 0.0007712108, 0.0007725997, 0.0007821588, 0.0007841272, 0.0007861933, 0.0007994962, 0.000814364, 0.000829774, 0.0008358723, 0.0008396338, 0.0008745584, 0.0008779739, 0.0008813332, 0.0008915861, 0.000912021, 0.0009157127, 0.000931216, 0.000939523, 0.0009997196, 0.0010494299, 0.0011737204, 0.0013481243, 0.0014235542, 0.0015617351, 0.0016380142, 0.0018295799, 0.0019256581, 0.0020322406, 0.0021409144, 0.0021793423, 0.0022416626, 0.0023002307, 0.00236464, 0.0024180841, 0.0025047203, 0.0025681517, 0.0026254376, 0.0027389673, 0.0028642045, 0.0029523675, 0.0030719509, 0.0031331312, 0.0032810678, 0.0033478373, 0.0034757129, 0.0035659807, 0.0036703498, 0.003734693, 0.0039240833, 0.003990542, 0.0041019363, 0.0042586237, 0.0043446912, 0.0044261418, 0.0044941764, 0.0046311313, 0.0047807001, 0.0048543039, 0.0049479431, 0.0050194641, 0.0051046719, 0.0052319755, 0.0053255873, 0.0054541336, 0.0055287065, 0.0055974924, 0.0057500375, 0.0058358473, 0.0059485929, 0.0060365907, 0.0060699322, 0.0061654218, 0.0062527625, 0.00633335, 0.0064360349, 0.0065041051, 0.0066145851, 0.0067233193, 0.0067807586, 0.0069176328, 0.0069801402, 0.0070557715, 0.0071784299, 0.0072711346, 0.007357306, 0.007451604, 0.0076395076, 0.0077595246, 0.0079424151, 0.0080943773, 0.0082314598, 0.0083366603, 0.008413972, 0.0085138654, 0.0085610025, 0.0086799084, 0.0088049485, 0.0089518999, 0.0090090903, 0.009152967, 0.0092705845, 0.0093694053, 0.0094728284, 0.0095888294, 0.0096420329, 0.0097559451, 0.0098652665, 0.0100196511, 0.011139301, 0.012407731, 0.0133630635, 0.0143443194, 0.0154588069, 0.0165428862, 0.0178103692, 0.0190327691, 0.0204393737, 0.0218087273, 0.0231230549, 0.0245393958, 0.025579241, 0.0271875239, 0.0289324579, 0.0302700799, 0.0318102616, 0.0335732343, 0.0352429162, 0.0368221036, 0.0384753105, 0.0405158907, 0.0422925269, 0.0443095181, 0.0463525526, 0.0481100411, 0.050050262, 0.0522047537, 0.0546935819, 0.0569306701, 0.0590761804, 0.0612253233, 0.0634257821, 0.0661917045, 0.0688475432, 0.0712483739, 0.0741229163, 0.0763476983, 0.0789075406, 0.0825640014, 0.0851822305, 0.0886882965, 0.0917944933, 0.0954674274, 0.0987949824, 0.1024556369, 0.1059638763, 0.1095254934, 0.1128862942, 0.1163816174, 0.1205594707, 0.1255528133, 0.1296023992, 0.1342362498, 0.1399040998, 0.1453851236, 0.1507549424, 0.1565761667, 0.163307527, 0.169630435, 0.1757594896, 0.1817226731, 0.1899943472, 0.1972485933, 0.2059148938, 0.2133511078, 0.2217372148, 0.2313753751, 0.2424888384, 0.2511383653, 0.2615772668, 0.2725788841, 0.2844812191, 0.2969578349, 0.3077745958, 0.320850715, 0.3357721569, 0.3497683506, 0.3684023811, 0.3844711351, 0.4006203733, 0.425032092, 0.452141318, 0.4768588733, 0.5043522573, 0.5407986206, 0.5851093388, 0.6409705297, 0.6996746742]
        self.assertEqual(distribution, expected_distribution, distribution)

    def test_HLA(self):
        distribution = score_distributions[('mhcnp', 'HLA-A*02:01', 9)]
        expected_distribution = [5.47e-08, 9.95e-08, 1.134e-07, 1.214e-07, 1.25e-07, 1.253e-07, 1.385e-07, 1.71e-07, 1.876e-07, 2.092e-07, 2.95e-07, 3.317e-07, 3.599e-07, 3.825e-07, 3.976e-07, 4.113e-07, 5.081e-07, 5.101e-07, 5.182e-07, 5.193e-07, 5.234e-07, 5.241e-07, 5.377e-07, 5.893e-07, 6.037e-07, 6.138e-07, 6.291e-07, 6.327e-07, 6.799e-07, 6.891e-07, 7.085e-07, 7.299e-07, 7.362e-07, 7.512e-07, 7.804e-07, 7.897e-07, 8.323e-07, 8.86e-07, 9.226e-07, 9.526e-07, 9.589e-07, 9.682e-07, 9.991e-07, 1.0391e-06, 1.1143e-06, 1.1458e-06, 1.1578e-06, 1.1739e-06, 1.1986e-06, 1.2109e-06, 1.2388e-06, 1.2722e-06, 1.2911e-06, 1.3145e-06, 1.3153e-06, 1.3237e-06, 1.328e-06, 1.3745e-06, 1.3769e-06, 1.4004e-06, 1.4259e-06, 1.4563e-06, 1.4883e-06, 1.491e-06, 1.4997e-06, 1.5171e-06, 1.5631e-06, 1.6363e-06, 1.6428e-06, 1.6542e-06, 1.677e-06, 1.6872e-06, 1.7339e-06, 1.7405e-06, 1.7569e-06, 1.7911e-06, 1.8085e-06, 1.8198e-06, 1.8282e-06, 1.8536e-06, 1.857e-06, 1.8609e-06, 1.9801e-06, 2.0093e-06, 2.0507e-06, 2.0533e-06, 2.0628e-06, 2.0933e-06, 2.1099e-06, 2.1327e-06, 2.1329e-06, 2.1393e-06, 2.1518e-06, 2.2264e-06, 2.2306e-06, 2.2476e-06, 2.261e-06, 2.2926e-06, 2.3314e-06, 2.3595e-06, 2.385e-06, 2.7393e-06, 3.26e-06, 3.7939e-06, 4.1146e-06, 4.3518e-06, 4.642e-06, 5.1893e-06, 5.6517e-06, 6.0833e-06, 6.4016e-06, 6.8363e-06, 7.191e-06, 7.6542e-06, 7.9818e-06, 8.2012e-06, 8.4355e-06, 8.6769e-06, 9.0919e-06, 9.2936e-06, 9.7457e-06, 1.0164e-05, 1.04356e-05, 1.09252e-05, 1.13466e-05, 1.18638e-05, 1.23773e-05, 1.28268e-05, 1.32697e-05, 1.41251e-05, 1.46887e-05, 1.50974e-05, 1.57764e-05, 1.63479e-05, 1.70298e-05, 1.73339e-05, 1.80023e-05, 1.87143e-05, 1.90219e-05, 1.97352e-05, 2.03487e-05, 2.10393e-05, 2.1394e-05, 2.17798e-05, 2.22602e-05, 2.24937e-05, 2.2873e-05, 2.34548e-05, 2.40644e-05, 2.48267e-05, 2.55206e-05, 2.60153e-05, 2.6583e-05, 2.68648e-05, 2.72401e-05, 2.79464e-05, 2.86864e-05, 2.94477e-05, 2.97956e-05, 3.02204e-05, 3.09234e-05, 3.17869e-05, 3.24862e-05, 3.35037e-05, 3.41673e-05, 3.51321e-05, 3.56257e-05, 3.67518e-05, 3.74985e-05, 3.81193e-05, 3.87095e-05, 3.91652e-05, 3.99839e-05, 4.05731e-05, 4.12716e-05, 4.2929e-05, 4.39736e-05, 4.48139e-05, 4.59244e-05, 4.64959e-05, 4.70883e-05, 4.77474e-05, 4.88839e-05, 4.99619e-05, 5.07718e-05, 5.15508e-05, 5.17627e-05, 5.28485e-05, 5.38479e-05, 5.45482e-05, 5.54279e-05, 6.51815e-05, 7.64356e-05, 8.81238e-05, 9.95511e-05, 0.0001146836, 0.0001283884, 0.0001441072, 0.0001622942, 0.0001747273, 0.0001913815, 0.000211064, 0.000231415, 0.0002562489, 0.0002857843, 0.0003111263, 0.0003404773, 0.0003723266, 0.0003989932, 0.0004365275, 0.0004734658, 0.0005146365, 0.0005592759, 0.000607366, 0.0006541881, 0.0006975315, 0.0007499279, 0.0008094576, 0.0008667188, 0.0009282783, 0.0009989341, 0.0010880181, 0.0011765124, 0.0012594702, 0.0013301374, 0.0014274954, 0.001523523, 0.0016350823, 0.0017465221, 0.0018875993, 0.0020236412, 0.0021775364, 0.0023226694, 0.0025023441, 0.0027199077, 0.0029236832, 0.0031317869, 0.0033919619, 0.003659885, 0.0039086151, 0.0042025203, 0.0045158913, 0.0048400523, 0.0052389698, 0.0055463959, 0.005977405, 0.0064146054, 0.0069305253, 0.0074856585, 0.0079195761, 0.0084997007, 0.0092180763, 0.0100423642, 0.0108862744, 0.0117868377, 0.0128036681, 0.0140406934, 0.0154805186, 0.0167847082, 0.0179691544, 0.0199652563, 0.0223714581, 0.0246634303, 0.0273985035, 0.0305066928, 0.0335866488, 0.0372923249, 0.042373319, 0.0474181867, 0.0532486797, 0.0608085185, 0.0691621882, 0.0795697581, 0.0927069144, 0.1061620076, 0.1273339712, 0.1529357589, 0.1814586452, 0.2419414412, 0.3419404126]
        self.assertEqual(distribution, expected_distribution, distribution)

    def test_key_error(self):
        with self.assertRaises(KeyError):
            distribution = score_distributions[('ann', 'SLA-1*0401', 9)]


if __name__ == '__main__':
    unittest.main()
