#! /usr/bin/env python3

from __future__ import print_function
from distutils.spawn import find_executable
from shutil import copy2

import sys
import os
import importlib

# adding all packages in method folder to the python path
script_dir = os.path.dirname(os.path.realpath(__file__))
sys.path.append(script_dir )
methods_dir = os.path.abspath(os.path.join(script_dir, '../method'))

for method_dir_name in os.listdir(methods_dir):
    method_base_dir = os.path.join(methods_dir, method_dir_name)
    if os.path.isdir(method_base_dir):
        sys.path.append(method_base_dir)

class Configure(object):

    def __init__(self, version="0.1.0"):
        self.version = version
        self.project_dir = os.path.abspath(".")
        self.src = os.path.join(self.project_dir, "src")
        self.method = os.path.join(self.project_dir, "method")

    def check_prerequisites(self):
        prerequisites = ["tcsh", "gawk"]
        for prereq in prerequisites:
            executable = find_executable(prereq)
            if not executable:
                print("# prerequisite: '{}' is not found in your path.  Please install and then rerun the configure script".format(prereq))
                sys.exit(1)
        # if we get here, all prerequisites have been found
        print("All prerequisites found!")

    def check_path_depth(self):
        ctl_loc_origin = importlib.util.find_spec('netctl_1_1_executable').origin
        ctl_loc = os.path.dirname(os.path.dirname(ctl_loc_origin))
        # give warnings (path length > 50 doesn't give result)
        if len(ctl_loc) > 50:
            print("# NetCTL will not work if installed in the current path (%s).  Please choose a path that is less than 50 characters long if NetCTL method is required." % ctl_loc)


if __name__ == "__main__":
    config = Configure()
    config.check_prerequisites()
    config.check_path_depth()
    print("IEDB T cell class I tools successfully installed!")
    print("Use the command 'python3 src/tcell_mhci.py' to get started")
