import sys
import unittest
from pathlib import Path
PROJECT_DIR = str(Path(__file__).resolve().parents[1])
sys.path.insert(1, PROJECT_DIR)
from allele_validator import AlleleValidator

class TestValidAlleles(unittest.TestCase):
    def test_validate_alleles(self):
        validator = AlleleValidator()
        
        '''True Case: Simple + Input/Return type agreement'''
        iedb_label = 'HLA-A*02:01'
        result = validator.validate_alleles(iedb_label, method='icerfire', tools_group='pvc')
        expected_result = True
        self.assertEqual(expected_result, result)

        iedb_label = ['HLA-A*02:01']
        result = validator.validate_alleles(iedb_label, method='icerfire', tools_group='pvc')
        expected_result = [True]
        self.assertEqual(expected_result, result)

        iedb_label = 'HLA-A*02:01'
        expected_result = True
        result = validator.validate_alleles(iedb_label, 'netmhcpan_el')
        self.assertEqual(expected_result, result)

        iedb_label = 'HLA-A*02:01'
        expected_result = True
        result = validator.validate_alleles(iedb_label, 'netmhcpan_ba')
        self.assertEqual(expected_result, result)

        iedb_label = "BoLA-1*009:01"
        expected_result = True
        result = validator.validate_alleles(iedb_label)
        self.assertEqual(expected_result, result)

        '''False Case: Simple'''
        iedb_label = ['HLA-A*02:0111']
        result = validator.validate_alleles(iedb_label, method='icerfire', tools_group='pvc')
        expected_result = [False]
        self.assertEqual(expected_result, result)

        '''False Case: Input/Return type mismatch'''
        iedb_label = ['HLA-A*02:01']
        result = validator.validate_alleles(iedb_label, method='icerfire', tools_group='pvc')
        expected_result = True
        self.assertNotEqual(expected_result, result)

        iedb_label = 'HLA-A*02:01'
        result = validator.validate_alleles(iedb_label, method='icerfire', tools_group='pvc')
        expected_result = [True]
        self.assertNotEqual(expected_result, result)
    
        '''Multiple alleles'''
        iedb_label = ["BoLA-1*009:01", "BoLA-1*021:01", "BoLA-1:00901"]
        expected_result = [True, True, False]
        result = validator.validate_alleles(iedb_label)
        self.assertCountEqual(expected_result, result)


if __name__ == "__main__":
    unittest.main()