import pkg_resources
import pickle

package_name = 'mhcii_comblib_percentile_data'
pickle_filename = 'comblib_percentile_distribution_2018-11-26.p'
pickle_filepath = pkg_resources.resource_filename(package_name, pickle_filename)

class PercentileManager(object):
    ''' | *brief*: Provides access to percentile score distributions
        |     taking care of storage specifics.
        | *author*: Jivan
        | *created*: 2016-01-27
        | updated 2018-11-26 (JY)
    '''
    def __init__(self):
        with open(pickle_filepath, 'rb') as pfile:
            self.score_distributions = pickle.load(pfile)

    def get_distributions(self, allele):
        ''' | *brief*: Returns percentile distributions for the given allele.
            | *author*: Jivan
            | *created*: 2016-01-27
        '''
        return self.score_distributions

percentile_manager = PercentileManager()
