import pkg_resources
import pickle

package_name = 'mhcii_netmhcii_2_3_percentile_data'
pickle_filename = 'nn_align_percentile_distribution_2019-08-06.p'
pickle_filepath = pkg_resources.resource_filename(package_name, pickle_filename)

class PercentileManager(object):
    ''' Provides access to percentile score distributions
        taking care of storage specifics.

    '''
    def __init__(self):
        with open(pickle_filepath,'rb') as pfile:
            self.score_distributions = pickle.load(pfile)

    def get_distributions(self, allele):
        ''' Returns percentile distributions for the given allele.

        '''
        return self.score_distributions

percentile_manager = PercentileManager()
