'''
Created on Oct 11, 2019
@author: Yan
The code coverage by tests is 100%. (__init__.py)  
'''
from unittest import TestCase
import unittest
from mhcii_netmhcii_2_3_percentile_data import percentile_manager
'''
Name                                                                                                        Stmts   Miss  Cover
-------------------------------------------------------------------------------------------------------------------------------
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/__init__.py                         1607    988    39%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/__init__.py                    0      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/__about__.py        10      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/__init__.py          3      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/_compat.py          12      1    92%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/_structures.py      41     17    59%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/specifiers.py      281    201    28%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/version.py         150     78    48%
mhcii_netmhcii_2_3_percentile_data/__init__.py                                                                 12      0   100%
tests.py                                                                                                       34      0   100%
-------------------------------------------------------------------------------------------------------------------------------
TOTAL                                                                                                        2150   1285    40%
'''


class PercentileManagerTests(unittest.TestCase):
    def test_basic(self):
        method_name = 'nn_align'
        allele_name = 'DRB1_0101'
        binding_length = 15
        key = (method_name, allele_name, binding_length)

        score_distributions = percentile_manager.get_distributions(allele_name)

        self.assertIn(key, score_distributions)
        score_distribution = score_distributions[key]

        self.assertEqual(len(score_distribution), 280)
        expected_distribution = [2.0, 2.6, 2.6, 2.9, 2.9, 3.0, 3.0, 3.2, 3.2, 3.3, 3.4, 3.5, 3.5, 3.7, 3.9, 3.9, 3.9, 3.9, 3.9, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.1, 4.1, 4.2, 4.2, 4.2, 4.2, 4.3, 4.3, 4.3, 4.3, 4.3, 4.3, 4.3, 4.3, 4.4, 4.4, 4.5, 4.5, 4.5, 4.6, 4.6, 4.6, 4.7, 4.7, 4.7, 4.7, 4.8, 4.9, 4.9, 5.0, 5.0, 5.1, 5.1, 5.2, 5.2, 5.2, 5.2, 5.2, 5.3, 5.3, 5.3, 5.3, 5.3, 5.4, 5.4, 5.5, 5.6, 5.6, 5.7, 5.7, 5.7, 5.7, 5.7, 5.7, 5.8, 5.8, 5.8, 5.8, 5.8, 5.8, 5.8, 5.9, 5.9, 6.0, 6.0, 6.0, 6.1, 6.1, 6.1, 6.1, 6.1, 6.2, 6.2, 6.2, 6.3, 6.3, 6.5, 6.6, 6.8, 7.1, 7.2, 7.4, 7.6, 7.8, 8.0, 8.3, 8.8, 9.0, 9.2, 9.5, 9.7, 9.9, 10.0, 10.3, 10.5, 10.7, 10.9, 11.0, 11.2, 11.4, 11.7, 12.0, 12.2, 12.3, 12.5, 12.8, 13.1, 13.4, 13.7, 14.0, 14.3, 14.5, 14.8, 15.1, 15.4, 15.7, 15.9, 16.1, 16.3, 16.6, 16.9, 17.1, 17.2, 17.4, 17.7, 18.2, 18.6, 19.1, 19.3, 19.6, 19.8, 20.1, 20.3, 20.5, 20.7, 20.8, 21.1, 21.2, 21.6, 21.9, 22.3, 22.5, 22.8, 23.1, 23.5, 24.0, 24.2, 24.4, 24.6, 24.7, 25.0, 25.2, 25.6, 25.9, 26.3, 26.7, 26.9, 27.2, 27.5, 27.9, 28.0, 28.5, 28.9, 29.2, 29.4, 29.7, 32.8, 36.2, 39.6, 43.3, 47.5, 51.4, 55.6, 59.4, 64.6, 69.7, 75.2, 80.3, 86.2, 91.6, 98.4, 104.6, 110.2, 116.7, 124.4, 132.9, 140.4, 149.1, 157.4, 165.8, 176.5, 187.3, 199.0, 210.7, 221.4, 231.4, 244.8, 258.6, 272.7, 289.1, 304.9, 320.5, 338.4, 357.0, 374.5, 390.8, 410.1, 434.1, 459.8, 488.1, 509.7, 539.8, 566.8, 597.7, 637.2, 671.7, 711.4, 750.4, 789.8, 828.2, 873.4, 921.3, 966.4, 1022.0, 1074.1, 1138.5, 1209.0, 1281.5, 1352.3, 1426.9, 1497.1, 1582.5, 1676.5, 1790.1, 1900.6, 2023.2, 2154.5, 2295.1, 2473.6, 2659.8, 2864.4, 3073.9, 3331.6, 3610.3, 3906.9, 4290.9, 4741.2, 5204.6, 5824.5, 6619.4, 7569.1, 8562.0, 10239.9, 12572.4, 17189.6]
        self.assertEqual(score_distribution, expected_distribution)

    def test_length(self):
        allele_name = 'DRB1_0101'
        score_distributions = percentile_manager.get_distributions(allele_name)
        distribution = score_distributions[('nn_align', 'DRB1_0101', 20)]
        expected_distribution = [3.4, 4.4, 4.4, 4.5, 4.5, 4.5, 4.5, 4.6, 4.7, 4.7, 5.0, 5.0, 5.0, 5.1, 5.1, 5.3, 5.6, 5.8, 5.8, 5.9, 5.9, 5.9, 6.0, 6.3, 6.3, 6.3, 6.4, 6.5, 6.5, 6.7, 6.7, 6.9, 7.2, 7.4, 7.4, 7.4, 7.5, 7.8, 7.8, 8.0, 8.3, 8.4, 8.5, 8.5, 8.6, 8.6, 8.7, 8.9, 9.0, 9.1, 9.1, 9.2, 9.2, 9.2, 9.4, 9.4, 9.4, 9.4, 9.4, 9.5, 9.5, 9.5, 9.6, 9.6, 9.6, 9.7, 9.7, 9.8, 9.8, 9.9, 9.9, 10.0, 10.0, 10.0, 10.2, 10.4, 10.5, 10.5, 10.5, 10.7, 10.7, 10.7, 10.9, 11.0, 11.0, 11.0, 11.0, 11.0, 11.0, 11.1, 11.1, 11.2, 11.2, 11.2, 11.3, 11.3, 11.3, 11.4, 11.4, 11.4, 11.5, 12.4, 12.9, 13.5, 13.9, 14.8, 15.4, 15.6, 16.1, 16.5, 16.9, 17.5, 18.0, 18.6, 19.3, 19.6, 20.1, 20.8, 21.3, 21.8, 22.4, 22.7, 23.2, 23.6, 24.2, 24.5, 24.9, 25.4, 25.9, 26.5, 27.2, 27.7, 28.3, 28.8, 29.6, 30.1, 30.7, 31.3, 32.0, 32.4, 33.1, 33.4, 34.0, 34.4, 35.3, 35.9, 36.5, 36.9, 37.3, 37.8, 38.4, 39.0, 39.4, 40.1, 40.4, 40.9, 41.6, 42.2, 42.8, 43.5, 44.4, 44.9, 45.4, 46.1, 46.6, 47.0, 47.4, 48.0, 48.5, 49.5, 49.9, 50.4, 50.9, 51.5, 52.1, 52.5, 53.1, 53.7, 54.3, 54.8, 55.4, 56.4, 57.0, 58.2, 58.8, 59.3, 60.2, 60.7, 61.0, 61.5, 62.0, 69.5, 76.8, 83.4, 90.7, 98.1, 107.4, 116.1, 123.9, 132.9, 142.5, 151.3, 161.5, 170.9, 182.1, 193.0, 206.3, 218.3, 230.4, 243.0, 256.7, 269.8, 284.4, 299.7, 313.6, 328.0, 343.4, 360.5, 378.7, 398.3, 418.0, 439.9, 462.5, 483.0, 505.8, 528.1, 550.2, 576.6, 604.5, 632.5, 659.6, 688.8, 720.9, 751.6, 782.8, 820.5, 856.7, 895.4, 935.3, 981.1, 1017.2, 1068.9, 1129.7, 1174.7, 1232.4, 1294.4, 1352.9, 1419.9, 1481.0, 1558.2, 1624.1, 1708.9, 1787.8, 1878.9, 1966.3, 2060.3, 2178.0, 2290.5, 2421.2, 2558.2, 2696.7, 2833.9, 2981.8, 3142.7, 3361.2, 3542.7, 3772.3, 4017.6, 4268.5, 4531.9, 4947.3, 5308.0, 5715.5, 6247.3, 6861.0, 7581.7, 8582.4, 9988.9, 11605.8, 16065.6]
        self.assertEqual(distribution, expected_distribution)

    def test_H2(self):
        allele_name = 'H-2-IAs'
        score_distributions = percentile_manager.get_distributions(allele_name)
        distribution = score_distributions[('nn_align', 'H-2-IAs', 20)]
        expected_distribution = [62.4, 144.1, 230.9, 246.7, 255.7, 271.8, 291.5, 303.7, 306.0, 316.0, 324.8, 327.2, 327.6, 335.9, 337.1, 340.0, 346.7, 348.9, 352.2, 354.0, 357.6, 369.3, 406.0, 406.4, 406.6, 409.2, 413.2, 413.6, 416.8, 418.3, 420.0, 421.0, 421.8, 422.3, 438.6, 438.7, 457.3, 457.5, 462.4, 469.9, 486.6, 489.7, 490.5, 496.0, 496.6, 497.8, 499.3, 503.0, 512.2, 517.0, 517.7, 522.4, 534.3, 543.1, 544.7, 552.3, 552.6, 554.5, 559.5, 562.2, 566.4, 586.0, 586.3, 588.4, 590.5, 591.0, 592.6, 593.7, 604.2, 608.0, 612.5, 614.8, 615.2, 617.3, 621.2, 623.4, 623.7, 623.7, 627.3, 628.4, 638.7, 640.6, 642.3, 642.9, 646.6, 648.5, 653.6, 655.0, 656.5, 658.1, 663.8, 664.4, 664.6, 669.4, 672.7, 684.6, 685.5, 688.5, 690.9, 694.8, 696.4, 713.9, 744.7, 760.3, 772.4, 794.7, 825.0, 846.7, 873.1, 900.1, 922.2, 950.8, 967.1, 986.7, 992.6, 1024.9, 1041.0, 1066.9, 1089.1, 1103.7, 1117.9, 1138.2, 1154.0, 1172.0, 1185.2, 1198.2, 1209.5, 1221.3, 1235.6, 1249.2, 1261.8, 1275.7, 1288.6, 1303.1, 1313.1, 1321.9, 1331.4, 1351.1, 1361.8, 1378.3, 1399.2, 1409.9, 1424.5, 1440.5, 1453.5, 1469.0, 1483.1, 1492.5, 1502.6, 1510.3, 1528.8, 1542.5, 1547.4, 1558.9, 1573.2, 1582.4, 1592.9, 1602.3, 1614.8, 1621.6, 1631.6, 1640.6, 1647.9, 1660.0, 1667.8, 1673.0, 1678.4, 1693.2, 1705.3, 1713.7, 1720.4, 1736.0, 1747.1, 1755.8, 1768.6, 1776.6, 1794.4, 1804.8, 1813.3, 1824.6, 1830.6, 1840.8, 1852.4, 1863.8, 1875.6, 1888.8, 1901.5, 1911.4, 1921.2, 1926.5, 1935.1, 2035.3, 2134.7, 2244.7, 2351.2, 2444.9, 2538.1, 2627.8, 2731.5, 2820.0, 2906.3, 2999.8, 3087.1, 3173.7, 3261.9, 3334.5, 3407.6, 3494.8, 3590.7, 3673.8, 3745.1, 3840.6, 3924.6, 4021.0, 4110.5, 4204.7, 4320.3, 4403.1, 4496.1, 4597.5, 4698.9, 4794.2, 4899.5, 4979.8, 5077.2, 5180.3, 5275.2, 5381.0, 5478.5, 5587.7, 5694.4, 5794.5, 5905.6, 6004.6, 6107.5, 6224.6, 6346.8, 6473.4, 6591.7, 6706.0, 6835.3, 6978.5, 7120.8, 7237.0, 7389.8, 7518.1, 7665.2, 7823.6, 7957.0, 8121.1, 8232.2, 8373.4, 8536.9, 8696.5, 8869.4, 9054.2, 9225.7, 9399.1, 9573.9, 9775.8, 9967.1, 10191.4, 10414.5, 10674.4, 10918.2, 11164.2, 11469.5, 11797.1, 12104.4, 12420.1, 12806.5, 13188.3, 13639.2, 14216.9, 14733.3, 15496.2, 16074.3, 17143.6, 18728.4, 21199.6]
        self.assertEqual(distribution, expected_distribution)
    

    def test_key_error(self):
        allele_name = 'SLA-1*0401'
        score_distributions = percentile_manager.get_distributions(allele_name)
        with self.assertRaises(KeyError):
            distribution = score_distributions[('ann', 'SLA-1*0401', 9)]


if __name__ == '__main__':
    unittest.main()
