'''
Created on Oct 11, 2019
@author: Yan
The code coverage by tests is 100%. (__init__.py)  
'''
from unittest import TestCase
import unittest
from mhcii_predictor_data import get_method_allele_list

'''
$ coverage report
Name                                                                                                        Stmts   Miss  Cover
-------------------------------------------------------------------------------------------------------------------------------
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/__init__.py                         1607    988    39%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/__init__.py                    0      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/__about__.py        10      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/__init__.py          3      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/_compat.py          12      1    92%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/_structures.py      41     17    59%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/specifiers.py      281    201    28%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/version.py         150     78    48%
mhcii_predictor_data/__init__.py                                                                               11      0   100%
tests.py                                                                                                       17      0   100%
-------------------------------------------------------------------------------------------------------------------------------
TOTAL                                                                                                        2132   1285    40%
'''

class MHCIIPredictorDataTests(TestCase):

    def test_allele_consensus(self):
        allele_list = get_method_allele_list('consensus')
        expected_allele_list = 'H2-IAb\t1\t0\t1\t0\nH2-IAd\t1\t0\t1\t0\nH2-IAs\t0\t0\t0\t0\nH2-IEd\t0\t0\t1\t0\nDPA1*01-DPB1*04:01\t1\t1\t1\t0\nDPA1*01:03-DPB1*02:01\t1\t1\t1\t0\nDPA1*02:01-DPB1*01:01\t1\t1\t1\t0\nDPA1*02:01-DPB1*05:01\t1\t1\t1\t0\nDPA1*03:01-DPB1*04:02\t1\t1\t1\t0\nDQA1*01:01-DQB1*05:01\t1\t1\t1\t0\nDQA1*01:02-DQB1*06:02\t1\t1\t1\t0\nDQA1*03:01-DQB1*03:02\t1\t1\t1\t0\nDQA1*04:01-DQB1*04:02\t1\t1\t1\t0\nDQA1*05:01-DQB1*02:01\t1\t1\t1\t0\nDQA1*05:01-DQB1*03:01\t1\t1\t1\t0\n'
        self.assertTrue(expected_allele_list in allele_list)


    def test_recommended(self):
        allele_list = get_method_allele_list('recommended')
        expected_allele_list = 'H2-IAb\t0\t1\t0\t1\nH2-IAd\t0\t1\t0\t1\nH2-IAs\t0\t0\t0\t0\nH2-IEd\t0\t1\t0\t0\nDPA1*01-DPB1*04:01\t1\t1\t0\t0\nDPA1*01:03-DPB1*01:01\t0\t0\t0\t1\nDPA1*01:03-DPB1*02:01\t1\t1\t0\t1\nDPA1*01:03-DPB1*02:02\t0\t0\t0\t1\nDPA1*01:03-DPB1*03:01\t0\t0\t0\t1\nDPA1*01:03-DPB1*04:01\t0\t0\t0\t1\nDPA1*01:03-DPB1*04:02\t0\t0\t0\t1\nDPA1*01:03-DPB1*05:01\t0\t0\t0\t1\nDPA1*01:03-DPB1*06:01\t0\t0\t0\t1\nDPA1*01:03-DPB1*08:01\t0\t0\t0\t1\nDPA1*01:03-DPB1*09:01\t0\t0\t0\t1\nDPA1*01:03-DPB1*100:01\t0\t0\t0\t1\nDPA1*01:03-DPB1*10:01\t0\t0\t0\t1\nDPA1*01:03-DPB1*101:01\t0\t0\t0\t1\nDPA1*01:03-DPB1*102:01\t0\t0\t0\t1\nDPA1*01:03-DPB1*103:01\t0\t0\t0\t1\nDPA1*01:03-DPB1*104:01\t0\t0\t0\t1\nDPA1*01:03-DPB1*105:01\t0\t0\t0\t1\nDPA1*01:03-DPB1*106:01\t0\t0\t0\t1\nDPA1*01:03-DPB1*107:01\t0\t0\t0\t1\nDPA1*01:03-DPB1*108:01\t0\t0\t0\t1\nDPA1*01:03-DPB1*109:01\t0\t0\t0\t1\n'
        self.assertTrue(expected_allele_list in allele_list)


    def test_ValueError(self):
        with self.assertRaises(ValueError):
            allele_list = get_method_allele_list('nn_align')



if __name__ == '__main__':
    unittest.main()
