# This is the script used to convert the tepitope data files into a single
#   pickle file.
# TODO: Remove this after tepitope predictor data is removed from
#    'djangotools/tool_data/MHCII/tepitope'
import os
import re
import glob
import cPickle

original_dir = os.getcwd()
djangotools_dir = '/home/jivan/.projects/lji/djangotools'
data_dir = 'tool_data/MHCII/tepitope'
data_dir_full_path = os.path.join(djangotools_dir, data_dir)
os.chdir(data_dir_full_path)
data_dict = {}

for filename in glob.glob('*-9.txt'):
    pattern = '(.*)-9.txt'
    m = re.search(pattern, filename)
    allele_name = m.group(1)
    key = allele_name
    with open(filename) as old_pickle_file:
        ignored_length = cPickle.load(old_pickle_file)
        matrix = cPickle.load(old_pickle_file)
        ignored_offset = cPickle.load(old_pickle_file)
    data_dict[allele_name] = matrix

os.chdir(original_dir)

with open('tepitope_predictor_data_2016-01-29.p', 'w+') as pickle_file:
    cPickle.dump(data_dict, pickle_file)
