'''
Created on Feb 18, 2016

@author: jivan
'''
import tempfile
import re
import logging
import itertools
import os
from pkg_resources import resource_filename  # @UnresolvedImport
logger = logging.getLogger(__name__)

# --- The following sets up a variable 'EXECUTABLE_PATH' which holds the
#    full path to the NetMHCII-1.1 executable.

# The name of the package this file is a part of.
PACKAGE_NAME = 'netmhcii_11_executable'
# The NetMHCII executable name.
EXECUTABLE_NAME = 'netMHCII'
# Absolute path to the directory this package is installed in.
PACKAGE_DIR = os.path.normpath(os.path.join(__file__, os.path.pardir))
# Relative path to the executable
EXECUTABLE_RELPATH = resource_filename(PACKAGE_NAME, EXECUTABLE_NAME)
# Absolute path to the executable
EXECUTABLE_PATH = os.path.normpath(os.path.join(PACKAGE_DIR, EXECUTABLE_RELPATH))


def single_prediction(sequence, allele, length=15, sequence_list = None):
    try:
        length = int(length)
    except:
        raise TypeError('Invalid format of length: %s' % length)
    if length > len(sequence):
        raise ValueError('input sequence %s is shorter than input length: %s' % (sequence,length))
    ic50s = []

    infile = tempfile.NamedTemporaryFile(prefix='netmhcii-1.1_input_', mode='w')
    outfile = tempfile.NamedTemporaryFile(prefix='netmhcii-1.1_output_', mode='w')

    if sequence_list:
        for seq in sequence_list:
            infile.write(">test\n" + seq + "\n")
    else:
        infile.write(">test\n" + sequence + "\n")

    if not re.compile("H2").match(allele):
        allele = "HLA-%s" % allele.replace('*', '').replace(':', '')
    else:
        allele = allele.replace('H2', 'H-2')

    infile.seek(0)
    retcode = os.spawnl (os.P_WAIT, EXECUTABLE_PATH, "netMHCII", "-a", allele, "-l", str(length), infile.name, outfile.name)
    errmsg = None
    if retcode == 127:
        errmsg = 'Executable not found: {}'.format(EXECUTABLE_PATH)
    elif retcode != 0:
        errmsg = "SMM_align Predictor error.  Executable: %s, infile: %s, outfile: %s, RetCode: %s" % (EXECUTABLE_PATH, infile.name, outfile.name, retcode)

    if errmsg:
        raise Exception(errmsg)

    infile.close()

    outfile = open(outfile.name, "r")
    lines = outfile.readlines()
    outfile.close()

    all_lists = []
    newlist = [list(g) for k, g in itertools.groupby(lines, lambda x: re.match('-', x)) if not k]

    i = 2
    while i < len(newlist):
        all_lists.append(newlist[i])
        i = i + 3

    check_list = []
    for i in range(len(all_lists)):
        ic50s = []
        for l in all_lists[i]:
            mynewlist = l.split()
            allele = mynewlist[0]
            score = float(mynewlist[5])
            core = mynewlist[3]
            temp_list = (core, score)
            ic50s.append(temp_list)
        check_list.append(ic50s)

    outfile.close()
    return(check_list)
