import os
from setuptools import setup, find_packages

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))


# Get all of the Linux_x86_64/ data/ test/ files for use as package data
def recursive_walk(startdir):
    file_list = []
    for dirname, subdirList, fileList in os.walk(startdir, followlinks=True):
        if '.svn' in subdirList:
            subdirList.remove('.svn')
        if '.git' in subdirList:
            subdirList.remove('.git')
        for fname in fileList:
            file_list.append(os.path.join(dirname, fname))
            for sdname in subdirList:
                sdfiles = recursive_walk(sdname)
                file_list.extend(sdfiles)
    return file_list

pkg_data_files = ['netMHCIIpan', 'netMHCIIpan.1', 'NetMHCIIpan-3.2.pl', 'netMHCIIpan-3.2.readme']
os.chdir('netmhciipan_3_2_executable')

for subdir in ['data', 'Linux_x86_64', 'test']:
    file_list = recursive_walk(subdir)
    pkg_data_files.extend(file_list)
os.chdir(os.pardir)

with open(os.path.join(os.path.dirname(__file__), 'README.rst')) as readme:
    README = readme.read()

setup(
    name='netmhciipan-3.2-executable',
    version='3.2.1.3',
    author='Jason Yan',
    author_email='jyan@lji.org',
    packages=['netmhciipan_3_2_executable'],
    package_data={ 'netmhciipan_3_2_executable': pkg_data_files },
    test_suite = 'tests',
    description='Python package to provide netMHCIIpan-3.2 executable',
    long_description=README,
    install_requires=['allele-info>=3.8.0', 'iedbtools-utilities>=0.11.1'],
    keywords='T cell epitope prediction',
    classifiers=[
        'Intended Audience :: Developers',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python :: 3',
    ]
)

