'''
Created on Oct 2, 2019
@author: Yan
The code coverage by tests is 89%. (netmhciipan_python_interface.py)  
'''
from unittest import TestCase
import unittest
from netmhciipan_3_2_executable import single_prediction
from netmhciipan_3_2_executable.netmhciipan_python_interface import PredictionInput

'''
$ coverage report
Name                                                                                                        Stmts   Miss  Cover
-------------------------------------------------------------------------------------------------------------------------------
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/allele_info/__init__.py                              1      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/allele_info/allele_info.py                         262    211    19%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/iedbtools_utilities/__init__.py                      0      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/iedbtools_utilities/sequence_io.py                  86     69    20%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/__init__.py                         1607    988    39%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/__init__.py                    0      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/__about__.py        10      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/__init__.py          3      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/_compat.py          12      1    92%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/_structures.py      41     17    59%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/specifiers.py      281    201    28%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/version.py         150     78    48%
netmhciipan_3_2_executable/__init__.py                                                                          1      0   100%
netmhciipan_3_2_executable/netmhciipan_python_interface.py                                                     66      7    89%
tests.py                                                                                                       40      7    83%
-------------------------------------------------------------------------------------------------------------------------------
TOTAL                                                                                                        2560   1579    38%
'''

class TestNetMHCII11(TestCase):

    def test_HLA_prediction(self):
        sequence_list = ['ASSASSSSAAAAAAAT',]
        allele_length_2tuple_list = [('DRB1*13:02', 16),]
        result = single_prediction(sequence_list, allele_length_2tuple_list)
        expected_result = {PredictionInput(sequence='ASSASSSSAAAAAAAT', allele='DRB1*13:02', binding_length=16): [('ASSSSAAAA', 11049.71)]}
        self.assertEqual(result, expected_result)

    def test_H2_prediction(self):
        sequence_list = ['ASSASSSSAAAAAAAT',]
        allele_length_2tuple_list = [('H2-IAb', 15),]
        result = single_prediction(sequence_list, allele_length_2tuple_list)
        expected_result = {PredictionInput(sequence='ASSASSSSAAAAAAAT', allele='H2-IAb', binding_length=15): [('ASSSSAAAA', 122.06), ('SSSSAAAAA', 132.15)]}
        self.assertEqual(result, expected_result)

    def test_length(self):
        sequence_list = ['ASSASSSSAAAAAAAT',]
        allele_length_2tuple_list = [('H2-IAb', 10),]
        result = single_prediction(sequence_list, allele_length_2tuple_list)
        expected_result = {PredictionInput(sequence='ASSASSSSAAAAAAAT', allele='H2-IAb', binding_length=10): [('SSASSSSAA', 3483.82), ('SASSSSAAA', 3069.84), ('ASSSSAAAA', 2188.66), ('SSSSAAAAA', 1942.7), ('SSSAAAAAA', 1912.79), ('SSAAAAAAA', 1613.31), ('SAAAAAAAT', 1640.88)]}
        self.assertEqual(result, expected_result)

    def test_multiple_sequence(self):
        sequence_list = ['GHAHKVPRRLLKAAR', 'LKAADASADADGSGSGSGSG']
        allele_length_2tuple_list = [('DRB1*13:02', 15),]
        result = single_prediction(sequence_list, allele_length_2tuple_list)
        expected_result = {PredictionInput(sequence='GHAHKVPRRLLKAAR', allele='DRB1*13:02', binding_length=15): [('AHKVPRRLL', 2401.6)], PredictionInput(sequence='LKAADASADADGSGSGSGSG', allele='DRB1*13:02', binding_length=15): [('KAADASADA', 15174.2), ('ASADADGSG', 25287.0), ('ASADADGSG', 28657.67), ('ASADADGSG', 30172.92), ('ADADGSGSG', 31306.28), ('ADADGSGSG', 32981.55)]}
        self.assertEqual(result, expected_result)

    def test_delete_tempfiles(self):
        sequence_list = ['ASSASSSSAAAAAAAT',]
        allele_length_2tuple_list = [('DRB1*13:02', 16),]
        result = single_prediction(sequence_list, allele_length_2tuple_list, delete_tempfiles=True)
        expected_result = {PredictionInput(sequence='ASSASSSSAAAAAAAT', allele='DRB1*13:02', binding_length=16): [('ASSSSAAAA', 11049.71)]}
        self.assertEqual(result, expected_result)

    def test_ValueError(self):
        with self.assertRaises(ValueError):
            result = single_prediction('ASSASSSSAAAAAAAT', 'DRB1*13:02', 20)


if __name__ == '__main__':
    unittest.main()
