'''
Created on Oct 27, 2022
@author: Yan
The code coverage by tests is 87%. (netmhciipan_python_interface.py) 
'''
from unittest import TestCase
import unittest
from netmhciipan_4_1_executable import single_prediction

'''
$ coverage run tests.py
....
----------------------------------------------------------------------
Ran 4 tests in 0.375s

OK
$ coverage report
Name                                                                                                               Stmts   Miss  Cover
--------------------------------------------------------------------------------------------------------------------------------------
/home/jyan/.virtualenv/dev-python3.6/lib/python3.6/site-packages/allele_info/__init__.py                               1      0   100%
/home/jyan/.virtualenv/dev-python3.6/lib/python3.6/site-packages/allele_info/allele_info.py                          275    222    19%
/home/jyan/.virtualenv/dev-python3.6/lib/python3.6/site-packages/iedbtools_utilities/__init__.py                       0      0   100%
/home/jyan/.virtualenv/dev-python3.6/lib/python3.6/site-packages/iedbtools_utilities/sequence_io.py                   86     69    20%
/home/jyan/.virtualenv/dev-python3.6/lib/python3.6/site-packages/pkg_resources/__init__.py                          1552    899    42%
/home/jyan/.virtualenv/dev-python3.6/lib/python3.6/site-packages/pkg_resources/_vendor/__init__.py                     0      0   100%
/home/jyan/.virtualenv/dev-python3.6/lib/python3.6/site-packages/pkg_resources/_vendor/appdirs.py                    250    218    13%
/home/jyan/.virtualenv/dev-python3.6/lib/python3.6/site-packages/pkg_resources/_vendor/packaging/__about__.py         10      0   100%
/home/jyan/.virtualenv/dev-python3.6/lib/python3.6/site-packages/pkg_resources/_vendor/packaging/__init__.py           3      0   100%
/home/jyan/.virtualenv/dev-python3.6/lib/python3.6/site-packages/pkg_resources/_vendor/packaging/_compat.py           12      1    92%
/home/jyan/.virtualenv/dev-python3.6/lib/python3.6/site-packages/pkg_resources/_vendor/packaging/_structures.py       41     17    59%
/home/jyan/.virtualenv/dev-python3.6/lib/python3.6/site-packages/pkg_resources/_vendor/packaging/markers.py          130     73    44%
/home/jyan/.virtualenv/dev-python3.6/lib/python3.6/site-packages/pkg_resources/_vendor/packaging/requirements.py      72     25    65%
/home/jyan/.virtualenv/dev-python3.6/lib/python3.6/site-packages/pkg_resources/_vendor/packaging/specifiers.py       284    202    29%
/home/jyan/.virtualenv/dev-python3.6/lib/python3.6/site-packages/pkg_resources/_vendor/packaging/version.py          150     39    74%
/home/jyan/.virtualenv/dev-python3.6/lib/python3.6/site-packages/pkg_resources/_vendor/pyparsing.py                 2528   1423    44%
/home/jyan/.virtualenv/dev-python3.6/lib/python3.6/site-packages/pkg_resources/_vendor/six.py                        444    212    52%
/home/jyan/.virtualenv/dev-python3.6/lib/python3.6/site-packages/pkg_resources/extern/__init__.py                     33      5    85%
/home/jyan/.virtualenv/dev-python3.6/lib/python3.6/site-packages/pkg_resources/py2_warn.py                             6      0   100%
/home/jyan/.virtualenv/dev-python3.6/lib/python3.6/site-packages/pkg_resources/py31compat.py                          12      5    58%
netmhciipan_4_1_executable/__init__.py                                                                                 1      0   100%
netmhciipan_4_1_executable/netmhciipan_python_interface.py                                                            75     10    87%
tests.py                                                                                                              27      2    93%
--------------------------------------------------------------------------------------------------------------------------------------
TOTAL                                                                                                               5992   3422    43%                                                                                                 2171   1285    41%

'''

class TestNetMHCIIPan41(TestCase):

    def test_HLA_prediction(self):
        result = single_prediction(['ASSASSSSAAAAAAAT'], [('DRB1*13:02', 16)])
        expected_result = [[('ASSSSAAAA', 11848.64)]]
        result = list(result.values())
        self.assertEqual(result, expected_result)

    def test_H2_prediction(self):
        result = single_prediction(['ASSASSSSAAAAAAAT'], [('H2-IAb', 15)])
        expected_result = [[('ASSSSAAAA', 208.83), ('ASSSSAAAA', 244.11)]]
        result = [list(v) for k,v in result.items()]
        self.assertEqual(result, expected_result)

    def test_length(self):
        result = single_prediction(['ASSASSSSAAAAAAAT'], [('H2-IAb', 10)])
        expected_result = [[('SSASSSSAA', 14686.87), ('SASSSSAAA', 14469.04), ('ASSSSAAAA', 6707.7), ('SSSSAAAAA', 7441.73), ('SSSAAAAAA', 6616.3), ('SSAAAAAAA', 4989.17), ('SAAAAAAAT', 5883.69)]]
        result = [list(v) for k,v in result.items()]
        self.assertEqual(result, expected_result)

    def test_ValueError(self):
        with self.assertRaises(ValueError):
            result = single_prediction('ASSASSSSAAAAAAAT', 'DRB1*13:02', 20)
def main():
    result = single_prediction(['ASSASSSSAAAAAAAT'], [('DRB1*13:02', 16)])
    print(result)

if __name__ == '__main__':
    unittest.main()
    #main()
