with open('pseudosequence.2022.all.X.dat') as infile:

	for line in infile:
		
		allele = line.split()[0]

		if allele.startswith('DRB'):
			prefix, ending = allele.split("_")
			print(prefix + "*" + ending[:2] + ":" + ending[2:] + ' ' + allele)

		
		elif 'DQA' in allele:
			if allele.startswith('HLA-'):
				alpha, beta = allele.split("-")[1:]
				print("HLA-" + alpha[:4] + "*" + alpha[4:6] + ":" + alpha[6:] + "-" + beta[:4] + "*" + beta[4:6] + ":" + beta[6:] + ' ' + allele)
			else:
				
				alpha, beta = allele.split("-")
				print(alpha[:4] + "*" + alpha[4:6] + ":" + alpha[6:] + "-" + beta[:4] + "*" + beta[4:6] + ":" + beta[6:] + ' ' + allele)
		
		elif 'DPA' in allele:
	
			if allele.startswith('HLA-'):
                                alpha, beta = allele.split("-")[1:]
				
				# Take into account beta chains with more than four digits - extra digits must be in the first field (e.g. xxx:xx)
				beta_nums = beta[4:]
				first = len(beta_nums) - 2
				
                                print("HLA-" + alpha[:4] + "*" + alpha[4:6] + ":" + alpha[6:] + "-" + beta[:4] + "*" + beta[4:4+first] + ":" + beta[4+first:] + ' ' + allele)
                        else:
                                alpha, beta = allele.split("-")

				# Take into account beta chains with more than four digits - extra digits must be in the first field (e.g. xxx:xx)
                                beta_nums = beta[4:]
                                first = len(beta_nums) - 2

				print(alpha[:4] + "*" + alpha[4:6] + ":" + alpha[6:] + "-" + beta[:4] + "*" + beta[4:4+first] + ":" + beta[4+first:] + ' ' + allele)

		else:
			print(allele + ' ' +  allele)

