'''
Created on Dec 13, 2023
@author: Yan
'''
from unittest import TestCase
import unittest
from netmhciipan_4_2_executable import single_prediction

'''
 python tests.py
....
----------------------------------------------------------------------
Ran 4 tests in 0.978s

OK
'''

class TestNetMHCIIPan42(TestCase):
    maxDiff = None
    def test_HLA_prediction(self):
        result = single_prediction(['ASSASSSSAAAAAAAT'], [('DRB1*13:02', 16)])
        expected_result = [[('ASSSSAAAA', 11435.28)]]
        result = list(result.values())
        self.assertEqual(result, expected_result)

    def test_H2_prediction(self):
        result = single_prediction(['ASSASSSSAAAAAAAT'], [('H2-IAb', 15)])
        expected_result = [[('ASSSSAAAA', 149.19), ('ASSSSAAAA', 190.52)]]
        result = [list(v) for k,v in result.items()]
        self.assertEqual(result, expected_result)

    def test_length(self):
        result = single_prediction(['ASSASSSSAAAAAAAT'], [('H2-IAb', 10)])
        expected_result = [[('SSASSSSAA', 8224.89), ('SASSSSAAA', 9744.15), ('ASSSSAAAA', 3488.19), ('SSSSAAAAA', 3870.71), ('SSSAAAAAA', 3575.35), ('SSAAAAAAA', 2611.72), ('SAAAAAAAT', 3422.43)]]
        result = [list(v) for k,v in result.items()]
        self.assertEqual(result, expected_result)

    def test_ValueError(self):
        with self.assertRaises(ValueError):
            result = single_prediction('ASSASSSSAAAAAAAT', 'DRB1*13:02', 20)
def main():
    result = single_prediction(['ASSASSSSAAAAAAAT'], [('DRB1*13:02', 16)])
    print(result)

if __name__ == '__main__':
    unittest.main()
    #main()
