'''
Created on Dec 13, 2023
@author: Yan
'''
from unittest import TestCase
import unittest
from netmhciipan_4_3_executable import single_prediction

'''
 python tests.py
....
----------------------------------------------------------------------
Ran 4 tests in 0.978s

OK
'''

class TestNetMHCIIPan42(TestCase):
    maxDiff = None
    def test_HLA_prediction(self):
        result = single_prediction(['ASSASSSSAAAAAAAT'], [('DRB1*13:02', 16)])
        expected_result = [[('ASSSSAAAA', 19012.82)]]
        result = list(result.values())
        self.assertEqual(result, expected_result)

    def test_H2_prediction(self):
        result = single_prediction(['ASSASSSSAAAAAAAT'], [('H2-IAb', 15)])
        expected_result = [[('ASSSSAAAA', 223.31), ('SSSSAAAAA', 288.29)]]
        result = [list(v) for k,v in result.items()]
        self.assertEqual(result, expected_result)

    def test_length(self):
        result = single_prediction(['ASSASSSSAAAAAAAT'], [('H2-IAb', 10)])
        expected_result = [[('SSASSSSAA', 11223.1), ('SASSSSAAA', 10464.08), ('ASSSSAAAA', 3954.74), ('SSSSAAAAA', 4601.54), ('SSSAAAAAA', 5860.82), ('SSAAAAAAA', 5009.02), ('SAAAAAAAT', 5997.85)]]
        result = [list(v) for k,v in result.items()]
        self.assertEqual(result, expected_result)

    def test_ValueError(self):
        with self.assertRaises(ValueError):
            result = single_prediction('ASSASSSSAAAAAAAT', 'DRB1*13:02', 20)
def main():
    result = single_prediction(['ASSASSSSAAAAAAAT'], [('DRB1*13:02', 16)])
    print(result)

if __name__ == '__main__':
    unittest.main()
    #main()
